/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.EditableCellStyle;
import io.keikai.api.model.Sheet;
import io.keikai.model.CellRegion;
import io.keikai.ui.impl.undo.Abstract2DCellDataStyleAction;

public class AutoFillCellAction
extends Abstract2DCellDataStyleAction {
    private static final long serialVersionUID = -1425828318191238422L;
    private final Range.AutoFillType _fillType;

    public AutoFillCellAction(String label, Sheet sheet, int srcRow, int srcColumn, int srcLastRow, int srcLastColumn, Sheet destSheet, int destRow, int destColumn, int destLastRow, int destLastColumn, Range.AutoFillType fillType) {
        super(label, sheet, srcRow, srcColumn, srcLastRow, srcLastColumn, destSheet, destRow, destColumn, destLastRow, destLastColumn, 7);
        this._fillType = fillType;
    }

    @Override
    protected boolean isSheetProtected() {
        return this.isAnyCellProtected(this._destSheet, new CellRegion(this._destRow, this._destColumn, this._destLastRow, this._destLastColumn));
    }

    @Override
    protected void applyAction() {
        Range src = Ranges.range(this._sheet, this._row, this._column, this._lastRow, this._lastColumn);
        Range dest = Ranges.range(this._destSheet, this._destRow, this._destColumn, this._destLastRow, this._destLastColumn);
        CellOperationUtil.autoFill(src, dest, this._fillType);
        if (this.isDstSheetProtected()) {
            EditableCellStyle recoveredStyle = dest.getCellStyleHelper().createCellStyle(dest.getCellStyle());
            recoveredStyle.setLocked(false);
            dest.setCellStyle(recoveredStyle);
        }
    }
}

