/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api.model.impl;

import io.keikai.api.model.CellStyle;
import io.keikai.api.model.Color;
import io.keikai.api.model.impl.ColorImpl;
import io.keikai.api.model.impl.EnumUtil;
import io.keikai.api.model.impl.FontImpl;
import io.keikai.api.model.impl.ModelRef;
import io.keikai.api.model.impl.SimpleRef;
import io.keikai.model.SBook;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColor;
import io.keikai.model.SFont;
import java.io.Serializable;

public class CellStyleImpl
implements CellStyle,
Serializable {
    private static final long serialVersionUID = -8871372867390897750L;
    protected ModelRef<SBook> _bookRef;
    protected ModelRef<SCellStyle> _styleRef;
    protected FontImpl _font;

    public CellStyleImpl(ModelRef<SBook> book, ModelRef<SCellStyle> style) {
        this._bookRef = book;
        this._styleRef = style;
    }

    public SCellStyle getNative() {
        return this._styleRef.get();
    }

    public ModelRef<SCellStyle> getRef() {
        return this._styleRef;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._styleRef == null ? 0 : this._styleRef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CellStyleImpl other = (CellStyleImpl)obj;
        return !(this._styleRef == null ? other._styleRef != null : !this._styleRef.equals(other._styleRef));
    }

    @Override
    public FontImpl getFont() {
        if (this._font != null) {
            return this._font;
        }
        this._font = new FontImpl(this._bookRef, new SimpleRef<SFont>(this.getNative().getFont()));
        return this._font;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.getNative()).append("]");
        sb.append("font:[").append(this.getFont()).append("]");
        return sb.toString();
    }

    @Override
    public ColorImpl getBackgroundColor() {
        return this.getFillColor();
    }

    @Override
    public ColorImpl getBackColor() {
        SColor srcColor = this.getNative().getBackColor();
        return new ColorImpl(this._bookRef, new SimpleRef<SColor>(srcColor));
    }

    @Override
    public ColorImpl getFillColor() {
        SColor srcColor = this.getNative().getFillColor();
        return new ColorImpl(this._bookRef, new SimpleRef<SColor>(srcColor));
    }

    @Override
    public CellStyle.FillPattern getFillPattern() {
        return EnumUtil.toStyleFillPattern(this.getNative().getFillPattern());
    }

    @Override
    public CellStyle.Alignment getAlignment() {
        return EnumUtil.toStyleAlignemnt(this.getNative().getAlignment());
    }

    @Override
    public CellStyle.VerticalAlignment getVerticalAlignment() {
        return EnumUtil.toStyleVerticalAlignemnt(this.getNative().getVerticalAlignment());
    }

    @Override
    public boolean isWrapText() {
        return this.getNative().isWrapText();
    }

    @Override
    public CellStyle.BorderType getBorderLeft() {
        return EnumUtil.toStyleBorderType(this.getNative().getBorderLeft());
    }

    @Override
    public CellStyle.BorderType getBorderTop() {
        return EnumUtil.toStyleBorderType(this.getNative().getBorderTop());
    }

    @Override
    public CellStyle.BorderType getBorderRight() {
        return EnumUtil.toStyleBorderType(this.getNative().getBorderRight());
    }

    @Override
    public CellStyle.BorderType getBorderBottom() {
        return EnumUtil.toStyleBorderType(this.getNative().getBorderBottom());
    }

    @Override
    public Color getBorderTopColor() {
        return new ColorImpl(this._bookRef, new SimpleRef<SColor>(this.getNative().getBorderTopColor()));
    }

    @Override
    public Color getBorderLeftColor() {
        return new ColorImpl(this._bookRef, new SimpleRef<SColor>(this.getNative().getBorderLeftColor()));
    }

    @Override
    public Color getBorderBottomColor() {
        return new ColorImpl(this._bookRef, new SimpleRef<SColor>(this.getNative().getBorderBottomColor()));
    }

    @Override
    public Color getBorderRightColor() {
        return new ColorImpl(this._bookRef, new SimpleRef<SColor>(this.getNative().getBorderRightColor()));
    }

    @Override
    public String getDataFormat() {
        return this.getNative().getDataFormat();
    }

    @Override
    public boolean isLocked() {
        return this.getNative().isLocked();
    }

    @Override
    public boolean isHidden() {
        return this.getNative().isHidden();
    }
}

