/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.ModelEvent;
import io.keikai.model.ModelEvents;
import io.keikai.model.SBook;
import io.keikai.model.SName;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.model.SheetRegion;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.CellAttribute;
import io.keikai.range.impl.InsertDeleteUpdate;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;

public class NotifyChangeHelper {
    private static final Logger _logger = Logger.getLogger(NotifyChangeHelper.class.getName());

    public void notifyRowColumnSizeChange(Set<SheetRegion> notifySet) {
        for (SheetRegion notify : notifySet) {
            this.notifyRowColumnSizeChange(notify);
        }
    }

    public void notifyRowColumnSizeChange(SheetRegion notify) {
        ((AbstractBookAdv)notify.getSheet().getBook()).sendModelEvent(ModelEvents.createModelEvent("onRowColumnSizeChange", notify.getSheet(), new CellRegion(notify.getRow(), notify.getColumn(), notify.getLastRow(), notify.getLastColumn())));
    }

    public void notifySheetAutoFilterChange(SSheet sheet, STable table) {
        HashMap<Object, Object> data = new HashMap<Object, Object>(2);
        data.put("TABLE", table);
        Execution exec = Executions.getCurrent();
        String key = (table == null ? sheet.getId() : table.getName()) + "_KK_AFFECTED_ROWS";
        if (exec != null && (Boolean)exec.getAttribute("CONTAINS_" + key, false) != null) {
            Integer affectedRows = (Integer)exec.getAttribute(key, false);
            data.put(key, affectedRows);
            if (affectedRows > 0) {
                exec.setAttribute("CONTAINS_" + key, null, false);
                exec.setAttribute(key, null, false);
            }
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onAutoFilterChange", sheet, data));
    }

    public void notifySheetFreezeChange(SSheet sheet) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onFreezeChange", sheet));
    }

    public void notifySheetPictureAdd(SSheet sheet, String id) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onPictureAdd", sheet, ModelEvents.createDataMap("objid", id)));
    }

    public void notifySheetPictureDelete(SSheet sheet, String id) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onPictureDelete", sheet, ModelEvents.createDataMap("objid", id)));
    }

    public void notifySheetPictureMove(SSheet sheet, String id) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onPictureUpdate", sheet, ModelEvents.createDataMap("objid", id)));
    }

    public void notifySheetChartAdd(SSheet sheet, String id) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onChartAdd", sheet, ModelEvents.createDataMap("objid", id)));
    }

    public void notifySheetChartDelete(SSheet sheet, String id) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onChartDelete", sheet, ModelEvents.createDataMap("objid", id)));
    }

    public void notifySheetChartUpdate(SSheet sheet, String id) {
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onChartUpdate", sheet, ModelEvents.createDataMap("objid", id)));
    }

    public void notifyMergeRemove(Set<SheetRegion> toRemove) {
        for (SheetRegion notify : toRemove) {
            this.notifyMergeRemove(notify);
        }
    }

    public void notifyMergeRemove(SheetRegion notify) {
        SBook book = notify.getSheet().getBook();
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify remove merge " + notify.getReferenceString());
        }
        ((AbstractBookAdv)book).sendModelEvent(ModelEvents.createModelEvent("onMergeDelete", notify.getSheet(), notify.getRegion()));
    }

    public void notifyMergeSync(SheetRegion notify) {
        SBook book = notify.getSheet().getBook();
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify clear merge cache " + notify.getReferenceString());
        }
        ((AbstractBookAdv)book).sendModelEvent(ModelEvents.createModelEvent("onMergeSync", notify.getSheet(), notify.getRegion()));
    }

    public void notifyMergeAdd(Set<SheetRegion> toAdd) {
        for (SheetRegion notify : toAdd) {
            this.notifyMergeAdd(notify);
        }
    }

    public void notifyMergeAdd(SheetRegion notify) {
        SBook book = notify.getSheet().getBook();
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify add merge " + notify.getReferenceString());
        }
        ((AbstractBookAdv)book).sendModelEvent(ModelEvents.createModelEvent("onMergeAdd", notify.getSheet(), notify.getRegion()));
    }

    @Deprecated
    public void notifyCellChange(Set<SheetRegion> cellNotifySet) {
        this.notifyCellChange(cellNotifySet, CellAttribute.ALL);
    }

    @Deprecated
    public void notifyCellChange(SheetRegion notify) {
        this.notifyCellChange(notify, CellAttribute.ALL);
    }

    public void notifyCellChange(Set<SheetRegion> cellNotifySet, CellAttribute cellAttr) {
        for (SheetRegion notify : cellNotifySet) {
            this.notifyCellChange(notify, cellAttr);
        }
    }

    public void notifyCellChange(SheetRegion notify, CellAttribute cellAttr) {
        SBook book = notify.getSheet().getBook();
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify cell change " + notify.getReferenceString() + " of attribute " + cellAttr);
        }
        HashMap<String, Integer> attrMap = new HashMap<String, Integer>(2);
        attrMap.put("cellAttr", cellAttr.value);
        ((AbstractBookAdv)book).sendModelEvent(ModelEvents.createModelEvent("onCellChange", notify.getSheet(), notify.getRegion(), attrMap));
    }

    public void notifySheetDelete(SBook book, SSheet deletedSheet, int deletedIndex) {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify sheet delete " + deletedSheet.getSheetName() + ":" + deletedIndex);
        }
        ((AbstractBookAdv)book).sendModelEvent(ModelEvents.createModelEvent("onSheetDelete", book, ModelEvents.createDataMap("sheet", deletedSheet, "index", deletedIndex)));
    }

    public void notifySheetCreate(SSheet sheet) {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify sheet create " + sheet.getSheetName());
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onSheetCreate", sheet));
    }

    public void notifySheetNameChange(SSheet sheet, String oldName) {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify sheet name change " + oldName + " to " + sheet.getSheetName());
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onSheetNameChange", sheet, ModelEvents.createDataMap("oldName", oldName)));
    }

    public void notifySheetReorder(SSheet sheet, int oldIdx) {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify sheet reorder " + oldIdx + " to " + sheet.getBook().getSheetIndex(sheet));
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onSheetOrderChange", sheet, ModelEvents.createDataMap("oldIndex", oldIdx)));
    }

    public void notifySheetVisibleChange(SSheet sheet) {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify sheet visibile change: " + sheet.getSheetName() + " to " + sheet.getSheetVisible());
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onSheetVisibleChange", sheet));
    }

    public void notifyDataValidationChange(SSheet sheet, String validationId) {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify data validation change" + validationId);
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onDataValidationContentChange", sheet, ModelEvents.createDataMap("objid", validationId)));
    }

    public void notifyChartChange(SSheet sheet, String chartId) {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify chart change " + chartId);
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onChartContentChange", sheet, ModelEvents.createDataMap("objid", chartId)));
    }

    public void notifyCustomEvent(String customEventName, SSheet sheet, Object data) {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify custom event " + customEventName + ":" + data);
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent(customEventName, sheet, ModelEvents.createDataMap("customData", data)));
    }

    public void notifyDisplayGridlines(SSheet sheet, boolean show) {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify display gridlines " + show);
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onDisplayGridlinesChange", sheet, ModelEvents.createDataMap("enabled", show)));
    }

    public void notifyProtectSheet(SSheet sheet, boolean protect) {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify protect sheet " + sheet.getSheetName() + ":" + protect);
        }
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(ModelEvents.createModelEvent("onProtectSheetChange", sheet, ModelEvents.createDataMap("enabled", protect)));
    }

    public void notifyInsertDelete(List<InsertDeleteUpdate> insertDeleteNofitySet) {
        for (InsertDeleteUpdate update : insertDeleteNofitySet) {
            this.notifyInsertDelete(update);
        }
    }

    public void notifyInsertDelete(InsertDeleteUpdate update) {
        CellRegion region;
        String eventName;
        if (update.isRow()) {
            eventName = update.isInserted() ? "onRowInsert" : "onRowDelete";
            region = new CellRegion(update.getIndex(), 0, update.getLastIndex(), 0);
        } else {
            eventName = update.isInserted() ? "onColumnInsert" : "onColumnDelete";
            region = new CellRegion(0, update.getIndex(), 0, update.getLastIndex());
        }
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify InsertDelete " + eventName + ":" + region.getReferenceString());
        }
        SSheet sheet = update.getSheet();
        ModelEvent event = ModelEvents.createModelEvent(eventName, sheet, region);
        ((AbstractBookAdv)sheet.getBook()).sendModelEvent(event);
    }

    public void notifyNameNameChange(SSheet sheet, SName name, String oldName) {
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Notify Name's name change " + oldName + " to " + name.getName());
        }
        ((AbstractBookAdv)name.getBook()).sendModelEvent(ModelEvents.createModelEvent("onNameNameChange", name.getBook(), sheet, ModelEvents.createDataMap("oldName", oldName, "name", name)));
    }
}

