/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractBookSeriesAdv;
import io.keikai.model.impl.sys.DependencyTableAdv;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.dependency.DependencyTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SimpleBookSeriesImpl
extends AbstractBookSeriesAdv {
    private static final long serialVersionUID = 1L;
    private final AbstractBookAdv _book;
    private final DependencyTable _dependencyTable;
    private final ReadWriteLock _lock = new ReentrantReadWriteLock();
    private Map<String, Object> _attributes;

    public SimpleBookSeriesImpl(AbstractBookAdv book) {
        this._book = book;
        this._dependencyTable = EngineFactory.getInstance().createDependencyTable();
        ((DependencyTableAdv)this._dependencyTable).setBookSeries(this);
    }

    @Override
    public SBook getBook(String name) {
        return this._book.getBookName().equals(name) ? this._book : null;
    }

    @Override
    public DependencyTable getDependencyTable() {
        return this._dependencyTable;
    }

    @Override
    public ReadWriteLock getLock() {
        return this._lock;
    }

    @Override
    public List<SBook> getBooks() {
        ArrayList<AbstractBookAdv> books = new ArrayList<AbstractBookAdv>(1);
        books.add(this._book);
        return Collections.unmodifiableList(books);
    }

    @Override
    public Object getAttribute(String name) {
        return name != null ? this.getAttributeMap().get(name) : null;
    }

    @Override
    public Object setAttribute(String name, Object value) {
        if (name != null) {
            Map<String, Object> map = this.getAttributeMap();
            return value != null ? map.put(name, value) : map.remove(name);
        }
        return null;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.getAttributeMap());
    }

    private Map<String, Object> getAttributeMap() {
        if (this._attributes == null) {
            this._attributes = new LinkedHashMap<String, Object>();
        }
        return this._attributes;
    }
}

