/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SCellStyle;
import io.keikai.model.SSheet;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractCellStyleAdv;
import io.keikai.model.impl.AbstractColumnArrayAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.ModelUpdateUtil;
import io.keikai.model.impl.RefImpl;
import io.keikai.model.util.Validations;

public class ColumnArrayImpl
extends AbstractColumnArrayAdv {
    private static final long serialVersionUID = 1L;
    private AbstractSheetAdv _sheet;
    private AbstractCellStyleAdv _cellStyle;
    private Integer _width;
    private boolean _hidden = false;
    private boolean _customWidth = false;
    int _index;
    int _lastIndex;

    public ColumnArrayImpl(AbstractSheetAdv sheet, int index, int lastIndex) {
        this._sheet = sheet;
        this._index = index;
        this._lastIndex = lastIndex;
    }

    @Override
    public int getIndex() {
        this.checkOrphan();
        return this._index;
    }

    @Override
    public void checkOrphan() {
        if (this._sheet == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    @Override
    public void destroy() {
        this.checkOrphan();
        this._sheet = null;
    }

    @Override
    public SSheet getSheet() {
        this.checkOrphan();
        return this._sheet;
    }

    @Override
    public SCellStyle getCellStyle() {
        return this.getCellStyle(false);
    }

    @Override
    public SCellStyle getCellStyle(boolean local) {
        if (local || this._cellStyle != null) {
            return this._cellStyle;
        }
        this.checkOrphan();
        return this._sheet.getBook().getDefaultCellStyle();
    }

    @Override
    public void setCellStyle(SCellStyle cellStyle) {
        Validations.argInstance(cellStyle, AbstractCellStyleAdv.class);
        this._cellStyle = (AbstractCellStyleAdv)cellStyle;
    }

    @Override
    public int getWidth() {
        if (this._width != null) {
            return this._width;
        }
        this.checkOrphan();
        return this.getSheet().getDefaultColumnWidth();
    }

    @Override
    public boolean isHidden() {
        return this._hidden;
    }

    @Override
    public void setWidth(int width) {
        this._width = width;
    }

    @Override
    public void setHidden(boolean hidden) {
        if (this._hidden == hidden) {
            return;
        }
        this._hidden = hidden;
        SBook book = this._sheet.getBook();
        int row1 = this._sheet.getStartRowIndex();
        int row2 = this._sheet.getEndRowIndex();
        int col1 = this.getIndex();
        int col2 = this.getLastIndex();
        if (row1 >= 0 && row2 >= 0 && col1 >= 0 && col2 >= 0) {
            boolean includePrecedent = false;
            if (!((AbstractBookAdv)book).isPostProcessing()) {
                ModelUpdateUtil.handlePrecedentUpdate(book.getBookSeries(), new RefImpl(book.getBookName(), this._sheet.getSheetName(), row1, col1, row2, col2), false);
            }
        }
    }

    @Override
    public int getLastIndex() {
        return this._lastIndex;
    }

    @Override
    void setIndex(int index) {
        this._index = index;
    }

    @Override
    void setLastIndex(int lastIndex) {
        this._lastIndex = lastIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("[").append(this.getIndex()).append("-").append(this.getLastIndex()).append("]");
        return sb.toString();
    }

    @Override
    public boolean isCustomWidth() {
        return this._customWidth || this._width != null && this._width.intValue() != this.getSheet().getDefaultColumnWidth();
    }

    @Override
    public void setCustomWidth(boolean custom) {
        this._customWidth = custom;
    }

    ColumnArrayImpl cloneColumnArrayImpl(AbstractSheetAdv sheet) {
        return this.cloneColumnArray(sheet, null);
    }

    public boolean shouldSkip() {
        return !this.isCustomWidth() && this._cellStyle == null && !this._hidden;
    }

    ColumnArrayImpl cloneColumnArray(AbstractSheetAdv sheet, SBook book) {
        ColumnArrayImpl tgt = new ColumnArrayImpl(sheet, this._index, this._lastIndex);
        tgt._width = this._width;
        tgt._hidden = this._hidden;
        tgt._customWidth = this._customWidth;
        tgt._cellStyle = (AbstractCellStyleAdv)(this._cellStyle == null ? null : this._cellStyle.cloneCellStyle(book));
        return tgt;
    }
}

