/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api.impl;

import io.keikai.api.Importer;
import io.keikai.api.PostImport;
import io.keikai.api.model.Book;
import io.keikai.api.model.impl.BookImpl;
import io.keikai.api.model.impl.SimpleRef;
import io.keikai.model.SBook;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.range.SImporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;

public class ImporterImpl
implements Importer,
Serializable {
    private static final long serialVersionUID = 4040976617940828919L;
    private SImporter _importer;

    public ImporterImpl(SImporter importer) {
        this._importer = importer;
    }

    @Override
    public Book imports(InputStream is, String bookName) throws IOException {
        return this.imports(is, bookName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Book imports(InputStream is, String bookName, PostImport postImport) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("null inputstream");
        }
        if (bookName == null) {
            throw new IllegalArgumentException("null book name");
        }
        BookImpl book = new BookImpl(new SimpleRef<SBook>(this._importer.imports(is, bookName)));
        if (postImport != null) {
            try {
                ((AbstractBookAdv)book.getNative()).setPostProcessing(true);
                postImport.process(book);
            }
            finally {
                ((AbstractBookAdv)book.getNative()).setPostProcessing(false);
            }
        }
        return book;
    }

    public SImporter getNative() {
        return this._importer;
    }

    @Override
    public Book imports(File file, String bookName) throws IOException {
        return this.imports(file, bookName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Book imports(File file, String bookName, PostImport postImport) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null file");
        }
        if (bookName == null) {
            throw new IllegalArgumentException("null book name");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Book book = this.imports(is, bookName, postImport);
            return book;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Book imports(URL url, String bookName) throws IOException {
        return this.imports(url, bookName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Book imports(URL url, String bookName, PostImport postImport) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("null url");
        }
        if (bookName == null) {
            throw new IllegalArgumentException("null book name");
        }
        InputStream is = null;
        try {
            is = url.openStream();
            Book book = this.imports(is, bookName, postImport);
            return book;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

