/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl.sys.formula;

import io.keikai.model.SBook;
import io.keikai.model.impl.AbstractBookSeriesAdv;
import io.keikai.model.impl.AbstractNameAdv;
import io.keikai.model.impl.NameRefImpl;
import io.keikai.model.impl.RefImpl;
import io.keikai.model.impl.sys.DependencyTableAdv;
import io.keikai.model.impl.sys.formula.EvalBook;
import io.keikai.model.sys.dependency.IndirectRef;
import io.keikai.model.sys.dependency.Ref;
import java.util.Set;
import org.zkoss.poi.ss.formula.DependencyTracker;
import org.zkoss.poi.ss.formula.EvaluationWorkbook;
import org.zkoss.poi.ss.formula.LazyAreaEval;
import org.zkoss.poi.ss.formula.LazyRefEval;
import org.zkoss.poi.ss.formula.NameRangeEval;
import org.zkoss.poi.ss.formula.OperationEvaluationContext;
import org.zkoss.poi.ss.formula.eval.ErrorEval;
import org.zkoss.poi.ss.formula.eval.NameEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.ptg.Ptg;

public class DependencyTrackerImpl
implements DependencyTracker {
    public ValueEval postProcessValueEval(OperationEvaluationContext ec, ValueEval opResult, boolean eval) {
        if (eval && opResult instanceof NameEval) {
            return ErrorEval.NAME_INVALID;
        }
        return opResult;
    }

    public void addDependency(OperationEvaluationContext ec, Ptg[] ptgs) {
    }

    public void clearIndirectRefPrecedent(OperationEvaluationContext ec) {
        EvaluationWorkbook book = ec.getWorkbook();
        if (book instanceof EvalBook) {
            EvalBook evalBook = (EvalBook)book;
            SBook sbook = evalBook.getNBook();
            Ref dependent = (Ref)ec.getDependent();
            if (dependent == null) {
                String bookName = sbook.getBookName();
                String sheetName = ec.getSheetName();
                int row = ec.getRowIndex();
                int col = ec.getColumnIndex();
                dependent = new RefImpl(bookName, sheetName, row, col);
            }
            if (dependent != null) {
                AbstractBookSeriesAdv series = (AbstractBookSeriesAdv)sbook.getBookSeries();
                DependencyTableAdv table = (DependencyTableAdv)series.getDependencyTable();
                int ptgIndex = ec.getPtgIndex();
                Set<Ref> precedents = table.getDirectPrecedents(dependent);
                if (precedents != null) {
                    for (Ref precedent : precedents) {
                        if (precedent.getType() != Ref.RefType.INDIRECT || ((IndirectRef)precedent).getPtgIndex() != ptgIndex) continue;
                        table.clearDependents(precedent);
                        break;
                    }
                }
            }
        }
    }

    public void setIndirectRefPrecedent(OperationEvaluationContext ec, ValueEval preRef) {
        EvaluationWorkbook book = ec.getWorkbook();
        if (book instanceof EvalBook) {
            EvalBook evalBook = (EvalBook)book;
            SBook sbook = evalBook.getNBook();
            Ref dependent = (Ref)ec.getDependent();
            if (dependent == null) {
                String bookName = sbook.getBookName();
                String sheetName = ec.getSheetName();
                int row = ec.getRowIndex();
                int col = ec.getColumnIndex();
                dependent = new RefImpl(bookName, sheetName, row, col);
            }
            if (dependent != null) {
                AbstractBookSeriesAdv series = (AbstractBookSeriesAdv)sbook.getBookSeries();
                DependencyTableAdv table = (DependencyTableAdv)series.getDependencyTable();
                int ptgIndex = ec.getPtgIndex();
                Set<Ref> precedents = table.getDirectPrecedents(dependent);
                for (Ref precedent : precedents) {
                    if (precedent.getType() != Ref.RefType.INDIRECT || ((IndirectRef)precedent).getPtgIndex() != ptgIndex) continue;
                    RefImpl indirectPrecedent = null;
                    if (preRef instanceof NameRangeEval) {
                        AbstractNameAdv sname = (AbstractNameAdv)sbook.getName(((NameRangeEval)preRef).getNamePtg().getIndex());
                        indirectPrecedent = new NameRefImpl(sname);
                    } else if (preRef instanceof LazyRefEval) {
                        LazyRefEval refEval = (LazyRefEval)preRef;
                        indirectPrecedent = new RefImpl(refEval.getBookName(), refEval.getSheetName(), refEval.getLastSheetName(), refEval.getRow(), refEval.getColumn());
                    } else if (preRef instanceof LazyAreaEval) {
                        LazyAreaEval refEval = (LazyAreaEval)preRef;
                        indirectPrecedent = new RefImpl(refEval.getBookName(), refEval.getSheetName(), refEval.getLastSheetName(), refEval.getFirstRow(), refEval.getFirstColumn(), refEval.getLastRow(), refEval.getLastColumn());
                    }
                    table.add(precedent, indirectPrecedent);
                    break;
                }
            }
        }
    }
}

