/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.discovery.multicast.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.multicast.impl.MulticastDiscoverySerializationHelper;
import com.hazelcast.spi.discovery.multicast.impl.MulticastMemberInfo;
import java.net.DatagramPacket;
import java.net.MulticastSocket;

public class MulticastDiscoveryReceiver {
    private static final int DATAGRAM_BUFFER_SIZE = 65536;
    private final MulticastSocket multicastSocket;
    private final DatagramPacket datagramPacketReceive = new DatagramPacket(new byte[65536], 65536);
    private final ILogger logger;
    private final MulticastDiscoverySerializationHelper serializationHelper;

    public MulticastDiscoveryReceiver(MulticastSocket multicastSocket, ILogger logger, MulticastDiscoverySerializationHelper serializationHelper) {
        this.multicastSocket = multicastSocket;
        this.logger = logger;
        this.serializationHelper = serializationHelper;
    }

    public MulticastMemberInfo receive() {
        try {
            this.multicastSocket.receive(this.datagramPacketReceive);
            byte[] data = this.datagramPacketReceive.getData();
            return this.serializationHelper.deserialize(data);
        }
        catch (Exception e) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Couldn't get member info from multicast channel " + e.getMessage());
            }
            return null;
        }
    }
}

