/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline.file.impl;

import com.hazelcast.jet.pipeline.file.FileFormat;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class FileSourceConfiguration<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String path;
    private final String glob;
    private final FileFormat<T> format;
    private final boolean sharedFileSystem;
    private final boolean ignoreFileNotFound;
    private final Map<String, String> options;

    public FileSourceConfiguration(String path, String glob, FileFormat<T> format, boolean sharedFileSystem, boolean ignoreFileNotFound, Map<String, String> options) {
        this.path = Objects.requireNonNull(path);
        this.glob = Objects.requireNonNull(glob);
        this.format = Objects.requireNonNull(format);
        this.sharedFileSystem = sharedFileSystem;
        this.ignoreFileNotFound = ignoreFileNotFound;
        this.options = Objects.requireNonNull(options);
    }

    public String getPath() {
        return this.path;
    }

    public String getGlob() {
        return this.glob;
    }

    public FileFormat<T> getFormat() {
        return this.format;
    }

    public boolean isSharedFileSystem() {
        return this.sharedFileSystem;
    }

    public boolean isIgnoreFileNotFound() {
        return this.ignoreFileNotFound;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String toString() {
        return "FileSourceConfiguration{path='" + this.path + '\'' + ", glob='" + this.glob + '\'' + ", format=" + this.format + ", sharedFileSystem=" + this.sharedFileSystem + ", ignoreFileNotFound=" + this.ignoreFileNotFound + ", options=" + this.options + '}';
    }
}

