/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCustomCodec;
import com.hazelcast.client.impl.protocol.task.AuthenticationBaseMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.SimpleTokenCredentials;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;

public class AuthenticationCustomCredentialsMessageTask
extends AuthenticationBaseMessageTask<ClientAuthenticationCustomCodec.RequestParameters> {
    public AuthenticationCustomCredentialsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected ClientAuthenticationCustomCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        ClientAuthenticationCustomCodec.RequestParameters parameters = ClientAuthenticationCustomCodec.decodeRequest(clientMessage);
        assert (parameters.uuid != null);
        this.clientUuid = parameters.uuid;
        this.clusterName = parameters.clusterName;
        this.credentials = new SimpleTokenCredentials(parameters.credentials);
        this.clientSerializationVersion = parameters.serializationVersion;
        this.clientVersion = parameters.clientHazelcastVersion;
        this.clientName = parameters.clientName;
        this.labels = Collections.unmodifiableSet(new HashSet<String>(parameters.labels));
        return parameters;
    }

    @Override
    protected ClientMessage encodeAuth(byte status, Address thisAddress, UUID uuid, byte serializationVersion, String serverVersion, int partitionCount, UUID clusterId, boolean clientFailoverSupported, List<Integer> tpcPorts, byte[] tpcToken) {
        return ClientAuthenticationCustomCodec.encodeResponse(status, thisAddress, uuid, serializationVersion, serverVersion, partitionCount, clusterId, clientFailoverSupported);
    }

    @Override
    protected String getClientType() {
        return ((ClientAuthenticationCustomCodec.RequestParameters)this.parameters).clientType;
    }
}

