/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps.engine;

import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.spi.exception.ResponseAlreadySentException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationservice.Notifier;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.OperationRunnerImpl;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;

public final class StepResponseUtil {
    private StepResponseUtil() {
    }

    public static void sendResponse(State state) {
        assert (ThreadUtil.isRunningOnPartitionThread());
        MapOperation operation = state.getOperation();
        operation.applyState(state);
        int backupAcks = StepResponseUtil.handleBackup(state);
        Object response = operation.getResponse();
        if (backupAcks > 0) {
            response = new NormalResponse(response, operation.getCallId(), backupAcks, operation.isUrgent());
        }
        try {
            operation.sendResponse(response);
        }
        catch (ResponseAlreadySentException e) {
            StepResponseUtil.logOperationError(operation, e);
        }
        try {
            Notifier notifier;
            if (operation instanceof Notifier && (notifier = (Notifier)((Object)operation)).shouldNotify()) {
                ((NodeEngineImpl)state.getRecordStore().getMapContainer().getMapServiceContext().getNodeEngine()).getOperationParker().unpark(notifier);
            }
        }
        catch (Throwable e) {
            StepResponseUtil.logOperationError(operation, e);
        }
    }

    private static void logOperationError(Operation op, Throwable e) {
        if (e instanceof OutOfMemoryError) {
            OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)e);
        }
        op.logError(e);
    }

    private static int handleBackup(State state) {
        assert (state.getPartitionId() != -1);
        OperationService operationService = StepResponseUtil.getOperationService(state);
        OperationRunner runner = ((OperationServiceImpl)operationService).getOperationExecutor().getPartitionOperationRunners()[state.getPartitionId()];
        return ((OperationRunnerImpl)runner).getBackupHandler().sendBackups(state.getOperation());
    }

    private static OperationService getOperationService(State state) {
        MapContainer mapContainer = state.getOperation().getMapContainer();
        MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
        OperationService operationService = mapServiceContext.getNodeEngine().getOperationService();
        return operationService;
    }
}

