/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.util.JavaMajorVersion;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Arrays;

public enum JavaVersion implements JavaMajorVersion
{
    JAVA_8(8),
    JAVA_9(9),
    JAVA_10(10),
    JAVA_11(11),
    JAVA_12(12),
    JAVA_13(13),
    JAVA_14(14),
    JAVA_15(15),
    JAVA_16(16),
    JAVA_17(17),
    JAVA_18(18),
    JAVA_19(19),
    JAVA_20(20);

    public static final JavaMajorVersion UNKNOWN_VERSION;
    public static final JavaMajorVersion CURRENT_VERSION;
    private final int majorVersion;

    private JavaVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    @Override
    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public static boolean isAtLeast(JavaVersion version) {
        return JavaVersion.isAtLeast(CURRENT_VERSION, version);
    }

    public static boolean isAtMost(JavaVersion version) {
        return JavaVersion.isAtMost(CURRENT_VERSION, version);
    }

    static boolean isAtLeast(JavaMajorVersion currentVersion, JavaMajorVersion minVersion) {
        return currentVersion != UNKNOWN_VERSION && minVersion != UNKNOWN_VERSION && currentVersion.getMajorVersion() >= minVersion.getMajorVersion();
    }

    static boolean isAtMost(JavaMajorVersion currentVersion, JavaMajorVersion maxVersion) {
        return currentVersion != UNKNOWN_VERSION && maxVersion != UNKNOWN_VERSION && currentVersion.getMajorVersion() <= maxVersion.getMajorVersion();
    }

    static JavaMajorVersion detectCurrentVersion() {
        int major;
        ILogger logger = Logger.getLogger(JavaVersion.class);
        String version = System.getProperty("java.version");
        if (version == null) {
            JavaVersion.warn(logger, "java.version property is not set");
            return UNKNOWN_VERSION;
        }
        try {
            String[] components = version.split("[-+.]");
            major = Integer.parseInt(components[components[0].equals("1") ? 1 : 0]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            JavaVersion.warn(logger, "java.version property is in unknown format: " + version);
            return UNKNOWN_VERSION;
        }
        if (logger.isFineEnabled()) {
            logger.fine("Detected runtime version: Java " + major);
        }
        return Arrays.stream(JavaVersion.values()).filter(v -> v.getMajorVersion() == major).findFirst().orElseGet(() -> new FutureJavaVersion(major));
    }

    private static void warn(ILogger logger, String message) {
        logger.warning(message + ". You can specify argument -Djava.version=<version> to set the Java version when starting JVM.");
    }

    public static void main(String[] args) {
        System.out.println(CURRENT_VERSION.getMajorVersion());
    }

    static {
        UNKNOWN_VERSION = new UnknownVersion();
        CURRENT_VERSION = JavaVersion.detectCurrentVersion();
    }

    static class FutureJavaVersion
    implements JavaMajorVersion {
        private final int majorVersion;

        FutureJavaVersion(int majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        public Integer getMajorVersion() {
            return this.majorVersion;
        }
    }

    static class UnknownVersion
    implements JavaMajorVersion {
        UnknownVersion() {
        }

        @Override
        public Integer getMajorVersion() {
            return null;
        }
    }
}

