/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.jet.impl.SqlSummary;

public final class SqlSummaryCodec {
    private static final int UNBOUNDED_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 1;

    private SqlSummaryCodec() {
    }

    public static void encode(ClientMessage clientMessage, SqlSummary sqlSummary) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[1]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, sqlSummary.isUnbounded());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, sqlSummary.getQuery());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static SqlSummary decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        boolean unbounded = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        String query = StringCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createSqlSummary(query, unbounded);
    }
}

