/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.azure;

import com.hazelcast.azure.AzureAddress;
import com.hazelcast.azure.AzureAuthenticator;
import com.hazelcast.azure.AzureComputeApi;
import com.hazelcast.azure.AzureConfig;
import com.hazelcast.azure.AzureMetadataApi;
import com.hazelcast.azure.Tag;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.spi.utils.RetryUtils;
import java.util.Collection;
import java.util.logging.Logger;

class AzureClient {
    private static final Logger LOGGER = Logger.getLogger(AzureClient.class.getSimpleName());
    private static final int RETRIES = 2;
    private final AzureMetadataApi azureMetadataApi;
    private final AzureComputeApi azureComputeApi;
    private final AzureAuthenticator azureAuthenticator;
    private final AzureConfig azureConfig;
    private final Tag tag;
    private final String subscriptionId;
    private final String resourceGroup;
    private final String scaleSet;

    AzureClient(AzureMetadataApi azureMetadataApi, AzureComputeApi azureComputeApi, AzureAuthenticator azureAuthenticator, AzureConfig azureConfig) {
        this.azureMetadataApi = azureMetadataApi;
        this.azureComputeApi = azureComputeApi;
        this.azureAuthenticator = azureAuthenticator;
        this.azureConfig = azureConfig;
        this.subscriptionId = this.subscriptionIdFromConfigOrMetadataApi();
        this.resourceGroup = this.resourceGroupFromConfigOrMetadataApi();
        this.scaleSet = this.scaleSetFromConfigOrMetadataApi();
        this.tag = azureConfig.getTag();
    }

    private String subscriptionIdFromConfigOrMetadataApi() {
        if (!StringUtil.isNullOrEmptyAfterTrim(this.azureConfig.getSubscriptionId())) {
            return this.azureConfig.getSubscriptionId();
        }
        LOGGER.finest("Property 'subscriptionId' not configured, fetching from the VM metadata service");
        return RetryUtils.retry(this.azureMetadataApi::subscriptionId, 2);
    }

    private String resourceGroupFromConfigOrMetadataApi() {
        if (!this.azureConfig.isInstanceMetadataAvailable().booleanValue()) {
            return this.azureConfig.getResourceGroup();
        }
        LOGGER.finest("Property 'resourceGroup' not configured, fetching from the VM metadata service");
        return RetryUtils.retry(this.azureMetadataApi::resourceGroupName, 2);
    }

    private String scaleSetFromConfigOrMetadataApi() {
        if (!this.azureConfig.isInstanceMetadataAvailable().booleanValue()) {
            return this.azureConfig.getScaleSet();
        }
        LOGGER.finest("Property 'scaleSet' not configured, fetching from the VM metadata service");
        return RetryUtils.retry(this.azureMetadataApi::scaleSet, 2);
    }

    Collection<AzureAddress> getAddresses() {
        LOGGER.finest("Fetching OAuth Access Token");
        String accessToken = this.fetchAccessToken();
        LOGGER.finest(String.format("Fetching instances for subscription '%s' and resourceGroup '%s'", this.subscriptionId, this.resourceGroup));
        Collection<AzureAddress> addresses = this.azureComputeApi.instances(this.subscriptionId, this.resourceGroup, this.scaleSet, this.tag, accessToken);
        LOGGER.finest(String.format("Found the following instances for project '%s' and zone '%s': %s", this.subscriptionId, this.resourceGroup, addresses));
        return addresses;
    }

    private String fetchAccessToken() {
        if (this.azureConfig.isInstanceMetadataAvailable().booleanValue()) {
            return this.azureMetadataApi.accessToken();
        }
        return this.azureAuthenticator.refreshAccessToken(this.azureConfig.getTenantId(), this.azureConfig.getClientId(), this.azureConfig.getClientSecret());
    }

    String getAvailabilityZone() {
        String zone = this.azureMetadataApi.availabilityZone();
        if (StringUtil.isNullOrEmptyAfterTrim(zone)) {
            return this.azureMetadataApi.faultDomain();
        }
        return String.format("%s-%s", this.azureMetadataApi.location(), zone);
    }
}

