/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.factory;

import java.util.Properties;
import javax.activation.DataSource;
import javax.xml.bind.DatatypeConverter;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.FeedbackRequestWindow;
import org.adempiere.webui.factory.IFeedbackService;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.FeedbackManager;
import org.adempiere.webui.window.WEMailDialog;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.MUser;
import org.compiere.util.ByteArrayDataSource;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;

public class DefaultFeedbackService
implements IFeedbackService {
    @Override
    public void emailSupport(boolean errorOnly) {
        new EmailSupportAction(errorOnly);
    }

    @Override
    public void createNewRequest() {
        new CreateNewRequestAction();
    }

    private static String getCaptureScreenshotScript(String eventName, String uuid) {
        String script = "if (navigator.mediaDevices?.getDisplayMedia) {\n  const promise = navigator.mediaDevices.getDisplayMedia({ preferCurrentTab: true, displaySurface: 'browser' });\n  const canvas = document.createElement(\"canvas\");\n  const video = document.createElement(\"video\");\n  promise.then((stream) => {\n    video.srcObject = stream;\n    video.onloadedmetadata = () => {\n      video.play();      // Draw one video frame to canvas.\n      canvas.width = video.videoWidth;\n      canvas.height = video.videoHeight;\n      canvas.getContext(\"2d\").drawImage(video, 0, 0);\n      const dataUrl = canvas.toDataURL();\n      // stop capture\n      let tracks = video.srcObject.getTracks();\n      tracks.forEach((track) => track.stop());\n      video.srcObject = null;\n      //clean up\n      canvas.remove();\n      video.remove();\n      let widget = zk.Widget.$('#%s');\n      let event = new zk.Event(widget, '%s', dataUrl, {toServer: true});\n      zAu.send(event);\n     };\n  })\n  .catch((err) => {\n     console.log(err);\n     //clean up\n     canvas.remove();\n     video.remove();\n     html2canvas(document.body).then(canvas => \n     { const dataUrl = canvas.toDataURL();\n       let widget = zk.Widget.$('#%s');\n       let event = new zk.Event(widget, '%s', dataUrl, {toServer: true});\n       zAu.send(event);\n     });\n  });\n} else {\n  html2canvas(document.body).then(canvas => \n  { const dataUrl = canvas.toDataURL();\n    let widget = zk.Widget.$('#%s');\n    let event = new zk.Event(widget, '%s', dataUrl, {toServer: true});\n    zAu.send(event);\n  });\n}";
        return script.formatted(uuid, eventName, uuid, eventName, uuid, eventName);
    }

    protected static class CreateNewRequestAction
    implements EventListener<Event> {
        protected CreateNewRequestAction() {
            SessionManager.getAppDesktop().getComponent().addEventListener("onCreateFeedbackRequest", (EventListener)this);
            String script = DefaultFeedbackService.getCaptureScreenshotScript("onCreateFeedbackRequest", SessionManager.getAppDesktop().getComponent().getUuid());
            Clients.response((AuResponse)new AuScript(script));
        }

        public void onEvent(Event event) throws Exception {
            SessionManager.getAppDesktop().getComponent().removeEventListener("onCreateFeedbackRequest", (EventListener)this);
            String dataUrl = (String)event.getData();
            byte[] imageBytes = null;
            if (dataUrl != null && dataUrl.startsWith("data:image/png;base64,")) {
                try {
                    String img64 = dataUrl.substring("data:image/png;base64,".length()).trim();
                    imageBytes = DatatypeConverter.parseBase64Binary((String)img64);
                }
                catch (Exception exception) {}
            }
            this.showRequestDialog(imageBytes);
        }

        protected void showRequestDialog(byte[] imageBytes) {
            FeedbackRequestWindow window = new FeedbackRequestWindow();
            AEnv.showWindow(window);
            if (imageBytes != null && imageBytes.length > 0) {
                ByteArrayDataSource screenShot = new ByteArrayDataSource(imageBytes, "image/png");
                screenShot.setName("screenshot.png");
                window.addAttachment((DataSource)screenShot, true);
            }
            window.focus();
        }
    }

    protected static class EmailSupportAction
    implements EventListener<Event> {
        private boolean errorOnly;

        protected EmailSupportAction(boolean errorOnly) {
            this.errorOnly = errorOnly;
            SessionManager.getAppDesktop().getComponent().addEventListener("onEmailSupport", (EventListener)this);
            String script = DefaultFeedbackService.getCaptureScreenshotScript("onEmailSupport", SessionManager.getAppDesktop().getComponent().getUuid());
            Clients.response((AuResponse)new AuScript(script));
        }

        public void onEvent(Event event) throws Exception {
            SessionManager.getAppDesktop().getComponent().removeEventListener("onEmailSupport", (EventListener)this);
            String dataUrl = (String)event.getData();
            byte[] imageBytes = null;
            if (dataUrl != null && dataUrl.startsWith("data:image/png;base64,")) {
                try {
                    String img64 = dataUrl.substring("data:image/png;base64,".length()).trim();
                    imageBytes = DatatypeConverter.parseBase64Binary((String)img64);
                }
                catch (Exception exception) {}
            }
            this.showEmailDialog(imageBytes);
        }

        protected String getFeedbackSubject() {
            String feedBackHeader = Msg.getMsg((Properties)Env.getCtx(), (String)"FeedBackHeader");
            return Env.parseContext((Properties)Env.getCtx(), (int)0, (String)feedBackHeader, (boolean)false, (boolean)false);
        }

        protected void showEmailDialog(byte[] imageBytes) {
            String s;
            DataSource ds = FeedbackManager.getLogAttachment(this.errorOnly);
            WEMailDialog dialog = new WEMailDialog(Msg.getMsg((Properties)Env.getCtx(), (String)"EMailSupport"), MUser.get((Properties)Env.getCtx()), "", this.getFeedbackSubject(), "", ds);
            MSystem system = MSystem.get((Properties)Env.getCtx());
            String[] stringArray = this.getFeedbackRecipient("FEEDBACK_EMAIL_TO").split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                if (!Util.isEmpty((String)s.trim()) && EMail.validate((String)s.trim())) {
                    dialog.addTo(s.trim(), false);
                }
                ++n2;
            }
            if (Util.isEmpty((String)dialog.getTo()) && !Util.isEmpty((String)system.getSupportEMail())) {
                dialog.addTo(system.getSupportEMail(), true);
            }
            stringArray = this.getFeedbackRecipient("FEEDBACK_EMAIL_CC").split(",");
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                if (!Util.isEmpty((String)s.trim()) && EMail.validate((String)s.trim())) {
                    dialog.addCC(s.trim(), false);
                }
                ++n2;
            }
            AEnv.showWindow(dialog);
            if (imageBytes != null && imageBytes.length > 0) {
                ByteArrayDataSource screenShot = new ByteArrayDataSource(imageBytes, "image/png");
                screenShot.setName("screenshot.png");
                dialog.addAttachment((DataSource)screenShot, true);
            }
            dialog.focus();
        }

        protected String getFeedbackRecipient(String scValue) {
            String retValue = MSysConfig.getValue((String)scValue, (int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Org_ID((Properties)Env.getCtx()));
            return Util.isEmpty((String)retValue) ? "" : retValue;
        }
    }
}

