/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.adempiere.webui.ISupportMask;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Mask;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.desktop.IDesktop;
import org.adempiere.webui.session.SessionManager;
import org.compiere.util.Util;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuOuter;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Div;
import org.zkoss.zul.Grid;
import org.zkoss.zul.LayoutRegion;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Rows;
import org.zkoss.zul.Space;
import org.zkoss.zul.Window;

public final class LayoutUtils {
    public static final String ON_REDRAW_EVENT = "onRedraw";
    public static final int OVERLAP_TAB_PANEL = 1;
    public static final int OVERLAP_ALL_PAGE = 2;
    public static final int OVERLAP_PARENT = 3;
    public static final int OVERLAP_SELF = 4;
    private static final EventListener<OpenEvent> addSlideEventListener = evt -> {
        if (evt.isOpen()) {
            LayoutUtils.removeSclass("slide", (HtmlBasedComponent)evt.getTarget());
        } else {
            LayoutUtils.addSclass("slide", (HtmlBasedComponent)evt.getTarget());
        }
    };

    @Deprecated(forRemoval=true, since="11")
    public static void sendDeferLayoutEvent(Borderlayout layout, int timeout) {
    }

    public static void addSclass(String cls, HtmlBasedComponent target) {
        String sclass = target.getSclass();
        if (!LayoutUtils.hasSclass(cls, target)) {
            target.setSclass((String)(sclass == null ? cls : sclass + " " + cls));
        }
    }

    public static boolean hasSclass(String cls, HtmlBasedComponent target) {
        String sclass = target.getSclass();
        if (sclass == null) {
            sclass = "";
        }
        return cls == null || (" " + sclass + " ").indexOf(" " + cls + " ") > -1;
    }

    public static Component makeRightAlign(Label label) {
        Div div = new Div();
        div.setStyle("text-align: right");
        div.appendChild((Component)label);
        return div;
    }

    public static void openPopupWindow(Component ref, Window window) {
        LayoutUtils.openPopupWindow(ref, window, 0);
    }

    public static void openPopupWindow(Component ref, Window window, int delayMs) {
        LayoutUtils.openPopupWindow(ref, window, "overlap", delayMs);
    }

    public static void openPopupWindow(Component ref, Window window, String position) {
        LayoutUtils.openPopupWindow(ref, window, position, 0);
    }

    public static void openPopupWindow(Component ref, Window window, String position, int delayMs) {
        if (window.getPage() == null) {
            window.setPage(ref.getPage());
        }
        StringBuilder script = new StringBuilder();
        if (delayMs > 0) {
            script.append("setTimeout(function() { ");
        }
        script.append("idempiere.show_popup_window('#").append(ref.getUuid()).append("','#").append(window.getUuid()).append("','").append(position).append("'); ");
        script.append("zk.Widget.$('#").append(window.getUuid()).append("').focus(); ");
        if (delayMs > 0) {
            script.append(" }, ").append(delayMs).append(");");
        }
        window.doPopup();
        Clients.response((String)"_openPopupWindow_", (AuResponse)new AuScript((Component)window, script.toString()));
        window.focus();
    }

    public static void openOverlappedWindow(Component ref, Window window, String position) {
        if (window.getPage() == null) {
            window.setPage(ref.getPage());
        }
        StringBuilder script = new StringBuilder();
        script.append("idempiere.show_popup_window('#").append(ref.getUuid()).append("','#").append(window.getUuid()).append("','").append(position).append("');");
        window.doOverlapped();
        Clients.response((String)"_openPopupWindow_", (AuResponse)new AuScript((Component)window, script.toString()));
    }

    public static void positionWindow(Component ref, Window window, String position) {
        StringBuilder script = new StringBuilder();
        script.append("idempiere.show_popup_window('#").append(ref.getUuid()).append("','#").append(window.getUuid()).append("','").append(position).append("');");
        Clients.response((String)"_openPopupWindow_", (AuResponse)new AuScript((Component)window, script.toString()));
    }

    public static void positionComponent(Component ref, Component component, String position) {
        StringBuilder script = new StringBuilder();
        script.append("(function() {let w = zk('#").append(component.getUuid()).append("'); ").append("let ref=zk.Widget.$('#").append(ref.getUuid()).append("'); ").append("w.position(").append("ref.$n(),'").append(position).append("');})()");
        Clients.response((String)"_positionComponent_", (AuResponse)new AuScript(component, script.toString()));
    }

    public static void openEmbeddedWindow(Component ref, Window window, String position) {
        StringBuilder script = new StringBuilder();
        script.append("idempiere.show_popup_window('#").append(ref.getUuid()).append("','#").append(window.getUuid()).append("','").append(position).append("');");
        window.setVisible(true);
        window.setMode(Window.Mode.EMBEDDED);
        Clients.response((String)"_openEmbeddedWindow_", (AuResponse)new AuScript((Component)window, script.toString()));
    }

    public static void openHighlightedWindow(Component ref, Window window, String position) {
        StringBuilder script = new StringBuilder();
        script.append("idempiere.show_popup_window('#").append(ref.getUuid()).append("','#").append(window.getUuid()).append("','").append(position).append("');");
        window.setMode(Window.Mode.HIGHLIGHTED);
        Clients.response((String)"_openHighlightedWindow_", (AuResponse)new AuScript((Component)window, script.toString()));
    }

    public static void redraw(AbstractComponent component) {
        StringWriter writer = new StringWriter(1024);
        try {
            component.redraw((Writer)writer);
            Clients.response((AuResponse)new AuOuter((Component)component, writer.toString()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isReallyVisible(Component component) {
        if (!component.isVisible()) {
            return false;
        }
        Component parent = component.getParent();
        while (parent != null) {
            if (!parent.isVisible()) {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    public static void removeSclass(String cls, HtmlBasedComponent target) {
        Object sclass = target.getSclass();
        if (Util.isEmpty((String)sclass)) {
            return;
        }
        if (((String)(sclass = " " + (String)sclass + " ")).indexOf((String)(cls = " " + (String)cls + " ")) >= 0) {
            sclass = ((String)sclass).replace((CharSequence)cls, " ");
            sclass = ((String)sclass).trim();
            target.setSclass((String)sclass);
        }
    }

    public static ISupportMask showWindowWithMask(Window window, Component childOfOwn, int ownModel) {
        IDesktop desktop;
        ISupportMask ownWindow = null;
        if (ownModel == 4 && ISupportMask.class.isInstance(childOfOwn)) {
            ownWindow = (ISupportMask)childOfOwn;
        } else if (ownModel == 1) {
            ownWindow = LayoutUtils.findMaskParent(childOfOwn, Tabpanel.class);
        } else if (ownModel == 3) {
            ownWindow = LayoutUtils.findMaskParent(childOfOwn, null);
        } else if (ownModel == 2 && (desktop = SessionManager.getAppDesktop()) != null && ISupportMask.class.isInstance(desktop)) {
            ownWindow = (ISupportMask)((Object)desktop);
        }
        if (ownWindow != null) {
            LayoutUtils.showWindowWithMask(window, ownWindow);
        }
        return ownWindow;
    }

    protected static void showWindowWithMask(Window window, ISupportMask mask) {
        mask.showMask();
        mask.getMaskComponent().appendChild((Component)window);
        StringBuilder script = new StringBuilder("(function(){let w=zk.Widget.$('#");
        script.append(mask.getMaskComponent().getUuid()).append("');");
        script.append("let d=zk.Widget.$('#").append(window.getUuid()).append("');w.busy=d;");
        script.append("})()");
        Clients.response((AuResponse)new AuScript(script.toString()));
        LayoutUtils.openOverlappedWindow(mask.getMaskComponent(), window, "middle_center");
    }

    public static Mask showWindowWithMask(Window window, Component ownWindow, Mask mask) {
        if (mask == null) {
            mask = new Mask();
        }
        ownWindow.appendChild((Component)mask);
        ownWindow.appendChild((Component)window);
        LayoutUtils.openOverlappedWindow(ownWindow, window, "middle_center");
        return mask;
    }

    public static ISupportMask findMaskParent(Component child, Class<?> parentClass) {
        Component parent = child;
        ISupportMask trueParent = null;
        while (parent != null) {
            if (ISupportMask.class.isInstance(parent) && (parentClass == null || parentClass.isInstance(parent))) {
                trueParent = (ISupportMask)parent;
                break;
            }
            parent = parent.getParent();
        }
        return trueParent;
    }

    public static void compactTo(Grid grid, int limit) {
        Rows rows = grid.getRows();
        if (rows == null) {
            return;
        }
        org.zkoss.zul.Row currentRow = (org.zkoss.zul.Row)rows.getFirstChild();
        while (currentRow != null) {
            int size = 0;
            int extraStart = 0;
            for (Component component : currentRow.getChildren()) {
                if (component instanceof Cell) {
                    Cell cell = (Cell)component;
                    size += cell.getColspan();
                } else {
                    ++size;
                }
                if (size <= limit || extraStart != 0) continue;
                extraStart = currentRow.getChildren().indexOf(component);
            }
            org.zkoss.zul.Row nextRow = (org.zkoss.zul.Row)currentRow.getNextSibling();
            if (size > limit) {
                ArrayList<Component> extras = new ArrayList<Component>();
                int i = extraStart;
                while (i < currentRow.getChildren().size()) {
                    extras.add((Component)currentRow.getChildren().get(i));
                    ++i;
                }
                Row newRow = new Row();
                int spanOffset = 0;
                while (!extras.isEmpty()) {
                    Component component = (Component)extras.remove(0);
                    if (component instanceof Cell) {
                        spanOffset += ((Cell)component).getColspan() - 1;
                    }
                    newRow.appendChild(component);
                    if (newRow.getChildren().size() + spanOffset < limit) continue;
                    if (nextRow != null) {
                        rows.insertBefore((Component)newRow, (Component)nextRow);
                    } else {
                        rows.appendChild((Component)newRow);
                    }
                    newRow = new Row();
                }
                if (newRow.getChildren().size() > 0) {
                    if (nextRow != null) {
                        rows.insertBefore((Component)newRow, (Component)nextRow);
                    } else {
                        rows.appendChild((Component)newRow);
                    }
                }
            }
            currentRow = nextRow;
        }
    }

    public static void expandTo(Grid grid, int min) {
        LayoutUtils.expandTo(grid, min, false);
    }

    /*
     * Unable to fully structure code
     */
    public static void expandTo(Grid grid, int min, boolean fillWithSpace) {
        rows = grid.getRows();
        if (rows == null) {
            return;
        }
        currentRow = (org.zkoss.zul.Row)rows.getFirstChild();
        while (currentRow != null) {
            block8: {
                size = 0;
                for (Component component : currentRow.getChildren()) {
                    if (component instanceof Cell) {
                        cell = (Cell)component;
                        size += cell.getColspan();
                        continue;
                    }
                    ++size;
                }
                nextRow = (org.zkoss.zul.Row)currentRow.getNextSibling();
                if (size >= min) break block8;
                if (!fillWithSpace) ** GOTO lbl35
                cell = new Cell();
                cell.setColspan(min - size);
                cell.appendChild((Component)new Space());
                currentRow.appendChild((Component)cell);
                break block8;
lbl-1000:
                // 1 sources

                {
                    toAdd = new ArrayList<Component>();
                    for (Component c : nextRow.getChildren()) {
                        toAdd.add(c);
                        size = c instanceof Cell ? (size += ((Cell)c).getColspan()) : ++size;
                        if (size >= min) break;
                    }
                    for (Component c : toAdd) {
                        currentRow.appendChild(c);
                    }
lbl35:
                    // 2 sources

                    ** while (size < min && nextRow != null)
                }
lbl36:
                // 1 sources

                if (nextRow != null && nextRow.getChildren().isEmpty()) {
                    nextRow.detach();
                    continue;
                }
            }
            currentRow = nextRow;
        }
    }

    public static void addSlideSclass(LayoutRegion region) {
        region.addEventListener("onOpen", addSlideEventListener);
    }

    public static Popup findPopup(Component comp) {
        Component c = comp;
        while (c != null) {
            if (c instanceof Popup) {
                return (Popup)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public static void autoDetachOnClose(Popup popup) {
        popup.addEventListener("onOpen", e -> {
            if (!e.isOpen()) {
                popup.detach();
            }
        });
    }

    public static void sameWidth(HtmlBasedComponent target, HtmlBasedComponent ref) {
        StringBuilder script = new StringBuilder().append("(function(){let t=zk.Widget.$('#").append(target.getUuid()).append("');").append("let r=zk.Widget.$('#").append(ref.getUuid()).append("');").append("jq(t).css({'width':").append("jq(r).width()+'px'});").append("t.setWidth(\"").append("jq(r).width()+'px'\");");
        script.append("})()");
        Clients.response((String)"_sameWidth_", (AuResponse)new AuScript((Component)target, script.toString()));
    }
}

