/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Datebox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Urlbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WebEditorFactory;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.WPAttributeInstance;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MDocType;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Center;
import org.zkoss.zul.North;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;

public class WPAttributeDialog
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -7810825026970615029L;
    protected int m_WindowNo;
    protected MAttributeSetInstance m_masi;
    protected int m_M_AttributeSetInstance_ID;
    protected int m_M_Locator_ID;
    protected String m_M_AttributeSetInstanceName;
    protected int m_M_Product_ID;
    protected int m_C_BPartner_ID;
    protected int m_AD_Column_ID;
    protected int m_WindowNoParent;
    protected boolean m_productWindow = false;
    protected boolean m_changed = false;
    private static final CLogger log = CLogger.getCLogger(WPAttributeDialog.class);
    private int m_row = 0;
    protected ArrayList<WEditor> m_editors = new ArrayList();
    protected Checkbox cbNewEdit = new Checkbox();
    protected Button bNewRecord = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"NewRecord"));
    protected Listbox existingCombo = new Listbox();
    protected Button bSelect = new Button();
    protected Textbox fieldLotString = new Textbox();
    protected Listbox fieldLot = new Listbox();
    protected Button bLot = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"New"));
    protected Textbox fieldSerNo = new Textbox();
    protected Button bSerNo = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"New"));
    protected Datebox fieldGuaranteeDate = new Datebox();
    protected Textbox fieldDescription = new Textbox();
    protected Borderlayout mainLayout = new Borderlayout();
    protected Panel centerPanel = new Panel();
    protected Grid centerLayout = new Grid();
    protected Panel northPanel = new Panel();
    protected Grid northLayout = new Grid();
    protected ConfirmPanel confirmPanel = new ConfirmPanel(true);
    protected String m_columnName = null;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    protected boolean isAllowedToCreateAndUpdate = false;

    public WPAttributeDialog(int M_AttributeSetInstance_ID, int M_Product_ID, int C_BPartner_ID, boolean productWindow, int AD_Column_ID, int WindowNo) {
        this.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"M_AttributeSetInstance_ID"));
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 500);
        }
        this.setSclass("popup-dialog pattribute-dialog");
        this.setBorder("normal");
        this.setShadow(true);
        this.setSizable(true);
        this.setMaximizable(true);
        this.validadeRoleAccess();
        if (log.isLoggable(Level.CONFIG)) {
            log.config("M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID + ", M_Product_ID=" + M_Product_ID + ", C_BPartner_ID=" + C_BPartner_ID + ", ProductW=" + productWindow + ", Column=" + AD_Column_ID);
        }
        this.m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
        this.m_M_AttributeSetInstance_ID = M_AttributeSetInstance_ID;
        this.m_M_Product_ID = M_Product_ID;
        this.m_C_BPartner_ID = C_BPartner_ID;
        this.m_productWindow = productWindow;
        this.m_AD_Column_ID = AD_Column_ID;
        this.m_WindowNoParent = WindowNo;
        this.m_columnName = DB.getSQLValueString(null, (String)"SELECT ColumnName FROM AD_Column WHERE AD_Column_ID = ?", (int)this.m_AD_Column_ID);
        if (this.m_columnName == null || this.m_columnName.trim().length() == 0) {
            this.m_columnName = "M_AttributeSetInstance_ID";
        }
        try {
            this.init();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "VPAttributeDialog" + String.valueOf(ex));
        }
        if (!this.initAttributes()) {
            this.dispose();
            return;
        }
        AEnv.showCenterScreen(this);
    }

    private void init() throws Exception {
        this.mainLayout.setParent((Component)this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.mainLayout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.mainLayout, "min");
        if (ClientInfo.maxHeight(600)) {
            this.mainLayout.setStyle("max-height: 100%;");
        } else {
            this.mainLayout.setStyle("max-height: 600px;");
        }
        North north = new North();
        north.setSclass("dialog-content");
        north.setParent((Component)this.mainLayout);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.northPanel, "min");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.northPanel, "min");
        north.appendChild((Component)this.northPanel);
        Center center = new Center();
        center.setSclass("dialog-content");
        center.setParent((Component)this.mainLayout);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.centerPanel, "min");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.centerPanel, "min");
        center.appendChild((Component)this.centerPanel);
        center.setAutoscroll(true);
        South south = new South();
        south.setSclass("dialog-footer");
        south.setParent((Component)this.mainLayout);
        south.appendChild((Component)this.confirmPanel);
        this.centerPanel.appendChild((Component)this.centerLayout);
        this.centerLayout.setOddRowSclass("even");
        this.northPanel.appendChild((Component)this.northLayout);
        this.northLayout.setOddRowSclass("even");
        this.confirmPanel.addActionListener("onClick", this);
        this.addEventListener("onCancel", e -> this.onCancel());
    }

    private boolean initAttributes() {
        Label label;
        Row row;
        Columns columns = new Columns();
        columns.setParent((Component)this.centerLayout);
        Column column = new Column();
        column.setParent((Component)columns);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "30%");
        column = new Column();
        column.setParent((Component)columns);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "70%");
        Rows northRows = new Rows();
        northRows.setParent((Component)this.northLayout);
        Rows rows = new Rows();
        rows.setParent((Component)this.centerLayout);
        if (this.m_M_Product_ID == 0 && !this.m_productWindow) {
            return false;
        }
        MAttributeSet as = null;
        int M_AttributeSet_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNoParent, (String)"M_AttributeSet_ID");
        if (this.m_M_Product_ID != 0 && M_AttributeSet_ID == 0) {
            this.m_masi = MAttributeSetInstance.get((Properties)Env.getCtx(), (int)this.m_M_AttributeSetInstance_ID, (int)this.m_M_Product_ID);
            if (this.m_masi == null) {
                log.severe("No Model for M_AttributeSetInstance_ID=" + this.m_M_AttributeSetInstance_ID + ", M_Product_ID=" + this.m_M_Product_ID);
                return false;
            }
            Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"M_AttributeSet_ID", (int)this.m_masi.getM_AttributeSet_ID());
            as = this.m_masi.getMAttributeSet();
        } else {
            this.m_masi = new MAttributeSetInstance(Env.getCtx(), this.m_M_AttributeSetInstance_ID, M_AttributeSet_ID, null);
            as = this.m_masi.getMAttributeSet();
        }
        if (as == null) {
            Dialog.error(this.m_WindowNo, "PAttributeNoAttributeSet");
            return false;
        }
        if (!this.m_productWindow && !as.isInstanceAttribute()) {
            Dialog.error(this.m_WindowNo, "PAttributeNoInstanceAttribute");
            return false;
        }
        if (this.m_productWindow) {
            row = new Row();
            row.setParent((Component)northRows);
            Cell cell = new Cell();
            cell.setWidth("29%");
            this.cbNewEdit.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"EditRecord"));
            this.cbNewEdit.addEventListener("onCheck", this);
            cell.appendChild((Component)this.cbNewEdit);
            row.appendChild((Component)cell);
            KeyNamePair[] keyNamePairs = MAttributeSetInstance.getWithProductAttributeKeyNamePairs((int)as.getM_AttributeSet_ID(), (boolean)true);
            this.existingCombo.setMold("select");
            KeyNamePair[] keyNamePairArray = keyNamePairs;
            int n = keyNamePairs.length;
            int n2 = 0;
            while (n2 < n) {
                KeyNamePair pair = keyNamePairArray[n2];
                this.existingCombo.appendItem(pair.getName(), pair.getKey());
                ++n2;
            }
            this.existingCombo.addActionListener(this);
            row.appendChild((Component)this.existingCombo);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.existingCombo, "1");
            row = new Row();
            row.setParent((Component)northRows);
            LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.bNewRecord);
            this.bNewRecord.addActionListener(this);
            row.appendChild((Component)this.bNewRecord);
            row.appendChild((Component)new Space());
            MAttribute[] attributes = as.getMAttributes(false);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Product Attributes=" + attributes.length);
            }
            int i = 0;
            while (i < attributes.length) {
                this.addAttributeLine(rows, attributes[i], true, false);
                ++i;
            }
            if (this.m_M_AttributeSetInstance_ID > 0) {
                i = 0;
                while (i < this.existingCombo.getItemCount()) {
                    ListItem pp = this.existingCombo.getItemAtIndex(i);
                    if (pp.getValue() != null && (Integer)pp.getValue() == this.m_M_AttributeSetInstance_ID) {
                        this.existingCombo.setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
            }
        } else {
            row = new Row();
            if (this.m_M_AttributeSetInstance_ID == 0) {
                this.cbNewEdit.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"NewRecord"));
            } else {
                this.cbNewEdit.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"EditRecord"));
            }
            this.cbNewEdit.addEventListener("onCheck", this);
            row.appendChild((Component)this.cbNewEdit);
            this.bSelect.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"SelectExisting"));
            if (ThemeManager.isUseFontIconForImage()) {
                this.bSelect.setIconSclass("z-icon-PAttribute");
            } else {
                this.bSelect.setImage(ThemeManager.getThemeResource("images/PAttribute16.png"));
            }
            this.bSelect.addEventListener("onClick", this);
            row.appendChild((Component)this.bSelect);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.bSelect, "1");
            northRows.appendChild((Component)row);
            MAttribute[] attributes = as.getMAttributes(true);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Instance Attributes=" + attributes.length);
            }
            int i = 0;
            while (i < attributes.length) {
                this.addAttributeLine(rows, attributes[i], false, false);
                ++i;
            }
        }
        if (!this.m_productWindow && as.isLot()) {
            KeyNamePair[] keyNamePairs;
            row = new Row();
            row.setParent((Component)rows);
            ++this.m_row;
            label = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Lot"));
            row.appendChild(label.rightAlign());
            row.appendChild((Component)this.fieldLotString);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldLotString, "1");
            this.fieldLotString.setText(this.m_masi.getLot());
            String sql = "SELECT M_Lot_ID, Name FROM M_Lot l WHERE EXISTS (SELECT M_Product_ID FROM M_Product p WHERE p.M_AttributeSet_ID=" + this.m_masi.getM_AttributeSet_ID() + " AND p.M_Product_ID=l.M_Product_ID)  AND l.M_Product_ID = ? ";
            this.fieldLot = new Listbox();
            this.fieldLot.setMold("select");
            KeyNamePair[] keyNamePairArray = keyNamePairs = DB.getKeyNamePairsEx((String)sql, (boolean)true, (Object[])new Object[]{this.m_M_Product_ID});
            int n = keyNamePairs.length;
            int pp = 0;
            while (pp < n) {
                KeyNamePair pair = keyNamePairArray[pp];
                this.fieldLot.appendItem(pair.getName(), pair.getKey());
                ++pp;
            }
            label = new Label(Msg.translate((Properties)Env.getCtx(), (String)"M_Lot_ID"));
            row = new Row();
            row.setParent((Component)rows);
            ++this.m_row;
            row.appendChild(label.rightAlign());
            row.appendChild((Component)this.fieldLot);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldLot, "1");
            if (this.m_masi.getM_Lot_ID() != 0) {
                int i = 1;
                while (i < this.fieldLot.getItemCount()) {
                    ListItem pp2 = this.fieldLot.getItemAtIndex(i);
                    if (((Integer)pp2.getValue()).intValue() == this.m_masi.getM_Lot_ID()) {
                        this.fieldLot.setSelectedIndex(i);
                        this.fieldLotString.setReadonly(true);
                        break;
                    }
                    ++i;
                }
            }
            this.fieldLot.addEventListener("onSelect", this);
            if (this.m_masi.getMAttributeSet().getM_LotCtl_ID() != 0 && MRole.getDefault().isTableAccess(557, false) && MRole.getDefault().isTableAccess(556, false) && !this.m_masi.isExcludeLot(this.m_AD_Column_ID, Env.isSOTrx((Properties)Env.getCtx(), (int)this.m_WindowNoParent))) {
                row = new Row();
                row.setParent((Component)rows);
                ++this.m_row;
                row.appendChild((Component)this.bLot);
                this.bLot.addEventListener("onClick", this);
                LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.bLot);
            }
        }
        if (!this.m_productWindow && as.isSerNo()) {
            row = new Row();
            row.setParent((Component)rows);
            ++this.m_row;
            label = new Label(Msg.translate((Properties)Env.getCtx(), (String)"SerNo"));
            row.appendChild(label.rightAlign());
            row.appendChild((Component)this.fieldSerNo);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldSerNo, "1");
            this.fieldSerNo.setText(this.m_masi.getSerNo());
            if (this.m_masi.getMAttributeSet().getM_SerNoCtl_ID() != 0 && MRole.getDefault().isTableAccess(555, false) && !this.m_masi.isExcludeSerNo(this.m_AD_Column_ID, Env.isSOTrx((Properties)Env.getCtx(), (int)this.m_WindowNoParent))) {
                row = new Row();
                row.setParent((Component)rows);
                ++this.m_row;
                row.appendChild((Component)this.bSerNo);
                this.bSerNo.addEventListener("onClick", this);
                LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.bSerNo);
            }
        }
        if (!this.m_productWindow && as.isGuaranteeDate()) {
            row = new Row();
            row.setParent((Component)rows);
            ++this.m_row;
            label = new Label(Msg.translate((Properties)Env.getCtx(), (String)"GuaranteeDate"));
            if (this.m_M_AttributeSetInstance_ID == 0) {
                this.fieldGuaranteeDate.setValue(this.m_masi.getGuaranteeDate(true));
            } else {
                this.fieldGuaranteeDate.setValue(this.m_masi.getGuaranteeDate());
            }
            row.appendChild(label.rightAlign());
            row.appendChild((Component)this.fieldGuaranteeDate);
        }
        if (this.m_row == 0) {
            Dialog.error(this.m_WindowNo, "PAttributeNoInfo");
            return false;
        }
        this.cbNewEdit.setEnabled(this.isAllowedToCreateAndUpdate);
        if (!this.m_productWindow) {
            this.cbNewEdit.setChecked(this.m_M_AttributeSetInstance_ID == 0 && this.isAllowedToCreateAndUpdate);
            this.cmd_newEdit();
        } else {
            this.cbNewEdit.setSelected(false);
            this.cbNewEdit.setEnabled(this.m_M_AttributeSetInstance_ID > 0 && this.isAllowedToCreateAndUpdate);
            this.bNewRecord.setEnabled(this.m_M_AttributeSetInstance_ID > 0 && this.isAllowedToCreateAndUpdate);
            boolean rw = this.m_M_AttributeSetInstance_ID == 0;
            int i = 0;
            while (i < this.m_editors.size()) {
                WEditor editor = this.m_editors.get(i);
                editor.setReadWrite(rw && this.isAllowedToCreateAndUpdate);
                ++i;
            }
        }
        Label label2 = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
        this.fieldDescription.setText(this.m_masi.getDescription());
        this.fieldDescription.setReadonly(true);
        Row row2 = new Row();
        row2.setParent((Component)rows);
        row2.appendChild(label2.rightAlign());
        row2.appendChild((Component)this.fieldDescription);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldDescription, "1");
        return true;
    }

    private void addAttributeLine(Rows rows, MAttribute attribute, boolean product, boolean readOnly) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(attribute) + ", Product=" + product + ", R/O=" + readOnly);
        }
        ++this.m_row;
        WEditor editor = null;
        editor = "L".equals(attribute.getAttributeValueType()) ? WebEditorFactory.getEditor(this.getListTypeGridField(attribute), true) : ("N".equals(attribute.getAttributeValueType()) ? WebEditorFactory.getEditor(this.getNumberGridField(attribute), true) : ("R".equals(attribute.getAttributeValueType()) ? WebEditorFactory.getEditor(this.getGridField(attribute), true) : ("D".equals(attribute.getAttributeValueType()) ? WebEditorFactory.getEditor(this.getDateGridField(attribute), true) : ("C".equals(attribute.getAttributeValueType()) ? WebEditorFactory.getEditor(this.getMultiSelectionListTypeGridField(attribute), true) : WebEditorFactory.getEditor(this.getStringGridField(attribute), true)))));
        if (editor != null) {
            Row row = rows.newRow();
            Label label = editor.getLabel();
            if (label.getValue() == null || label.getValue().trim().length() < 1) {
                label.setValue(attribute.getName());
            }
            if (product) {
                label.setStyle("font-weight: bold");
            }
            row.appendChild(label.rightAlign());
            editor.setMandatory(attribute.isMandatory());
            editor.fillHorizontal();
            this.setEditorAttribute(attribute, editor);
            editor.addValueChangeListener(new ValueChangeListener(){

                @Override
                public void valueChange(ValueChangeEvent evt) {
                    WEditor sourceEditor;
                    if (evt.getSource() instanceof WEditor && (sourceEditor = (WEditor)evt.getSource()).getGridField().getDisplayType() == 40) {
                        ((Urlbox)sourceEditor.getComponent()).setText((String)evt.getNewValue());
                    }
                }
            });
            Component fieldEditor = editor.getComponent();
            row.appendChild(fieldEditor);
            editor.showMenu();
            if (readOnly) {
                editor.setReadWrite(false);
            } else {
                this.m_editors.add(editor);
            }
        }
    }

    public GridField getGridField(MAttribute attribute) {
        GridFieldVO vo = GridFieldVO.createParameter((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)AEnv.getADWindowID(this.m_WindowNo), (int)0, (int)0, (String)attribute.getName(), (String)Msg.translate((Properties)Env.getCtx(), (String)attribute.get_Translation("Name")), (int)attribute.getAD_Reference_ID(), (int)attribute.getAD_Reference_Value_ID(), (boolean)false, (boolean)false, null);
        if (attribute.isAttributeValueTypeReference() && DisplayType.isLookup((int)attribute.getAD_Reference_ID()) && attribute.getAD_Val_Rule_ID() > 0) {
            vo.ValidationCode = attribute.getAD_Val_Rule().getCode();
            if (vo.lookupInfo != null) {
                vo.lookupInfo.ValidationCode = vo.ValidationCode;
                vo.lookupInfo.IsValidated = false;
            }
        }
        return this.createGridField(attribute, vo);
    }

    public GridField getStringGridField(MAttribute attribute) {
        GridFieldVO vo = GridFieldVO.createParameter((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)AEnv.getADWindowID(this.m_WindowNo), (int)0, (int)0, (String)attribute.getName(), (String)Msg.translate((Properties)Env.getCtx(), (String)attribute.get_Translation("Name")), (int)10, (int)0, (boolean)false, (boolean)false, null);
        return this.createGridField(attribute, vo);
    }

    public GridField getNumberGridField(MAttribute attribute) {
        GridFieldVO vo = GridFieldVO.createParameter((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)AEnv.getADWindowID(this.m_WindowNo), (int)0, (int)0, (String)attribute.getName(), (String)Msg.translate((Properties)Env.getCtx(), (String)attribute.get_Translation("Name")), (int)22, (int)0, (boolean)false, (boolean)false, null);
        return this.createGridField(attribute, vo);
    }

    public GridField getDateGridField(MAttribute attribute) {
        GridFieldVO vo = GridFieldVO.createParameter((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)AEnv.getADWindowID(this.m_WindowNo), (int)0, (int)0, (String)attribute.getName(), (String)Msg.translate((Properties)Env.getCtx(), (String)attribute.get_Translation("Name")), (int)15, (int)0, (boolean)false, (boolean)false, null);
        return this.createGridField(attribute, vo);
    }

    private GridField getGridFieldForDisplayType(MAttribute attribute, int displayType) {
        GridFieldVO vo = GridFieldVO.createParameter((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)AEnv.getADWindowID(this.m_WindowNo), (int)0, (int)0, (String)"M_AttributeValue_ID", (String)attribute.getName(), (int)displayType, (int)0, (boolean)false, (boolean)false, null);
        vo.ValidationCode = "M_AttributeValue.M_Attribute_ID=" + attribute.get_ID();
        vo.lookupInfo.ValidationCode = vo.ValidationCode;
        vo.lookupInfo.IsValidated = false;
        return this.createGridField(attribute, vo);
    }

    private GridField getListTypeGridField(MAttribute attribute) {
        return this.getGridFieldForDisplayType(attribute, 19);
    }

    private GridField getMultiSelectionListTypeGridField(MAttribute attribute) {
        return this.getGridFieldForDisplayType(attribute, 200162);
    }

    private GridField createGridField(MAttribute attribute, GridFieldVO vo) {
        String desc = attribute.get_Translation("Description");
        vo.Description = desc != null ? desc : "";
        return new GridField(vo);
    }

    public void updateAttributeEditor(MAttribute attribute, int index) {
        WEditor editor = this.m_editors.get(index);
        if (editor != null) {
            this.setEditorAttribute(attribute, editor);
        }
    }

    public void setEditorAttribute(MAttribute attribute, WEditor editor) {
        MAttributeInstance instance = attribute.getMAttributeInstance(this.m_M_AttributeSetInstance_ID);
        if (instance != null) {
            if ("L".equals(attribute.getAttributeValueType())) {
                if (instance.getM_AttributeValue_ID() > 0) {
                    editor.setValue(instance.getM_AttributeValue_ID());
                }
            } else if ("C".equals(attribute.getAttributeValueType())) {
                if (!Util.isEmpty((String)instance.getValueMultipleSelection())) {
                    editor.setValue(instance.getValueMultipleSelection());
                }
            } else {
                int displayType = editor.getGridField().getDisplayType();
                if (displayType == 15 || displayType == 16 || displayType == 24) {
                    if (instance.getValueDate() != null) {
                        editor.setValue(instance.getValueDate());
                    }
                } else if (displayType == 32 || displayType == 33 || displayType == 31 || displayType == 19 || displayType == 18 || displayType == 30 || displayType == 25) {
                    if (instance.getValueInt() > 0) {
                        editor.setValue(instance.getValueInt());
                    }
                } else if (displayType == 11) {
                    editor.setValue(instance.getValueInt());
                } else if (DisplayType.isNumeric((int)displayType)) {
                    if (instance.getValueNumber() != null) {
                        editor.setValue(instance.getValueNumber());
                    }
                } else if (instance.getValue() != null) {
                    editor.setValue(instance.getValue());
                }
            }
        }
    }

    @Override
    public void dispose() {
        Env.clearWinContext((int)this.m_WindowNo);
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNoParent, (int)1113, (String)this.m_columnName, (String)String.valueOf(this.m_M_AttributeSetInstance_ID));
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNoParent, (int)1113, (String)"M_Locator_ID", (String)String.valueOf(this.m_M_Locator_ID));
        this.detach();
    }

    public void onEvent(Event e) throws Exception {
        if (e.getTarget() == this.bSelect) {
            this.cmd_select();
        } else if (e.getTarget() == this.cbNewEdit) {
            if (this.m_productWindow) {
                this.cmd_edit();
            } else {
                this.cmd_newEdit();
            }
        } else if (e.getTarget() == this.bNewRecord) {
            this.cmd_newRecord();
        } else if (e.getTarget() == this.existingCombo) {
            this.cmd_existingCombo();
        } else if (e.getTarget() == this.fieldLot) {
            ListItem pp = this.fieldLot.getSelectedItem();
            if (pp != null && (Integer)pp.getValue() != -1) {
                this.fieldLotString.setText(pp.getLabel());
                this.fieldLotString.setReadonly(true);
                this.m_masi.setM_Lot_ID(((Integer)pp.getValue()).intValue());
            } else {
                this.fieldLotString.setReadonly(false);
                this.m_masi.setM_Lot_ID(0);
            }
        } else if (e.getTarget() == this.bLot) {
            KeyNamePair pp = this.m_masi.createLot(this.m_M_Product_ID);
            if (pp != null) {
                ListItem item = new ListItem(pp.getName(), pp.getKey());
                this.fieldLot.appendChild((Component)item);
                this.fieldLot.setSelectedItem(item);
                this.fieldLotString.setText(this.m_masi.getLot());
                this.fieldLotString.setReadonly(true);
            }
        } else if (e.getTarget() == this.bSerNo) {
            this.fieldSerNo.setText(this.m_masi.getSerNo(true));
        } else if (e.getTarget().getId().equals("Ok")) {
            if (this.isAllowedToCreateAndUpdate && this.saveSelection()) {
                this.dispose();
            }
        } else if (e.getTarget().getId().equals("Cancel")) {
            this.onCancel();
        } else {
            log.log(Level.SEVERE, "not found - " + String.valueOf(e));
        }
    }

    protected void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.m_changed = false;
        this.m_M_AttributeSetInstance_ID = 0;
        this.m_M_Locator_ID = 0;
        this.dispose();
    }

    protected void cmd_existingCombo() {
        ListItem pp = this.existingCombo.getSelectedItem();
        if (pp != null && (Integer)pp.getValue() != -1) {
            this.m_M_AttributeSetInstance_ID = (Integer)pp.getValue();
            this.m_masi = MAttributeSetInstance.get((Properties)Env.getCtx(), (int)this.m_M_AttributeSetInstance_ID, (int)this.m_M_Product_ID);
            MAttributeSet as = this.m_masi.getMAttributeSet();
            MAttribute[] attributes = as.getMAttributes(false);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Product Attributes=" + attributes.length);
            }
            int i = 0;
            while (i < attributes.length) {
                this.updateAttributeEditor(attributes[i], i);
                ++i;
            }
            this.cbNewEdit.setEnabled(this.isAllowedToCreateAndUpdate);
            this.cbNewEdit.setSelected(false);
            this.bNewRecord.setEnabled(this.isAllowedToCreateAndUpdate);
            this.cmd_edit();
        }
    }

    protected void cmd_newRecord() {
        this.cbNewEdit.setSelected(false);
        this.cbNewEdit.setEnabled(false);
        this.bNewRecord.setEnabled(false);
        this.existingCombo.setSelectedItem(null);
        this.m_M_AttributeSetInstance_ID = 0;
        int M_AttributeSet_ID = this.m_masi.getM_AttributeSet_ID();
        this.m_masi = new MAttributeSetInstance(Env.getCtx(), this.m_M_AttributeSetInstance_ID, M_AttributeSet_ID, null);
        int i = 0;
        while (i < this.m_editors.size()) {
            WEditor editor = this.m_editors.get(i);
            editor.setReadWrite(true);
            editor.setValue(null);
            ++i;
        }
        this.fieldDescription.setText("");
    }

    protected void cmd_edit() {
        boolean check = this.cbNewEdit.isSelected();
        int i = 0;
        while (i < this.m_editors.size()) {
            WEditor editor = this.m_editors.get(i);
            editor.setReadWrite(check);
            ++i;
        }
    }

    protected void cmd_select() {
        Object title;
        int M_Locator_ID;
        int M_Warehouse_ID;
        block8: {
            MDocType doctype;
            String docbase;
            M_Warehouse_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNoParent, (String)"M_Warehouse_ID");
            int C_DocType_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNoParent, (String)"C_DocType_ID");
            if (C_DocType_ID > 0 && ((docbase = (doctype = new MDocType(Env.getCtx(), C_DocType_ID, null)).getDocBaseType()).equals("MMR") || "CA".equals(doctype.getDocSubTypeInv()))) {
                M_Warehouse_ID = 0;
            }
            M_Locator_ID = 0;
            if (this.m_AD_Column_ID == 8551) {
                M_Locator_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.m_WindowNoParent, (String)"M_Locator_ID", (boolean)true);
            }
            title = "";
            String sql = "SELECT p.Name, w.Name, w.M_Warehouse_ID FROM M_Product p, M_Warehouse w WHERE p.M_Product_ID=? AND w.M_Warehouse_ID" + (M_Locator_ID <= 0 ? "=?" : " IN (SELECT M_Warehouse_ID FROM M_Locator where M_Locator_ID=?)");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.m_M_Product_ID);
                    pstmt.setInt(2, M_Locator_ID <= 0 ? M_Warehouse_ID : M_Locator_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        title = rs.getString(1) + " - " + rs.getString(2);
                        M_Warehouse_ID = rs.getInt(3);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        final WPAttributeInstance pai = new WPAttributeInstance((String)title, M_Warehouse_ID, M_Locator_ID, this.m_M_Product_ID, this.m_C_BPartner_ID);
        pai.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (pai.getM_AttributeSetInstance_ID() != -1) {
                    WPAttributeDialog.this.m_M_AttributeSetInstance_ID = pai.getM_AttributeSetInstance_ID();
                    WPAttributeDialog.this.m_M_AttributeSetInstanceName = pai.getM_AttributeSetInstanceName();
                    WPAttributeDialog.this.m_M_Locator_ID = pai.getM_Locator_ID();
                    WPAttributeDialog.this.m_changed = true;
                    WPAttributeDialog.this.dispose();
                }
            }
        });
    }

    protected void cmd_newEdit() {
        boolean rw;
        boolean bl = rw = this.cbNewEdit.isChecked() && this.isAllowedToCreateAndUpdate;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("R/W=" + rw + " " + String.valueOf(this.m_masi));
        }
        this.fieldLotString.setReadonly(!rw || this.m_masi.getM_Lot_ID() != 0);
        if (this.fieldLot != null) {
            this.fieldLot.setEnabled(rw);
        }
        this.bLot.setEnabled(rw);
        this.fieldSerNo.setReadonly(!rw);
        this.bSerNo.setEnabled(rw);
        this.fieldGuaranteeDate.setReadonly(!rw);
        int i = 0;
        while (i < this.m_editors.size()) {
            WEditor editor = this.m_editors.get(i);
            editor.setReadWrite(rw);
            ++i;
        }
    }

    protected boolean saveSelection() {
        MAttributeSet as = this.m_masi.getMAttributeSet();
        if (as == null) {
            return true;
        }
        Trx trx = null;
        Object mandatory = "";
        try {
            String text;
            String trxName = Trx.createTrxName((String)"WPAD");
            trx = Trx.get((String)trxName, (boolean)false);
            trx.setDisplayName(this.getClass().getName() + "_saveSelection");
            this.m_masi.set_TrxName(trxName);
            as.set_TrxName(trxName);
            this.m_changed = false;
            if (!this.m_productWindow && as.isLot()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Lot=" + this.fieldLotString.getText());
                }
                text = this.fieldLotString.getText();
                this.m_masi.setLot(text);
                if (as.isLotMandatory() && (text == null || text.length() == 0)) {
                    mandatory = (String)mandatory + " - " + Msg.translate((Properties)Env.getCtx(), (String)"Lot");
                }
                this.m_changed = true;
            }
            if (!this.m_productWindow && as.isSerNo()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("SerNo=" + this.fieldSerNo.getText());
                }
                text = this.fieldSerNo.getText();
                this.m_masi.setSerNo(text);
                if (as.isSerNoMandatory() && (text == null || text.length() == 0)) {
                    mandatory = (String)mandatory + " - " + Msg.translate((Properties)Env.getCtx(), (String)"SerNo");
                }
                this.m_changed = true;
            }
            if (!this.m_productWindow && as.isGuaranteeDate()) {
                Date gDate;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("GuaranteeDate=" + String.valueOf(this.fieldGuaranteeDate.getValue()));
                }
                Timestamp ts = (gDate = this.fieldGuaranteeDate.getValue()) != null ? new Timestamp(gDate.getTime()) : null;
                this.m_masi.setGuaranteeDate(ts);
                if (as.isGuaranteeDateMandatory() && ts == null) {
                    mandatory = (String)mandatory + " - " + Msg.translate((Properties)Env.getCtx(), (String)"GuaranteeDate");
                }
                this.m_changed = true;
            }
            if (((String)mandatory).isEmpty() && (this.m_changed || this.m_masi.getM_AttributeSetInstance_ID() == 0)) {
                this.m_masi.saveEx();
                this.m_M_AttributeSetInstance_ID = this.m_masi.getM_AttributeSetInstance_ID();
                this.m_M_AttributeSetInstanceName = this.m_masi.getDescription();
            }
            MAttribute[] attributes = as.getMAttributes(!this.m_productWindow);
            MAttribute.set_TrxName((PO[])attributes, (String)trxName);
            int i = 0;
            while (i < attributes.length) {
                if ("L".equals(attributes[i].getAttributeValueType())) {
                    MAttributeValue value;
                    editor = this.m_editors.get(i);
                    Object item = editor.getValue();
                    MAttributeValue mAttributeValue = value = item != null && Integer.valueOf(String.valueOf(item)) > 0 ? new MAttributeValue(Env.getCtx(), Integer.valueOf(String.valueOf(item)).intValue(), null) : null;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(attributes[i].getName() + "=" + String.valueOf(value));
                    }
                    if (attributes[i].isMandatory() && value == null) {
                        mandatory = (String)mandatory + " - " + attributes[i].getName();
                    }
                    attributes[i].setMAttributeInstance(this.m_M_AttributeSetInstance_ID, value);
                } else if ("N".equals(attributes[i].getAttributeValueType())) {
                    editor = this.m_editors.get(i);
                    value = (BigDecimal)editor.getValue();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(attributes[i].getName() + "=" + String.valueOf(value));
                    }
                    if (attributes[i].isMandatory() && value == null) {
                        mandatory = (String)mandatory + " - " + attributes[i].getName();
                    }
                    if (value != null && ((BigDecimal)value).scale() == 0) {
                        value = ((BigDecimal)value).setScale(1, RoundingMode.HALF_UP);
                    }
                    attributes[i].setMAttributeInstance(this.m_M_AttributeSetInstance_ID, value);
                } else if ("D".equals(attributes[i].getAttributeValueType())) {
                    Timestamp ts;
                    editor = this.m_editors.get(i);
                    value = (Date)editor.getValue();
                    Timestamp timestamp = ts = value != null ? new Timestamp(((Date)value).getTime()) : null;
                    if (attributes[i].isMandatory() && value == null) {
                        mandatory = (String)mandatory + " - " + attributes[i].getName();
                    }
                    attributes[i].setMAttributeInstance(this.m_M_AttributeSetInstance_ID, ts);
                } else if ("R".equals(attributes[i].getAttributeValueType())) {
                    this.setEditorValue((String)mandatory, attributes[i], this.m_editors.get(i));
                } else if ("C".equals(attributes[i].getAttributeValueType())) {
                    Object displayValue;
                    editor = this.m_editors.get(i);
                    value = editor.getValue() != null ? String.valueOf(editor.getValue()) : null;
                    Object object = displayValue = editor.getDisplay() != null ? editor.getDisplay() : value;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(attributes[i].getName() + "=" + (String)value);
                    }
                    if (attributes[i].isMandatory() && (value == null || ((String)value).length() == 0)) {
                        mandatory = (String)mandatory + " - " + attributes[i].getName();
                    }
                    attributes[i].setMAttributeInstanceMultiSelection(this.m_M_AttributeSetInstance_ID, (String)value, (String)displayValue);
                } else {
                    editor = this.m_editors.get(i);
                    value = String.valueOf(editor.getValue());
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(attributes[i].getName() + "=" + (String)value);
                    }
                    if (attributes[i].isMandatory() && (value == null || ((String)value).length() == 0)) {
                        mandatory = (String)mandatory + " - " + attributes[i].getName();
                    }
                    attributes[i].setMAttributeInstance(this.m_M_AttributeSetInstance_ID, (String)value);
                }
                this.m_changed = true;
                ++i;
            }
            this.m_M_AttributeSetInstance_ID = this.m_masi.getM_AttributeSetInstance_ID();
            this.m_M_AttributeSetInstanceName = this.m_masi.getDescription();
            if (((String)mandatory).length() > 0) {
                Dialog.error(this.m_WindowNo, "FillMandatory", (String)mandatory);
                return false;
            }
            if (this.m_changed) {
                this.m_masi.setDescription();
                this.m_masi.saveEx();
            }
        }
        finally {
            if (trx != null) {
                if (!this.m_changed || ((String)mandatory).length() > 0) {
                    trx.rollback();
                } else {
                    trx.commit();
                }
                trx.close();
                trx = null;
            }
        }
        return true;
    }

    public String setEditorValue(String mandatory, MAttribute attributes, WEditor editor) {
        int displayType = editor.getGridField().getDisplayType();
        if (displayType == 20) {
            String value = (Boolean)editor.getValue() != false ? "Y" : "N";
            attributes.setMAttributeInstance(this.m_M_AttributeSetInstance_ID, value);
        } else if (displayType == 15 || displayType == 16 || displayType == 24) {
            Timestamp valueTimeStamp = (Timestamp)editor.getValue();
            if (attributes.isMandatory() && valueTimeStamp == null) {
                mandatory = (String)mandatory + " - " + attributes.getName();
            }
            attributes.setMAttributeInstance(this.m_M_AttributeSetInstance_ID, valueTimeStamp);
        } else if (DisplayType.isNumeric((int)displayType)) {
            Object value = editor.getValue();
            if (attributes.isMandatory() && value == null) {
                mandatory = (String)mandatory + " - " + attributes.getName();
            }
            if (displayType == 11) {
                attributes.setMAttributeInstance(this.m_M_AttributeSetInstance_ID, value == null ? 0 : ((Number)value).intValue());
            } else {
                attributes.setMAttributeInstance(this.m_M_AttributeSetInstance_ID, (BigDecimal)value);
            }
        } else if (displayType == 32 || displayType == 33 || displayType == 31 || displayType == 19 || displayType == 18 || displayType == 30 || displayType == 25) {
            Integer value = (Integer)editor.getValue();
            if (attributes.isMandatory() && value == null) {
                mandatory = (String)mandatory + " - " + attributes.getName();
            }
            String valueLabel = null;
            if (displayType == 19 || displayType == 18 || displayType == 30 || displayType == 25) {
                valueLabel = editor.getDisplay();
            }
            attributes.setMAttributeInstance(this.m_M_AttributeSetInstance_ID, new KeyNamePair(value == null ? 0 : value, valueLabel));
        } else {
            String value = (String)editor.getValue();
            if (attributes.isMandatory() && value == null) {
                mandatory = (String)mandatory + " - " + attributes.getName();
            }
            attributes.setMAttributeInstance(this.m_M_AttributeSetInstance_ID, value);
        }
        return mandatory;
    }

    public int getM_AttributeSetInstance_ID() {
        return this.m_M_AttributeSetInstance_ID;
    }

    public String getM_AttributeSetInstanceName() {
        return this.m_M_AttributeSetInstanceName;
    }

    public int getM_Locator_ID() {
        return this.m_M_Locator_ID;
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    private void validadeRoleAccess() {
        Boolean hasAccess = MRole.getDefault().getWindowAccess(358);
        if (hasAccess == null) {
            throw new AdempiereException(Msg.translate((Properties)Env.getCtx(), (String)"AccessTableNoView"));
        }
        this.isAllowedToCreateAndUpdate = hasAccess;
    }
}

