/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.server.cluster;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.adempiere.base.Core;
import org.compiere.Adempiere;
import org.compiere.model.MScheduler;
import org.compiere.server.IServerManager;
import org.compiere.server.ServerCount;
import org.compiere.server.ServerInstance;
import org.idempiere.distributed.IClusterMember;
import org.idempiere.distributed.IClusterService;
import org.idempiere.server.cluster.callable.AddSchedulerCallable;
import org.idempiere.server.cluster.callable.GetAllCallable;
import org.idempiere.server.cluster.callable.GetServerCallable;
import org.idempiere.server.cluster.callable.GetServerCountCallable;
import org.idempiere.server.cluster.callable.GetStartTimeCallable;
import org.idempiere.server.cluster.callable.ReloadCallable;
import org.idempiere.server.cluster.callable.RemoveSchedulerCallable;
import org.idempiere.server.cluster.callable.Response;
import org.idempiere.server.cluster.callable.RunNowCallable;
import org.idempiere.server.cluster.callable.StartAllCallable;
import org.idempiere.server.cluster.callable.StartCallable;
import org.idempiere.server.cluster.callable.StopAllCallable;
import org.idempiere.server.cluster.callable.StopCallable;

public class ClusterServerMgr
implements IServerManager {
    private static final ClusterServerMgr INSTANCE = new ClusterServerMgr();

    public static ClusterServerMgr getInstance() {
        return INSTANCE;
    }

    private ClusterServerMgr() {
    }

    public static IClusterService getClusterService() {
        return Core.getClusterService();
    }

    public static IClusterMember getClusterMember(String nodeId) {
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service != null) {
            Collection members = service.getMembers();
            for (IClusterMember member : members) {
                if (!member.getId().equals(nodeId)) continue;
                return member;
            }
        }
        return null;
    }

    @Override
    public ServerInstance getServerInstance(String serverId) {
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service == null) {
            return null;
        }
        GetServerCallable callable = new GetServerCallable(serverId);
        Map futureMap = service.execute((Callable)callable, service.getMembers());
        if (futureMap != null) {
            try {
                Set results = futureMap.entrySet();
                for (Map.Entry f : results) {
                    ServerInstance i = (ServerInstance)((Future)f.getValue()).get();
                    if (i == null) continue;
                    i.setClusterMember((IClusterMember)f.getKey());
                    return i;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    public String runNow(String serverId) {
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service == null) {
            return "Cluster service not available";
        }
        RunNowCallable callable = new RunNowCallable(serverId);
        Map futureMap = service.execute((Callable)callable, service.getMembers());
        if (futureMap != null) {
            try {
                Collection results = futureMap.values();
                for (Future f : results) {
                    Response response = (Response)f.get();
                    if (response.getServerId() == null) continue;
                    return response.getError();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return "Server " + serverId + " not found";
        }
        return null;
    }

    @Override
    public String start(String serverId) {
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service == null) {
            return "Cluster service not available";
        }
        StartCallable callable = new StartCallable(serverId);
        Map futureMap = service.execute((Callable)callable, service.getMembers());
        if (futureMap != null) {
            try {
                Collection results = futureMap.values();
                for (Future f : results) {
                    Response response = (Response)f.get();
                    if (response == null || response.getServerId() == null) continue;
                    return response.getError();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return "Server " + serverId + " not found";
        }
        return "Failed to send start request through cluster service";
    }

    @Override
    public String stop(String serverId) {
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service == null) {
            return "Cluster service not available";
        }
        StopCallable callable = new StopCallable(serverId);
        Map futureMap = service.execute((Callable)callable, service.getMembers());
        if (futureMap != null) {
            try {
                Collection results = futureMap.values();
                for (Future f : results) {
                    Response response = (Response)f.get();
                    if (response == null || response.getServerId() == null) continue;
                    return response.getError();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return "Server " + serverId + " not found";
        }
        return "Failed to send stop request through cluster service";
    }

    @Override
    public String reload() {
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service == null) {
            return "Cluster service not available";
        }
        ReloadCallable callable = new ReloadCallable();
        Map futureMap = service.execute((Callable)callable, service.getMembers());
        if (futureMap != null) {
            try {
                Collection results = futureMap.values();
                for (Future f : results) {
                    String response = (String)f.get();
                    if (response == null) continue;
                    return response;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return null;
        }
        return "Failed to send reload request through cluster service";
    }

    @Override
    public Timestamp getStartTime() {
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service == null) {
            return null;
        }
        Timestamp earliest = null;
        GetStartTimeCallable callable = new GetStartTimeCallable();
        Map futureMap = service.execute((Callable)callable, service.getMembers());
        if (futureMap != null) {
            try {
                Collection results = futureMap.values();
                for (Future f : results) {
                    Timestamp response = (Timestamp)f.get();
                    if (response == null) continue;
                    if (earliest == null) {
                        earliest = response;
                        continue;
                    }
                    if (!response.before(earliest)) continue;
                    earliest = response;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return earliest;
    }

    @Override
    public ServerCount getServerCount() {
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service == null) {
            return null;
        }
        ServerCount serverCount = null;
        GetServerCountCallable callable = new GetServerCountCallable();
        Map futureMap = service.execute((Callable)callable, service.getMembers());
        if (futureMap != null) {
            try {
                Collection results = futureMap.values();
                for (Future f : results) {
                    ServerCount response = (ServerCount)f.get();
                    if (response == null) continue;
                    if (serverCount == null) {
                        serverCount = response;
                        continue;
                    }
                    serverCount.addStarted(response.getStarted());
                    serverCount.addStopped(response.getStopped());
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return serverCount;
    }

    @Override
    public ServerInstance[] getServerInstances() {
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service == null) {
            return null;
        }
        ArrayList servers = new ArrayList();
        GetAllCallable callable = new GetAllCallable();
        Map futureMap = service.execute((Callable)callable, service.getMembers());
        if (futureMap != null) {
            try {
                Set results = futureMap.entrySet();
                for (Map.Entry f : results) {
                    ServerInstance[] response = (ServerInstance[])((Future)f.getValue()).get();
                    if (response == null) continue;
                    Arrays.stream(response).forEach(e -> {
                        e.setClusterMember((IClusterMember)f.getKey());
                        servers.add(e);
                    });
                }
            }
            catch (InterruptedException e2) {
                throw new RuntimeException(e2.getMessage(), e2);
            }
            catch (ExecutionException e3) {
                throw new RuntimeException(e3.getMessage(), e3);
            }
        }
        return servers.toArray(new ServerInstance[0]);
    }

    @Override
    public String getDescription() {
        return Adempiere.getVersion();
    }

    @Override
    public String startAll() {
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service == null) {
            return "Cluster service not available";
        }
        StartAllCallable callable = new StartAllCallable();
        Map futureMap = service.execute((Callable)callable, service.getMembers());
        if (futureMap != null) {
            try {
                Collection results = futureMap.values();
                for (Future f : results) {
                    String response = (String)f.get();
                    if (response == null) continue;
                    return response;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return null;
        }
        return "Failed to send start all request through cluster servie";
    }

    @Override
    public String stopAll() {
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service == null) {
            return "Cluster service not available";
        }
        StopAllCallable callable = new StopAllCallable();
        Map futureMap = service.execute((Callable)callable, service.getMembers());
        if (futureMap != null) {
            try {
                Collection results = futureMap.values();
                for (Future f : results) {
                    String response = (String)f.get();
                    if (response == null) continue;
                    return response;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return null;
        }
        return "Failed to send stop all request through cluster servie";
    }

    @Override
    public String addScheduler(MScheduler scheduler) {
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service == null) {
            return "Cluster service not available";
        }
        AddSchedulerCallable callable = new AddSchedulerCallable(scheduler);
        Map futureMap = service.execute((Callable)callable, service.getMembers());
        if (futureMap != null) {
            try {
                Collection results = futureMap.values();
                for (Future f : results) {
                    Response response = (Response)f.get();
                    if (response == null || response.getServerId() == null) continue;
                    return response.getError();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return null;
        }
        return "Failed to send add scheduler request through cluster servie";
    }

    @Override
    public String removeScheduler(MScheduler scheduler) {
        IClusterService service = ClusterServerMgr.getClusterService();
        if (service == null) {
            return "Cluster service not available";
        }
        RemoveSchedulerCallable callable = new RemoveSchedulerCallable(scheduler);
        Map futureMap = service.execute((Callable)callable, service.getMembers());
        if (futureMap != null) {
            try {
                Collection results = futureMap.values();
                for (Future f : results) {
                    Response response = (Response)f.get();
                    if (response == null || response.getServerId() == null) continue;
                    return response.getError();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return null;
        }
        return "Failed to send remove scheduler request through cluster servie";
    }
}

