/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customizers.util;

import net.sf.jasperreports.customizers.util.ItemsCounter;
import net.sf.jasperreports.customizers.util.SeriesNameProvider;
import net.sf.jasperreports.engine.JRAbstractChartCustomizer;

public final class CustomizerUtil {
    public static final String PROPERTY_ALL_ITEMS = "allItems";
    public static final String PROPERTY_ITEM_INDEX = "itemIndex";
    public static final String PROPERTY_ITEM_SERIES = "itemSeries";

    public static Integer resolveIndex(JRAbstractChartCustomizer customizer, ItemsCounter itemsCounter, SeriesNameProvider seriesNameProvider) {
        Integer itemIndex = null;
        Boolean allItems = customizer.getBooleanProperty(PROPERTY_ALL_ITEMS);
        if (Boolean.TRUE.equals(allItems)) {
            itemIndex = -1;
        } else {
            String seriesName;
            itemIndex = customizer.getIntegerProperty(PROPERTY_ITEM_INDEX);
            if (itemIndex == null && (seriesName = customizer.getProperty(PROPERTY_ITEM_SERIES)) != null) {
                itemIndex = CustomizerUtil.seriesNameToIndex(itemsCounter, seriesNameProvider, seriesName);
            }
        }
        return itemIndex;
    }

    public static Integer seriesNameToIndex(ItemsCounter itemsCounter, SeriesNameProvider seriesNameProvider, String seriesName) {
        for (int i = 0; i < itemsCounter.getCount(); ++i) {
            String key = seriesNameProvider.getSeriesName(i);
            if (!seriesName.equals(key.toString())) continue;
            return i;
        }
        return null;
    }
}

