/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.adempiere.pipo2.PackIn;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.WebUtil;

public class PackInNotifier {
    private String fileName;
    private String pluginName;
    private List<KeyNamePair> knpLines = new ArrayList<KeyNamePair>();
    private PackIn packIn;
    private static final int LEVEL_STATUS = 0;
    private static final int LEVEL_FAILURE = 1;
    private static final int LEVEL_SUCCESS = 2;

    public PackInNotifier(PackIn packIn) {
        this.packIn = packIn;
    }

    public void addStatusLine(String msg) {
        this.addLine(0, msg);
    }

    public void addFailureLine(String msg) {
        this.addLine(1, msg);
    }

    public void addSuccessLine(String msg) {
        this.addLine(2, msg);
    }

    public void addLine(int level, String msg) {
        this.knpLines.add(new KeyNamePair(level, msg));
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public void notifyRecipient() {
        EMail email;
        List<String> sLines;
        Object emailList = MSysConfig.getValue((String)"EMAIL_NOTIFY_2PACK", (String)"", (int)Env.getAD_Client_ID((Properties)Env.getCtx())).trim();
        String emailSys = MSysConfig.getValue((String)"EMAIL_NOTIFY_2PACK", (String)"", (int)0).trim();
        if (emailSys.length() > 0 && !((String)emailList).equals(emailSys)) {
            emailList = (String)emailList + "," + emailSys;
        }
        if (((String)emailList).length() == 0) {
            return;
        }
        StringBuilder subject = new StringBuilder("*");
        String status = this.packIn.isSuccess() ? "Success" : "Failure";
        String serverName = null;
        try {
            serverName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            serverName = WebUtil.getHostIP();
        }
        subject.append(status).append("* ").append(serverName).append(" - Result for PackIn ").append(this.getFileName());
        if (this.getPluginName() != null) {
            subject.append(" from ").append(this.getPluginName());
        }
        StringBuilder message = new StringBuilder();
        message.append("===========================\n");
        message.append("Packin File: ").append(this.getFileName()).append("\n");
        if (this.getPluginName() != null) {
            message.append("Plugin: ").append(this.getPluginName()).append("\n");
        }
        MClient client = MClient.get((Properties)Env.getCtx());
        message.append("Executed on: ").append(client.getName()).append("\n");
        message.append("Status: ").append(status).append("\n");
        for (String line : this.getLines(0)) {
            message.append(line).append("\n");
        }
        message.append("===========================\n");
        List<String> fLines = this.getLines(1);
        if (fLines.size() > 0) {
            message.append("Failed Objects:").append("\n");
            for (String line : fLines) {
                message.append(line).append("\n");
            }
            message.append("===========================\n");
        }
        if ((sLines = this.getLines(2)).size() > 0) {
            message.append("Successful Objects:").append("\n");
            for (String line : sLines) {
                message.append(line).append("\n");
            }
            message.append("===========================\n");
        }
        StringTokenizer st = new StringTokenizer((String)emailList, " ,;", false);
        String to = st.nextToken();
        String from = client.getRequestEMail();
        if (from == null && client.getAD_Client_ID() != 0 && MClient.isSendCredentialsSystem()) {
            MClient sysclient = MClient.get((Properties)Env.getCtx(), (int)0);
            from = sysclient.getRequestEMail();
        }
        try {
            email = client.createEMailFrom(from, to, subject.toString(), message.toString(), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            email = null;
        }
        if (email != null) {
            if (!this.packIn.isSuccess()) {
                email.setHeader("X-Priority", "1");
                email.setHeader("Priority", "Urgent");
                email.setHeader("Importance", "high");
            }
            while (st.hasMoreTokens()) {
                email.addTo(st.nextToken());
            }
            status = email.send();
        }
    }

    private List<String> getLines(int levelStatus) {
        ArrayList<String> lines = new ArrayList<String>();
        for (KeyNamePair knp : this.knpLines) {
            if (knp.getKey() != levelStatus) continue;
            lines.add(knp.getName());
        }
        return lines;
    }
}

