/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.tree.DefaultMutableTreeNode;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_AD_Menu;
import org.compiere.model.MMenu;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MTreeNode;
import org.compiere.model.X_AD_Tree_Favorite;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MTreeFavorite
extends X_AD_Tree_Favorite {
    private static final long serialVersionUID = 1468891496751650494L;
    public static final String SQL_GET_TREE_FAVORITE_ID = "SELECT AD_Tree_Favorite_ID FROM AD_Tree_Favorite\tWHERE IsActive='Y' AND AD_User_ID=?";
    public static final String SQL_GET_TREE_FAVORITE_NODE = "SELECT AD_Tree_Favorite_Node_ID, Parent_ID, SeqNo, Name, IsSummary, AD_Menu_ID, IsCollapsible, IsFavourite  FROM AD_Tree_Favorite_Node WHERE IsActive='Y' AND AD_Tree_Favorite_ID=? AND AD_Client_ID IN (0,?)  ORDER BY COALESCE(Parent_ID, -1), SeqNo, Name ";
    private static CCache<Integer, Integer> cache_TreeFavID = new CCache("AD_Tree_Favorite_ID", 30);
    private ArrayList<MTreeNode> m_buffer = new ArrayList();
    private MTreeNode root = null;

    public MTreeFavorite(Properties ctx, String AD_Tree_Favorite_UU, String trxName) {
        super(ctx, AD_Tree_Favorite_UU, trxName);
        if (!Util.isEmpty(AD_Tree_Favorite_UU)) {
            this.loadNode();
        }
    }

    public MTreeFavorite(Properties ctx, int AD_Tree_Favorite_ID, String trxName) {
        super(ctx, AD_Tree_Favorite_ID, trxName);
        if (AD_Tree_Favorite_ID > 0) {
            this.loadNode();
        }
    }

    public MTreeFavorite(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTreeNode getRoot() {
        return this.root;
    }

    private void loadNode() {
        MRole role = MRole.get(this.getCtx(), Env.getAD_Role_ID(Env.getCtx()));
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                this.root = new MTreeNode(0, 0, "User Favourite Root", "User Favourite Root", 0, 0, null, true, false, false);
                pstmt = DB.prepareStatement(SQL_GET_TREE_FAVORITE_NODE, this.get_TrxName());
                pstmt.setInt(1, this.getAD_Tree_Favorite_ID());
                pstmt.setInt(2, Env.getAD_Client_ID(Env.getCtx()));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int nodeID = rs.getInt(1);
                    int parentID = rs.getInt(2);
                    int seqNo = rs.getInt(3);
                    String name = rs.getString(4);
                    String description = null;
                    boolean isSummary = rs.getString(5).equals("Y");
                    boolean isCollapsible = rs.getString(7).equals("Y");
                    boolean isFavourite = rs.getString("IsFavourite").equals("Y");
                    int menuID = 0;
                    String img2 = null;
                    Boolean access = null;
                    if (!isSummary) {
                        menuID = rs.getInt(6);
                        MMenu menu = (MMenu)MTable.get(Env.getCtx(), 116).getPO(menuID, null);
                        access = MTreeFavorite.getAccessForMenuItem(role, menu);
                        if (access != null) {
                            name = menu.getDisplayedName();
                            description = menu.get_Translation("Description");
                            img2 = menu.getAction();
                        }
                    }
                    if (access == null && !isSummary) continue;
                    this.addToTree(nodeID, parentID, seqNo, name, description, menuID, img2, isSummary, isCollapsible, isFavourite);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, SQL_GET_TREE_FAVORITE_NODE, e);
                throw new AdempiereException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private void addToTree(int favNodeID, int parentID, int seqNo, String name, String description, int menuID, String imgSrc, boolean isSummary, boolean isCollapsible, boolean isFavourite) {
        MTreeNode child = new MTreeNode(favNodeID, seqNo, name, description, parentID, menuID, imgSrc, isSummary, isCollapsible, isFavourite);
        DefaultMutableTreeNode parent = null;
        if (this.root != null) {
            parent = this.root.findNode(parentID);
        }
        if (parent != null && parent.getAllowsChildren()) {
            parent.add(child);
            if (this.m_buffer.size() > 0) {
                this.checkBuffer(child);
            }
        } else {
            this.m_buffer.add(child);
        }
    }

    private void checkBuffer(MTreeNode child) {
        if (!child.isSummary() || !child.getAllowsChildren()) {
            return;
        }
        int i = 0;
        while (i < this.m_buffer.size()) {
            MTreeNode node = this.m_buffer.get(i);
            if (node.getParent_ID() == child.getParent_ID()) {
                try {
                    child.add(node);
                }
                catch (Exception e) {
                    this.log.severe("Adding " + node.getName() + " to " + child.getName() + ": " + e.getMessage());
                }
                this.m_buffer.remove(i);
                --i;
            } else if (node.getParent_ID() == child.getNode_ID()) {
                try {
                    child.add(node);
                }
                catch (Exception e) {
                    this.log.severe("Adding " + node.getName() + " to " + child.getName() + ": " + e.getMessage());
                }
                this.m_buffer.remove(i);
                --i;
            }
            ++i;
        }
    }

    public static int getFavoriteTreeID(int userID) {
        if (cache_TreeFavID.containsKey(userID)) {
            return cache_TreeFavID.get(userID);
        }
        int id = DB.getSQLValue(null, SQL_GET_TREE_FAVORITE_ID, userID);
        if (id > 0) {
            cache_TreeFavID.put(userID, id);
        }
        return id;
    }

    public static Boolean getAccessForMenuItem(MRole role, I_AD_Menu menu) {
        Boolean access = null;
        if ("W".equals(menu.getAction())) {
            access = role.getWindowAccess(menu.getAD_Window_ID());
        } else if ("P".equals(menu.getAction()) || "R".equals(menu.getAction())) {
            access = role.getProcessAccess(menu.getAD_Process_ID());
        } else if ("X".equals(menu.getAction())) {
            access = role.getFormAccess(menu.getAD_Form_ID());
        } else if ("F".equals(menu.getAction())) {
            access = role.getWorkflowAccess(menu.getAD_Workflow_ID());
        } else if ("T".equals(menu.getAction())) {
            access = role.getTaskAccess(menu.getAD_Task_ID());
        } else if ("I".equals(menu.getAction())) {
            access = role.getInfoAccess(menu.getAD_InfoWindow_ID());
        }
        return access;
    }
}

