/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.model.MOrg;
import org.compiere.model.MRole;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Role_OrgAccess;
import org.compiere.util.CLogger;
import org.compiere.util.CacheMgt;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MRoleOrgAccess
extends X_AD_Role_OrgAccess {
    private static final long serialVersionUID = -3476937107774004286L;
    private static CLogger s_log = CLogger.getCLogger(MRoleOrgAccess.class);
    private String m_clientName;
    private String m_orgName;

    public static MRoleOrgAccess[] getOfRole(Properties ctx, int AD_Role_ID) {
        return MRoleOrgAccess.get(ctx, "AD_Role_ID=?", AD_Role_ID);
    }

    public static MRoleOrgAccess[] getOfClient(Properties ctx, int AD_Client_ID) {
        return MRoleOrgAccess.get(ctx, "AD_Client_ID=?", AD_Client_ID);
    }

    public static MRoleOrgAccess[] getOfOrg(Properties ctx, int AD_Org_ID) {
        return MRoleOrgAccess.get(ctx, "AD_Org_ID=?", AD_Org_ID);
    }

    private static MRoleOrgAccess[] get(Properties ctx, String where, int id) {
        List<MRoleOrgAccess> list = new Query(ctx, "AD_Role_OrgAccess", where, null).setParameters(id).setOnlyActiveRecords(true).list();
        MRoleOrgAccess[] retValue = new MRoleOrgAccess[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static boolean createForOrg(MOrg org) {
        int counter = 0;
        MRole[] roles = MRole.getOfClient(org.getCtx(), org.get_TrxName());
        int i2 = 0;
        while (i2 < roles.length) {
            MRoleOrgAccess orgAccess;
            if (!roles[i2].isManual() && (orgAccess = new MRoleOrgAccess(org, roles[i2].getAD_Role_ID())).save()) {
                ++counter;
            }
            ++i2;
        }
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info(String.valueOf(org) + " - created #" + counter);
        }
        return counter != 0;
    }

    public MRoleOrgAccess(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRoleOrgAccess(Properties ctx, String AD_Role_OrgAccess_UU, String trxName) {
        super(ctx, AD_Role_OrgAccess_UU, trxName);
        if (Util.isEmpty(AD_Role_OrgAccess_UU)) {
            this.setInitialDefaults();
        }
    }

    public MRoleOrgAccess(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setInitialDefaults();
    }

    private void setInitialDefaults() {
        this.setIsReadOnly(false);
    }

    public MRoleOrgAccess(MOrg org, int AD_Role_ID) {
        this(org.getCtx(), 0, org.get_TrxName());
        this.setClientOrg(org);
        this.setAD_Role_ID(AD_Role_ID);
    }

    public MRoleOrgAccess(MRole role, int AD_Org_ID) {
        this(role.getCtx(), 0, role.get_TrxName());
        this.setClientOrg(role.getAD_Client_ID(), AD_Org_ID);
        this.setAD_Role_ID(role.getAD_Role_ID());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRoleOrgAccess[");
        sb.append("AD_Role_ID=").append(this.getAD_Role_ID()).append(",AD_Client_ID=").append(this.getAD_Client_ID()).append(",AD_Org_ID=").append(this.getAD_Org_ID()).append(",RO=").append(this.isReadOnly());
        sb.append("]");
        return sb.toString();
    }

    public String toStringX(Properties ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append(Msg.translate(ctx, "AD_Client_ID")).append("=").append(this.getClientName()).append(" - ").append(Msg.translate(ctx, "AD_Org_ID")).append("=").append(this.getOrgName());
        return sb.toString();
    }

    public String getClientName() {
        if (this.m_clientName == null) {
            MOrg org = MOrg.get(this.getAD_Org_ID());
            MClient client = MClient.get(org.getAD_Client_ID());
            this.m_clientName = client.getName();
            this.m_orgName = org.getName();
        }
        return this.m_clientName;
    }

    public String getOrgName() {
        if (this.m_orgName == null) {
            this.getClientName();
        }
        return this.m_orgName;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success) {
            Adempiere.getThreadPoolExecutor().submit(() -> CacheMgt.get().reset("AD_Role", this.getAD_Role_ID()));
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            Adempiere.getThreadPoolExecutor().submit(() -> CacheMgt.get().reset("AD_Role", this.getAD_Role_ID()));
        }
        return success;
    }
}

