/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.I_C_AcctSchema;
import org.compiere.model.MCostElement;
import org.compiere.model.Query;
import org.compiere.model.X_M_Product_Category_Acct;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MProductCategoryAcct
extends X_M_Product_Category_Acct
implements ImmutablePOSupport {
    private static final long serialVersionUID = -7990259665379770596L;
    private static ImmutablePOCache<String, MProductCategoryAcct> s_cache = new ImmutablePOCache("M_Product_Category_Acct", 40, 5);

    public static MProductCategoryAcct get(int M_Product_Category_ID, int C_AcctSchema_ID) {
        return MProductCategoryAcct.get(M_Product_Category_ID, C_AcctSchema_ID, null);
    }

    public static MProductCategoryAcct get(int M_Product_Category_ID, int C_AcctSchema_ID, String trxName) {
        return MProductCategoryAcct.get(Env.getCtx(), M_Product_Category_ID, C_AcctSchema_ID, trxName);
    }

    public static MProductCategoryAcct get(Properties ctx, int M_Product_Category_ID, int C_AcctSchema_ID, String trxName) {
        String key = M_Product_Category_ID + "#" + C_AcctSchema_ID;
        MProductCategoryAcct acct = s_cache.get(ctx, key, e -> new MProductCategoryAcct(ctx, (MProductCategoryAcct)e));
        if (acct != null) {
            return acct;
        }
        acct = (MProductCategoryAcct)new Query(ctx, "M_Product_Category_Acct", "M_Product_Category_ID=? AND C_AcctSchema_ID=?", trxName).setParameters(M_Product_Category_ID, C_AcctSchema_ID).firstOnly();
        if (acct != null) {
            s_cache.put(key, acct, e -> new MProductCategoryAcct(Env.getCtx(), (MProductCategoryAcct)e));
        }
        return acct;
    }

    public MProductCategoryAcct(Properties ctx, String M_Product_Category_Acct_UU, String trxName) {
        super(ctx, M_Product_Category_Acct_UU, trxName);
    }

    public MProductCategoryAcct(Properties ctx, int ignored, String trxName) {
        super(ctx, ignored, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MProductCategoryAcct(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProductCategoryAcct(MProductCategoryAcct copy) {
        this(Env.getCtx(), copy);
    }

    public MProductCategoryAcct(Properties ctx, MProductCategoryAcct copy) {
        this(ctx, copy, null);
    }

    public MProductCategoryAcct(Properties ctx, MProductCategoryAcct copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public void checkCosting() {
        if (this.getCostingMethod() != null && this.getCostingMethod().length() > 0) {
            MCostElement.getMaterialCostElement(this, this.getCostingMethod());
        }
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        this.checkCosting();
        return success;
    }

    @Override
    public MProductCategoryAcct markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MProductCategoryAcct[");
        sb.append(this.get_ID()).append(",M_Product_Category_ID=").append(this.getM_Product_Category_ID()).append(",C_AcctSchema_ID=").append(this.getC_AcctSchema_ID()).append(",CostingLevel=").append(this.getCostingLevel()).append(",CostingMethod=").append(this.getCostingMethod()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord && this.is_ValueChanged("CostingLevel")) {
            String products;
            String newCostingLevel = this.getCostingLevel();
            String oldCostingLevel = (String)this.get_ValueOld("CostingLevel");
            I_C_AcctSchema schema = this.getC_AcctSchema();
            if (newCostingLevel == null) {
                newCostingLevel = schema.getCostingLevel();
            }
            if (oldCostingLevel == null) {
                oldCostingLevel = schema.getCostingLevel();
            }
            if (!newCostingLevel.equals(oldCostingLevel) && !Util.isEmpty(products = this.getProductsWithCost())) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "ChangeCostingLevelError") + ". Products: " + products);
                return false;
            }
        }
        return true;
    }

    private String getProductsWithCost() {
        StringBuilder products = new StringBuilder();
        StringBuilder sql = new StringBuilder("SELECT DISTINCT p.Value FROM M_Product p JOIN M_CostDetail d ON p.M_Product_ID=d.M_Product_ID");
        sql.append(" WHERE p.IsActive='Y' AND p.M_Product_Category_ID=? AND d.C_AcctSchema_ID=?");
        String query = DB.getDatabase().addPagingSQL(sql.toString(), 1, 50);
        List<List<Object>> list = DB.getSQLArrayObjectsEx(this.get_TrxName(), query, this.getM_Product_Category_ID(), this.getC_AcctSchema_ID());
        if (list != null) {
            for (List<Object> entry : list) {
                String value = (String)entry.get(0);
                if (products.length() > 0) {
                    products.append(",");
                }
                products.append(value);
            }
        }
        return products.toString();
    }
}

