/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.adempiere.process.UUIDGenerator;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.TranslationTable;
import org.compiere.model.X_AD_Language;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MLanguage
extends X_AD_Language
implements ImmutablePOSupport {
    private static final long serialVersionUID = 6553711529361500744L;
    private static final ImmutablePOCache<String, MLanguage> s_cache = new ImmutablePOCache("AD_Language", "AD_Language|AD_Language", 100, 0, false, 0);
    private Locale m_locale = null;
    private SimpleDateFormat m_dateFormat = null;

    public static MLanguage get(Properties ctx, Language lang) {
        return MLanguage.get(ctx, lang.getAD_Language());
    }

    public static MLanguage get(Properties ctx, String AD_Language) {
        MLanguage retValue = s_cache.get(ctx, AD_Language, e -> new MLanguage(ctx, (MLanguage)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = (MLanguage)new Query(ctx, "AD_Language", "AD_Language=?", null).setParameters(AD_Language).firstOnly();
        if (retValue != null) {
            s_cache.put(AD_Language, retValue, e -> new MLanguage(ctx, (MLanguage)e));
        }
        return retValue;
    }

    public static MLanguage[] getWithLanguage(Properties ctx, String LanguageISO) {
        List<MLanguage> list = new Query(ctx, "AD_Language", "LanguageISO=?", null).setParameters(LanguageISO).list();
        return list.toArray(new MLanguage[list.size()]);
    }

    public static void maintain(Properties ctx) {
        List list = new Query(ctx, "AD_Language", "IsSystemLanguage=? AND IsBaseLanguage=?", null).setParameters(true, false).setOnlyActiveRecords(true).list();
        for (MLanguage language : list) {
            language.maintain(true);
        }
    }

    public MLanguage(Properties ctx, String AD_Language_UU, String trxName) {
        super(ctx, AD_Language_UU, trxName);
    }

    public MLanguage(Properties ctx, int AD_Language_ID, String trxName) {
        super(ctx, AD_Language_ID, trxName);
    }

    public MLanguage(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private MLanguage(Properties ctx, String AD_Language, String Name, String CountryCode, String LanguageISO, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Language(AD_Language);
        this.setIsBaseLanguage(false);
        this.setIsSystemLanguage(false);
        this.setName(Name);
        this.setCountryCode(CountryCode);
        this.setLanguageISO(LanguageISO);
    }

    public MLanguage(Properties ctx, MLanguage copy) {
        this(ctx, copy, null);
    }

    public MLanguage(Properties ctx, MLanguage copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_dateFormat = copy.m_dateFormat != null ? new SimpleDateFormat(copy.m_dateFormat.toPattern()) : null;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("MLanguage[").append(this.getAD_Language()).append("-").append(this.getName()).append(",Language=").append(this.getLanguageISO()).append(",Country=").append(this.getCountryCode()).append("]");
        return str.toString();
    }

    public Locale getLocale() {
        if (this.m_locale == null) {
            this.m_locale = new Locale(this.getLanguageISO(), this.getCountryCode());
        }
        return this.m_locale;
    }

    public SimpleDateFormat getDateFormat() {
        if (this.m_dateFormat != null) {
            return this.m_dateFormat;
        }
        if (this.getDatePattern() != null) {
            this.m_dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.getLocale());
            try {
                this.m_dateFormat.applyPattern(this.getDatePattern());
            }
            catch (Exception e) {
                this.log.severe(this.getDatePattern() + " - " + String.valueOf(e));
                this.m_dateFormat = null;
            }
        }
        if (this.m_dateFormat == null) {
            int i2;
            StringBuilder nFormat;
            this.m_dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.getLocale());
            String sFormat = this.m_dateFormat.toPattern();
            if (sFormat.indexOf("MM") == -1 && sFormat.indexOf("dd") == -1) {
                nFormat = new StringBuilder();
                i2 = 0;
                while (i2 < sFormat.length()) {
                    if (sFormat.charAt(i2) == 'M') {
                        nFormat.append("MM");
                    } else if (sFormat.charAt(i2) == 'd') {
                        nFormat.append("dd");
                    } else {
                        nFormat.append(sFormat.charAt(i2));
                    }
                    ++i2;
                }
                this.m_dateFormat.applyPattern(nFormat.toString());
            }
            if (this.m_dateFormat.toPattern().length() != 8) {
                this.m_dateFormat.applyPattern("yyyy-MM-dd");
            }
            if (this.m_dateFormat.toPattern().indexOf("yyyy") == -1) {
                sFormat = this.m_dateFormat.toPattern();
                nFormat = new StringBuilder();
                i2 = 0;
                while (i2 < sFormat.length()) {
                    if (sFormat.charAt(i2) == 'y') {
                        nFormat.append("yy");
                    } else {
                        nFormat.append(sFormat.charAt(i2));
                    }
                    ++i2;
                }
                this.m_dateFormat.applyPattern(nFormat.toString());
            }
        }
        this.m_dateFormat.setLenient(true);
        return this.m_dateFormat;
    }

    private void setAD_Language_ID() {
        int AD_Language_ID = this.getAD_Language_ID();
        if (AD_Language_ID == 0) {
            String sql = "SELECT NVL(MAX(AD_Language_ID), 999999) FROM AD_Language WHERE AD_Language_ID > 1000";
            AD_Language_ID = DB.getSQLValue(this.get_TrxName(), sql);
            this.setAD_Language_ID(AD_Language_ID + 1);
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String dp = this.getDatePattern();
        if (this.is_ValueChanged("DatePattern") && dp != null && dp.length() > 0) {
            if (dp.indexOf("MM") == -1) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Error@ @DatePattern@ - No Month (MM)"));
                return false;
            }
            if (dp.indexOf("dd") == -1) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Error@ @DatePattern@ - No Day (dd)"));
                return false;
            }
            if (dp.indexOf("yy") == -1) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Error@ @DatePattern@ - No Year (yy)"));
                return false;
            }
            this.m_dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.getLocale());
            try {
                this.m_dateFormat.applyPattern(dp);
            }
            catch (Exception e) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Error@ @DatePattern@ - " + e.getMessage()));
                this.m_dateFormat = null;
                return false;
            }
        }
        String tp = this.getTimePattern();
        if (this.is_ValueChanged("TimePattern") && tp != null && tp.length() > 0) {
            if (tp.indexOf("HH") == -1 && tp.indexOf("hh") == -1) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Error@ @TimePattern@ - No Hour (HH/hh)"));
                return false;
            }
            if (tp.indexOf("mm") == -1) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Error@ @TimePattern@ - No Minute (mm)"));
                return false;
            }
            if (tp.indexOf("ss") == -1) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Error@ @TimePattern@ - No Second (ss)"));
                return false;
            }
            this.m_dateFormat = (SimpleDateFormat)DateFormat.getTimeInstance(3, this.getLocale());
            try {
                this.m_dateFormat.applyPattern(tp);
            }
            catch (Exception e) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Error@ @TimePattern@ - " + e.getMessage()));
                this.m_dateFormat = null;
                return false;
            }
        }
        if (newRecord) {
            this.setAD_Language_ID();
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        int no = TranslationTable.getActiveLanguages(true);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Active Languages=" + no);
        }
        return true;
    }

    public int maintain(boolean add) {
        String sql = "SELECT TableName FROM AD_Table WHERE TableName LIKE '%_Trl' ORDER BY TableName";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int retNo = 0;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    if (add) {
                        retNo += this.addTable(rs.getString(1));
                        continue;
                    }
                    retNo += this.deleteTable(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retNo;
    }

    private int deleteTable(String tableName) {
        StringBuilder sql = new StringBuilder("DELETE  FROM  ").append(tableName).append(" WHERE AD_Language=?");
        int no = DB.executeUpdateEx(sql.toString(), new Object[]{this.getAD_Language()}, this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(tableName + " #" + no);
        }
        return no;
    }

    private int addTable(String tableName) {
        String baseTableName = tableName.substring(0, tableName.length() - 4);
        MTable baseTable = MTable.get(this.getCtx(), baseTableName);
        StringBuilder cols = new StringBuilder();
        MColumn[] mColumnArray = baseTable.getColumns(false);
        int n = mColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            MColumn column = mColumnArray[n2];
            if (column.isTranslated()) {
                cols.append(",").append(column.getColumnName());
            }
            ++n2;
        }
        if (cols.length() == 0) {
            this.log.log(Level.SEVERE, "No Columns found for " + baseTableName);
            return 0;
        }
        int AD_User_ID = Env.getAD_User_ID(this.getCtx());
        String keyColumn = baseTable.getKeyColumns()[0];
        StringBuilder insert = new StringBuilder("INSERT INTO ").append(tableName).append("(AD_Language,IsTranslated, AD_Client_ID,AD_Org_ID, ").append("Createdby,UpdatedBy,Created,Updated, ").append(keyColumn).append((CharSequence)cols).append(") ").append("SELECT '").append(this.getAD_Language()).append("','N', AD_Client_ID,AD_Org_ID, ").append(AD_User_ID).append(",").append(AD_User_ID).append(", getDate(), getDate(), ").append(keyColumn).append((CharSequence)cols).append(" FROM ").append(baseTableName).append(" WHERE ").append(keyColumn).append(" NOT IN (SELECT ").append(keyColumn).append(" FROM ").append(tableName).append(" WHERE AD_Language='").append(this.getAD_Language()).append("')");
        int no = DB.executeUpdateEx(insert.toString(), null, this.get_TrxName());
        String uucolname = PO.getUUIDColumnName(tableName);
        MTable table2 = MTable.get(this.getCtx(), tableName);
        MColumn column = table2.getColumn(uucolname);
        if (column != null) {
            if (DB.isGenerateUUIDSupported()) {
                StringBuilder upduuid = new StringBuilder("UPDATE ").append(tableName).append(" SET ").append(uucolname).append("=generate_uuid() WHERE ").append(uucolname).append(" IS NULL");
                DB.executeUpdateEx(upduuid.toString(), this.get_TrxName());
            } else {
                UUIDGenerator.updateUUID(column, this.get_TrxName());
            }
        }
        StringBuilder msglog = new StringBuilder().append(tableName).append(" #").append(no);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(msglog.toString());
        }
        return no;
    }

    @Override
    public MLanguage markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

