/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.compiere.model.MColumn;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ImportTemplate;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutablePOSupport;
import org.supercsv.io.CsvMapReader;
import org.supercsv.prefs.CsvPreference;

public class MImportTemplate
extends X_AD_ImportTemplate
implements ImmutablePOSupport {
    private static final long serialVersionUID = 7751951143524784901L;
    private static CLogger s_log = CLogger.getCLogger(MImportTemplate.class);
    private static CCache<String, List<MImportTemplate>> s_cacheRoleTab = new CCache("AD_ImportTemplate", "AD_ImportTemplate_Of_Role", 5);
    public static final String UTF16BE_BOM = "\ufeff";

    public MImportTemplate(Properties ctx, String AD_ImportTemplate_UU, String trxName) {
        super(ctx, AD_ImportTemplate_UU, trxName);
    }

    public MImportTemplate(Properties ctx, int AD_ImportTemplate_ID, String trxName) {
        super(ctx, AD_ImportTemplate_ID, trxName);
    }

    public MImportTemplate(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MImportTemplate(MImportTemplate copy) {
        this(Env.getCtx(), copy);
    }

    public MImportTemplate(Properties ctx, MImportTemplate copy) {
        this(ctx, copy, null);
    }

    public MImportTemplate(Properties ctx, MImportTemplate copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getCharacterSet() == null) {
            this.setCharacterSet(Charset.defaultCharset().displayName());
        }
        if (this.getCharacterSet() == null || !Charset.isSupported(this.getCharacterSet())) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@Invalid@ @CharacterSet@"));
            return false;
        }
        if (this.is_new() || this.is_ValueChanged("CSVHeader") || this.is_ValueChanged("CSVAliasHeader") || this.is_ValueChanged("CharacterSet") || this.is_ValueChanged("SeparatorChar") || this.is_ValueChanged("QuoteChar") || this.is_ValueChanged("AD_Tab_ID")) {
            this.calculateAndValidateColumnTypes();
        }
        return super.beforeSave(newRecord);
    }

    public static List<MImportTemplate> getTemplates(int roleid, int tabid) {
        String key = roleid + "_" + tabid;
        List<MImportTemplate> retValue = s_cacheRoleTab.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new Query(Env.getCtx(), "AD_ImportTemplate", "IsActive = 'Y' AND AD_Client_ID IN ( 0, ? ) AND AD_Tab_ID = ? AND EXISTS (SELECT 1             FROM   AD_ImportTemplateAccess ita             WHERE  ita.AD_ImportTemplate_ID = AD_ImportTemplate.AD_ImportTemplate_ID                    AND ita.IsActive = 'Y'                    AND ( ita.AD_Role_ID = ?                           OR ita.AD_Role_ID IN (SELECT Included_Role_ID                                                 FROM   AD_Role_Included                                                 WHERE  AD_Role_ID = ? AND IsActive = 'Y') )                    AND ( IsAllowInsert = 'Y'                           OR IsAllowMerge = 'Y'                           OR IsAllowUpdate = 'Y' ))", null).setParameters(Env.getAD_Client_ID(Env.getCtx()), tabid, roleid, roleid).setOrderBy("Name").list();
        if (retValue.size() > 0) {
            retValue.stream().forEach(e -> {
                MImportTemplate mImportTemplate = e.markImmutable();
            });
        }
        s_cacheRoleTab.put(key, retValue);
        return retValue;
    }

    public boolean isAllowed(String importMode, int roleID) {
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) FROM   AD_ImportTemplateaccess WHERE  IsActive = 'Y'        AND AD_ImportTemplate_ID = ?        AND ( AD_Role_ID = ?               OR AD_Role_ID IN (SELECT Included_Role_ID                                 FROM   AD_Role_Included                                 WHERE  AD_Role_id = ?                                        AND IsActive = 'Y') )        AND IsAllow");
        if ("I".equals(importMode)) {
            sql.append("Insert");
        } else if ("U".equals(importMode)) {
            sql.append("Update");
        } else if ("M".equals(importMode)) {
            sql.append("Merge");
        } else {
            return false;
        }
        sql.append("='Y'");
        int cnt = DB.getSQLValueEx(this.get_TrxName(), sql.toString(), this.getAD_ImportTemplate_ID(), roleID, roleID);
        return cnt > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream validateFile(InputStream in) {
        if ("XLSX".equals(this.getImportTemplateType())) {
            try {
                in = this.convertExcelToCSV(in);
            }
            catch (Exception e) {
                throw new AdempiereException(Msg.getMsg(Env.getCtx(), "ErrorConvertingXlsToCsv") + " -> " + e.getLocalizedMessage(), e);
            }
        }
        Charset charset = Charset.forName(this.getCharacterSet());
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        File tmpfile = null;
        FileInputStream is = null;
        BufferedWriter bw = null;
        try {
            try {
                String firstLine = null;
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (firstLine == null) {
                        firstLine = line;
                        if (firstLine.startsWith(UTF16BE_BOM)) {
                            firstLine = firstLine.substring(1);
                        }
                        if (!firstLine.equals(this.getCSVHeader()) && !firstLine.equals(this.getCSVAliasHeader())) throw new AdempiereException(Msg.getMsg(Env.getCtx(), "WrongCSVHeader"));
                        tmpfile = File.createTempFile("CSVImportAction", ".csv");
                        bw = new BufferedWriter(new FileWriter(tmpfile, charset));
                        bw.write(this.getCSVHeader());
                    } else {
                        bw.write(line);
                    }
                    bw.write(10);
                }
                is = new FileInputStream(tmpfile);
            }
            catch (IOException e) {
                throw new AdempiereException(e);
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (bw != null) {
            try {
                bw.close();
            }
            catch (IOException iOException) {}
        }
        if (reader == null) return is;
        try {
            reader.close();
            return is;
        }
        catch (IOException iOException) {}
        return is;
    }

    public InputStream convertExcelToCSV(InputStream excelIs) throws IOException {
        Workbook workbook = WorkbookFactory.create((InputStream)excelIs);
        List<Integer> colTypes = this.calculateAndValidateColumnTypes();
        Sheet sheet = workbook.getSheetAt(0);
        File tmpfile = File.createTempFile("CSVImportActionConvert", ".csv");
        Charset charset = Charset.forName(this.getCharacterSet());
        Throwable throwable = null;
        Object var8_9 = null;
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(tmpfile, charset));){
            for (Row row : sheet) {
                boolean firstCell = true;
                int cn = 0;
                while (cn < colTypes.size()) {
                    int displayType = colTypes.get(cn);
                    Cell cell = row.getCell(cn, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                    if (firstCell) {
                        firstCell = false;
                    } else {
                        bw.append(this.getSeparatorChar());
                    }
                    CellType cellType = cell.getCellType();
                    if (cellType.equals((Object)CellType.FORMULA)) {
                        cellType = cell.getCachedFormulaResultType();
                    }
                    if (!(cellType.equals((Object)CellType.BLANK) || cellType.equals((Object)CellType.STRING) || cellType.equals((Object)CellType.BOOLEAN) || cellType.equals((Object)CellType.NUMERIC))) {
                        throw new IllegalStateException("Unsupported cell type: " + String.valueOf(cell.getCellType()));
                    }
                    if (!cellType.equals((Object)CellType.BLANK)) {
                        if (cellType.equals((Object)CellType.BOOLEAN)) {
                            if (cell.getBooleanCellValue()) {
                                bw.append("Y");
                            } else {
                                bw.append("N");
                            }
                        } else if (20 == displayType) {
                            if (cellType.equals((Object)CellType.NUMERIC)) {
                                double doubleValue = cell.getNumericCellValue();
                                if (doubleValue == 1.0) {
                                    bw.append("Y");
                                } else if (doubleValue == 0.0) {
                                    bw.append("N");
                                } else {
                                    this.addNumeric(bw, doubleValue, displayType);
                                }
                            } else {
                                String stringValue = cell.getStringCellValue();
                                if (stringValue.equalsIgnoreCase("true") || stringValue.equals("y")) {
                                    stringValue = "Y";
                                } else if (stringValue.equalsIgnoreCase("false") || stringValue.equals("n")) {
                                    stringValue = "N";
                                }
                                this.addString(bw, stringValue);
                            }
                        } else if (DisplayType.isDate(displayType)) {
                            if (cellType.equals((Object)CellType.NUMERIC)) {
                                SimpleDateFormat sdf = displayType == 15 ? DisplayType.getDateFormat_JDBC() : DisplayType.getTimestampFormat_Default();
                                Date date = cell.getDateCellValue();
                                this.addString(bw, sdf.format(date));
                            } else {
                                this.addString(bw, cell.getStringCellValue());
                            }
                        } else if (cellType.equals((Object)CellType.NUMERIC)) {
                            this.addNumeric(bw, cell.getNumericCellValue(), displayType);
                        } else {
                            this.addString(bw, cell.getStringCellValue());
                        }
                    }
                    ++cn;
                }
                bw.newLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        workbook.close();
        FileInputStream is = new FileInputStream(tmpfile);
        return is;
    }

    private void addString(BufferedWriter bw, String value) throws IOException {
        boolean addQuotes;
        boolean bl = addQuotes = value.contains(this.getQuoteChar()) || value.contains(this.getSeparatorChar());
        if (addQuotes) {
            bw.append(this.getQuoteChar());
        }
        bw.append(value.replace(this.getQuoteChar(), this.getQuoteChar().concat(this.getQuoteChar())));
        if (addQuotes) {
            bw.append(this.getQuoteChar());
        }
    }

    private void addNumeric(BufferedWriter bw, double doubleValue, int displayType) throws IOException {
        int intValue = (int)doubleValue;
        DecimalFormat df = DisplayType.getNumberFormat(displayType);
        if ((double)intValue == doubleValue || displayType == 11 || displayType == 18 || displayType == 19 || displayType == 30 || displayType == 200202) {
            df.setParseIntegerOnly(true);
            df.setMaximumFractionDigits(0);
        }
        df.setGroupingSize(0);
        String str = df.format(doubleValue);
        this.addString(bw, str);
    }

    private List<Integer> calculateAndValidateColumnTypes() {
        ArrayList<Integer> retValue = new ArrayList<Integer>();
        String delimiterChar = this.getSeparatorChar();
        String quoteChar = this.getQuoteChar();
        CsvPreference csvpref = new CsvPreference.Builder(quoteChar.charAt(0), (int)delimiterChar.charAt(0), "\r\n").build();
        ByteArrayInputStream is = null;
        List<String> csvHeaders = null;
        CsvMapReader mapReader = null;
        try {
            try {
                is = new ByteArrayInputStream(this.getCSVHeader().getBytes(this.getCharacterSet()));
                InputStreamReader reader = new InputStreamReader(is);
                mapReader = new CsvMapReader((Reader)reader, csvpref);
                csvHeaders = Arrays.asList(mapReader.getHeader(true));
            }
            catch (IOException e) {
                throw new AdempiereException(e);
            }
        }
        finally {
            if (mapReader != null) {
                try {
                    mapReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (csvHeaders == null || csvHeaders.size() == 0) {
            this.throwCSVHeaderNotFound("");
        }
        if (!Util.isEmpty(this.getCSVAliasHeader())) {
            ByteArrayInputStream isa = null;
            List<String> csvAliasHeaders = null;
            CsvMapReader mapReaderAlias = null;
            try {
                try {
                    isa = new ByteArrayInputStream(this.getCSVAliasHeader().getBytes(this.getCharacterSet()));
                    InputStreamReader reader = new InputStreamReader(isa);
                    mapReaderAlias = new CsvMapReader((Reader)reader, csvpref);
                    csvAliasHeaders = Arrays.asList(mapReaderAlias.getHeader(true));
                }
                catch (IOException e) {
                    throw new AdempiereException(e);
                }
            }
            finally {
                if (mapReaderAlias != null) {
                    try {
                        mapReaderAlias.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (csvAliasHeaders == null || csvAliasHeaders.size() != csvHeaders.size()) {
                throw new AdempiereException(Msg.getMsg(this.getCtx(), "CSVAliasHeaderNotValid"));
            }
        }
        MTab mainTab = MTab.get(this.getAD_Tab_ID());
        MTable mainTable = MTable.get(mainTab.getAD_Table_ID());
        for (String csvHeader : csvHeaders) {
            MColumn column;
            int idxClose;
            String columnHeader = csvHeader;
            if (columnHeader.endsWith("/K")) {
                columnHeader = columnHeader.substring(0, columnHeader.length() - 2);
            }
            String foreignColumnName = null;
            int idxOpen = columnHeader.indexOf("[");
            if (idxOpen > 0 && (idxClose = columnHeader.indexOf("]")) > 0 && idxClose > idxOpen) {
                foreignColumnName = columnHeader.substring(idxOpen + 1, idxClose);
                columnHeader = columnHeader.substring(0, idxOpen);
            }
            int idxTableSep = columnHeader.lastIndexOf(">");
            MTable table2 = null;
            String tableName = null;
            String columnName = null;
            if (idxTableSep > 0) {
                tableName = columnHeader.substring(0, idxTableSep);
                if (tableName.lastIndexOf(">") > 0) {
                    tableName = tableName.substring(tableName.lastIndexOf(">") + 1);
                }
                table2 = MTable.get(this.getCtx(), tableName);
                columnName = columnHeader.substring(idxTableSep + 1);
            } else {
                table2 = mainTable;
                tableName = table2.getTableName();
                columnName = columnHeader;
            }
            if (table2 == null) {
                this.throwCSVHeaderNotFound(csvHeader);
            }
            if ((column = table2.getColumn(columnName)) == null) {
                this.throwCSVHeaderNotFound(csvHeader);
            }
            String foreignTableName = null;
            if (foreignColumnName != null) {
                foreignTableName = column.getReferenceTableName();
                MTable foreignTable = MTable.get(this.getCtx(), foreignTableName);
                if (foreignTable == null) {
                    this.throwCSVHeaderNotFound(csvHeader);
                }
                if ((column = foreignTable.getColumn(foreignColumnName)) == null) {
                    this.throwCSVHeaderNotFound(csvHeader);
                }
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("CSV Header column found -> " + csvHeader + " -> " + tableName + "." + columnName + (String)(foreignColumnName != null ? "[" + foreignTableName + "." + foreignColumnName + "]" : ""));
            }
            int ref = column.getAD_Reference_ID();
            retValue.add(ref);
        }
        return retValue;
    }

    private void throwCSVHeaderNotFound(String csvHeader) {
        throw new AdempiereException(Msg.getMsg(this.getCtx(), "CSVHeaderColumnNotFound", new Object[]{csvHeader}));
    }

    @Override
    public MImportTemplate markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

