/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.ICostInfo;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MDocType;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInventoryLineMA;
import org.compiere.model.MProduct;
import org.compiere.model.ProductCost;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class Doc_Inventory
extends Doc {
    private int m_Reversal_ID = 0;
    private String m_DocStatus = "";
    private String parentDocSubTypeInv;

    public Doc_Inventory(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MInventory.class, rs, "MMI", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MInventory inventory = (MInventory)this.getPO();
        this.setDateDoc(inventory.getMovementDate());
        this.setDateAcct(inventory.getMovementDate());
        this.m_Reversal_ID = inventory.getReversal_ID();
        this.m_DocStatus = inventory.getDocStatus();
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        this.parentDocSubTypeInv = dt.getDocSubTypeInv();
        if ("CA".equals(this.parentDocSubTypeInv)) {
            if (inventory.getC_Currency_ID() == 0) {
                this.setC_Currency_ID(MClient.get(this.getCtx()).getAcctSchema().getC_Currency_ID());
            }
        } else {
            this.setC_Currency_ID(-2);
        }
        this.p_lines = this.loadLines(inventory);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Lines=" + this.p_lines.length);
        }
        return null;
    }

    private DocLine[] loadLines(MInventory inventory) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MInventoryLine[] lines = inventory.getLines(false);
        int i2 = 0;
        while (i2 < lines.length) {
            MInventoryLine line = lines[i2];
            if (line.isActive()) {
                String docSubTypeInv = Util.isEmpty(this.parentDocSubTypeInv) ? (line.getQtyInternalUse().signum() != 0 ? "IU" : "PI") : this.parentDocSubTypeInv;
                BigDecimal qtyDiff = Env.ZERO;
                BigDecimal amtDiff = Env.ZERO;
                if ("IU".equals(docSubTypeInv)) {
                    qtyDiff = line.getQtyInternalUse().negate();
                } else if ("PI".equals(docSubTypeInv)) {
                    qtyDiff = line.getQtyCount().subtract(line.getQtyBook());
                } else if ("CA".equals(docSubTypeInv)) {
                    amtDiff = line.getNewCostPrice().subtract(line.getCurrentCostPrice());
                }
                if (qtyDiff.signum() != 0 || amtDiff.signum() != 0) {
                    DocLine docLine = new DocLine(line, this);
                    docLine.setQty(qtyDiff, false);
                    if (amtDiff.signum() != 0) {
                        docLine.setAmount(amtDiff);
                    }
                    docLine.setReversalLine_ID(line.getReversalLine_ID());
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(docLine.toString());
                    }
                    list.add(docLine);
                }
            }
            ++i2;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        if (!"CA".equals(this.parentDocSubTypeInv)) {
            this.setC_Currency_ID(as.getC_Currency_ID());
        }
        FactLine dr = null;
        FactLine cr = null;
        MInventory inventory = (MInventory)this.getPO();
        boolean costAdjustment = "CA".equals(this.parentDocSubTypeInv);
        String docCostingMethod = inventory.getCostingMethod();
        HashMap<CallSite, BigDecimal> costMap = new HashMap<CallSite, BigDecimal>();
        int i2 = 0;
        while (i2 < this.p_lines.length) {
            MCostDetail cd;
            DocLine line = this.p_lines[i2];
            boolean doPosting = true;
            String costingLevel = null;
            MProduct product = null;
            if (costAdjustment) {
                product = line.getProduct();
                if (!product.isStocked()) {
                    doPosting = false;
                } else {
                    String productCostingMethod = product.getCostingMethod(as);
                    costingLevel = product.getCostingLevel(as);
                    if (!docCostingMethod.equals(productCostingMethod)) {
                        doPosting = false;
                    }
                }
            }
            BigDecimal costs = null;
            BigDecimal adjustmentDiff = null;
            if (costAdjustment) {
                costs = line.getAmtSource();
                product = line.getProduct();
                int orgId = line.getAD_Org_ID();
                int asiId = line.getM_AttributeSetInstance_ID();
                if ("C".equals(costingLevel)) {
                    orgId = 0;
                    asiId = 0;
                } else if ("O".equals(costingLevel)) {
                    asiId = 0;
                } else if ("B".equals(costingLevel)) {
                    orgId = 0;
                }
                MCostElement ce = MCostElement.getMaterialCostElement(this.getCtx(), docCostingMethod, orgId);
                cd = MCostDetail.getInventory(as, product.getM_Product_ID(), asiId, this.get_ID(), ce.getM_CostElement_ID(), this.getTrxName());
                ICostInfo cost = MCost.getCostInfo(product, asiId, as, orgId, ce.getM_CostElement_ID(), this.getDateAcct(), cd, this.getTrxName());
                BigDecimal currentQty = cost.getCurrentQty();
                adjustmentDiff = costs;
                costs = costs.multiply(currentQty);
            } else if (!this.isReversal(line)) {
                product = line.getProduct();
                if ("B".equals(product.getCostingLevel(as))) {
                    if (line.getM_AttributeSetInstance_ID() == 0) {
                        MInventoryLine invLine = (MInventoryLine)line.getPO();
                        MInventoryLineMA[] mas = MInventoryLineMA.get(this.getCtx(), invLine.get_ID(), this.getTrxName());
                        if (mas != null && mas.length > 0) {
                            costs = BigDecimal.ZERO;
                            int j = 0;
                            while (j < mas.length) {
                                MInventoryLineMA ma = mas[j];
                                BigDecimal QtyMA = ma.getMovementQty();
                                ProductCost pc = line.getProductCost();
                                pc.setQty(QtyMA.negate());
                                pc.setM_M_AttributeSetInstance_ID(ma.getM_AttributeSetInstance_ID());
                                BigDecimal maCosts = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InventoryLine_ID=?");
                                costMap.put((CallSite)((Object)(line.get_ID() + "_" + ma.getM_AttributeSetInstance_ID())), maCosts);
                                costs = costs.add(maCosts);
                                ++j;
                            }
                        }
                    } else {
                        costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InventoryLine_ID=?");
                    }
                } else {
                    costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InventoryLine_ID=?");
                }
                if (costs == null || costs.signum() == 0) {
                    this.p_Error = "No Costs for " + line.getProduct().getName();
                    return null;
                }
            } else {
                costs = Env.ONE;
            }
            if (doPosting) {
                int C_Currency_ID = this.getC_Currency_ID() > 0 ? this.getC_Currency_ID() : as.getC_Currency_ID();
                dr = fact.createLine(line, line.getAccount(3, as), C_Currency_ID, costs);
                if (dr != null) {
                    dr.setM_Locator_ID(line.getM_Locator_ID());
                    if (this.isReversal(line)) {
                        if (!dr.updateReverseLine(321, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                            this.p_Error = "Original Physical Inventory not posted yet";
                            return null;
                        }
                        costs = dr.getAcctBalance();
                    }
                    MAccount invDiff = null;
                    invDiff = this.isReversal(line) && line.getC_Charge_ID() != 0 ? line.getChargeAccount(as, costs) : line.getChargeAccount(as, costs.negate());
                    if (invDiff == null) {
                        invDiff = costAdjustment ? line.getProductCost().getAccount(9, as) : this.getAccount(50, as);
                    }
                    if ((cr = fact.createLine(line, invDiff, C_Currency_ID, costs.negate())) != null) {
                        cr.setM_Locator_ID(line.getM_Locator_ID());
                        cr.setQty(line.getQty().negate());
                        if (line.getC_Charge_ID() != 0) {
                            cr.setAD_Org_ID(line.getAD_Org_ID());
                        }
                        if (this.isReversal(line) && !cr.updateReverseLine(321, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE, dr)) {
                            this.p_Error = "Original Physical Inventory not posted yet";
                            return null;
                        }
                    }
                }
            }
            if (doPosting || costAdjustment) {
                BigDecimal costDetailAmt;
                product = line.getProduct();
                BigDecimal bigDecimal = costDetailAmt = costAdjustment ? adjustmentDiff : costs;
                if (costAdjustment && this.getC_Currency_ID() > 0 && this.getC_Currency_ID() != as.getC_Currency_ID()) {
                    costDetailAmt = MConversionRate.convert(this.getCtx(), costDetailAmt, this.getC_Currency_ID(), as.getC_Currency_ID(), this.getDateAcct(), 0, this.getAD_Client_ID(), this.getAD_Org_ID(), true);
                }
                if ("B".equals(product.getCostingLevel(as))) {
                    if (line.getM_AttributeSetInstance_ID() == 0) {
                        MInventoryLine invLine = (MInventoryLine)line.getPO();
                        MInventoryLineMA[] mas = MInventoryLineMA.get(this.getCtx(), invLine.get_ID(), this.getTrxName());
                        if (mas != null && mas.length > 0) {
                            costs = BigDecimal.ZERO;
                            int j = 0;
                            while (j < mas.length) {
                                MCostDetail cd2;
                                MInventoryLineMA ma = mas[j];
                                BigDecimal maCost = (BigDecimal)costMap.get(line.get_ID() + "_" + ma.getM_AttributeSetInstance_ID());
                                BigDecimal qty = ma.getMovementQty();
                                if (qty.signum() != line.getQty().signum()) {
                                    qty = qty.negate();
                                }
                                if (maCost.signum() != costDetailAmt.signum()) {
                                    maCost = maCost.negate();
                                }
                                int Ref_CostDetail_ID = 0;
                                if (line.getReversalLine_ID() > 0 && line.get_ID() > line.getReversalLine_ID() && (cd2 = MCostDetail.getInventory(as, line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), line.getReversalLine_ID(), 0, this.getTrxName())) != null) {
                                    Ref_CostDetail_ID = cd2.getM_CostDetail_ID();
                                }
                                if (!MCostDetail.createInventory(as, line.getAD_Org_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), line.get_ID(), 0, maCost, qty, line.getDescription(), line.getDateAcct(), Ref_CostDetail_ID, this.getTrxName())) {
                                    this.p_Error = "Failed to create cost detail record";
                                    return null;
                                }
                                ++j;
                            }
                        }
                    } else {
                        BigDecimal amt = costDetailAmt;
                        int Ref_CostDetail_ID = 0;
                        if (line.getReversalLine_ID() > 0 && line.get_ID() > line.getReversalLine_ID() && (cd = MCostDetail.getInventory(as, line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.getReversalLine_ID(), 0, this.getTrxName())) != null) {
                            Ref_CostDetail_ID = cd.getM_CostDetail_ID();
                        }
                        if (!MCostDetail.createInventory(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, amt, line.getQty(), line.getDescription(), line.getDateAcct(), Ref_CostDetail_ID, this.getTrxName())) {
                            this.p_Error = "Failed to create cost detail record";
                            return null;
                        }
                    }
                } else {
                    BigDecimal amt = costDetailAmt;
                    int Ref_CostDetail_ID = 0;
                    if (line.getReversalLine_ID() > 0 && line.get_ID() > line.getReversalLine_ID() && (cd = MCostDetail.getInventory(as, line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.getReversalLine_ID(), 0, this.getTrxName())) != null) {
                        Ref_CostDetail_ID = cd.getM_CostDetail_ID();
                    }
                    if (!MCostDetail.createInventory(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, amt, line.getQty(), line.getDescription(), line.getDateAcct(), Ref_CostDetail_ID, this.getTrxName())) {
                        this.p_Error = "Failed to create cost detail record";
                        return null;
                    }
                }
            }
            ++i2;
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    private boolean isReversal(DocLine line) {
        return this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0;
    }
}

