/******************************************************************************
 * Product: iDempiere ERP & CRM Smart Business Solution                       *
 * Copyright (C) 1999-2012 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 2620 Augustine Dr. #245, Santa Clara, CA 95054, USA        *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.util.KeyNamePair;

/** Generated Interface for PA_RatioElement
 *  @author iDempiere (generated) 
 *  @version Release 12
 */
public interface I_PA_RatioElement 
{

    /** TableName=PA_RatioElement */
    public static final String Table_Name = "PA_RatioElement";

    /** AD_Table_ID=836 */
    public static final int Table_ID = 836;

    KeyNamePair Model = new KeyNamePair(Table_ID, Table_Name);

    /** AccessLevel = 2 - Client 
     */
    BigDecimal accessLevel = BigDecimal.valueOf(2);

    /** Load Meta Data */

    /** Column name AD_Client_ID */
    public static final String COLUMNNAME_AD_Client_ID = "AD_Client_ID";

	/** Get Tenant.
	  * Tenant for this installation.
	  */
	public int getAD_Client_ID();

    /** Column name AD_Org_ID */
    public static final String COLUMNNAME_AD_Org_ID = "AD_Org_ID";

	/** Set Organization.
	  * Organizational entity within tenant
	  */
	public void setAD_Org_ID (int AD_Org_ID);

	/** Get Organization.
	  * Organizational entity within tenant
	  */
	public int getAD_Org_ID();

    /** Column name Account_ID */
    public static final String COLUMNNAME_Account_ID = "Account_ID";

	/** Set Account.
	  * Account used
	  */
	public void setAccount_ID (int Account_ID);

	/** Get Account.
	  * Account used
	  */
	public int getAccount_ID();

	public org.compiere.model.I_C_ElementValue getAccount() throws RuntimeException;

    /** Column name ConstantValue */
    public static final String COLUMNNAME_ConstantValue = "ConstantValue";

	/** Set Constant Value.
	  * Constant value
	  */
	public void setConstantValue (BigDecimal ConstantValue);

	/** Get Constant Value.
	  * Constant value
	  */
	public BigDecimal getConstantValue();

    /** Column name Created */
    public static final String COLUMNNAME_Created = "Created";

	/** Get Created.
	  * Date this record was created
	  */
	public Timestamp getCreated();

    /** Column name CreatedBy */
    public static final String COLUMNNAME_CreatedBy = "CreatedBy";

	/** Get Created By.
	  * User who created this records
	  */
	public int getCreatedBy();

    /** Column name Description */
    public static final String COLUMNNAME_Description = "Description";

	/** Set Description.
	  * Optional short description of the record
	  */
	public void setDescription (String Description);

	/** Get Description.
	  * Optional short description of the record
	  */
	public String getDescription();

    /** Column name IsActive */
    public static final String COLUMNNAME_IsActive = "IsActive";

	/** Set Active.
	  * The record is active in the system
	  */
	public void setIsActive (boolean IsActive);

	/** Get Active.
	  * The record is active in the system
	  */
	public boolean isActive();

    /** Column name Name */
    public static final String COLUMNNAME_Name = "Name";

	/** Set Name.
	  * Alphanumeric identifier of the entity
	  */
	public void setName (String Name);

	/** Get Name.
	  * Alphanumeric identifier of the entity
	  */
	public String getName();

    /** Column name PA_MeasureCalc_ID */
    public static final String COLUMNNAME_PA_MeasureCalc_ID = "PA_MeasureCalc_ID";

	/** Set Measure Calculation.
	  * Calculation method for measuring performance
	  */
	public void setPA_MeasureCalc_ID (int PA_MeasureCalc_ID);

	/** Get Measure Calculation.
	  * Calculation method for measuring performance
	  */
	public int getPA_MeasureCalc_ID();

	public org.compiere.model.I_PA_MeasureCalc getPA_MeasureCalc() throws RuntimeException;

    /** Column name PA_RatioElement_ID */
    public static final String COLUMNNAME_PA_RatioElement_ID = "PA_RatioElement_ID";

	/** Set Ratio Element.
	  * Performance Ratio Element
	  */
	public void setPA_RatioElement_ID (int PA_RatioElement_ID);

	/** Get Ratio Element.
	  * Performance Ratio Element
	  */
	public int getPA_RatioElement_ID();

    /** Column name PA_RatioElement_UU */
    public static final String COLUMNNAME_PA_RatioElement_UU = "PA_RatioElement_UU";

	/** Set PA_RatioElement_UU	  */
	public void setPA_RatioElement_UU (String PA_RatioElement_UU);

	/** Get PA_RatioElement_UU	  */
	public String getPA_RatioElement_UU();

    /** Column name PA_RatioUsed_ID */
    public static final String COLUMNNAME_PA_RatioUsed_ID = "PA_RatioUsed_ID";

	/** Set Ratio Used.
	  * Performance Ratio Used
	  */
	public void setPA_RatioUsed_ID (int PA_RatioUsed_ID);

	/** Get Ratio Used.
	  * Performance Ratio Used
	  */
	public int getPA_RatioUsed_ID();

	public org.compiere.model.I_PA_Ratio getPA_RatioUsed() throws RuntimeException;

    /** Column name PA_Ratio_ID */
    public static final String COLUMNNAME_PA_Ratio_ID = "PA_Ratio_ID";

	/** Set Ratio.
	  * Performance Ratio
	  */
	public void setPA_Ratio_ID (int PA_Ratio_ID);

	/** Get Ratio.
	  * Performance Ratio
	  */
	public int getPA_Ratio_ID();

	public org.compiere.model.I_PA_Ratio getPA_Ratio() throws RuntimeException;

    /** Column name PostingType */
    public static final String COLUMNNAME_PostingType = "PostingType";

	/** Set Posting Type.
	  * The type of posted amount for the transaction
	  */
	public void setPostingType (String PostingType);

	/** Get Posting Type.
	  * The type of posted amount for the transaction
	  */
	public String getPostingType();

    /** Column name RatioElementType */
    public static final String COLUMNNAME_RatioElementType = "RatioElementType";

	/** Set Element Type.
	  * Ratio Element Type
	  */
	public void setRatioElementType (String RatioElementType);

	/** Get Element Type.
	  * Ratio Element Type
	  */
	public String getRatioElementType();

    /** Column name RatioOperand */
    public static final String COLUMNNAME_RatioOperand = "RatioOperand";

	/** Set Operand.
	  * Ratio Operand
	  */
	public void setRatioOperand (String RatioOperand);

	/** Get Operand.
	  * Ratio Operand
	  */
	public String getRatioOperand();

    /** Column name SeqNo */
    public static final String COLUMNNAME_SeqNo = "SeqNo";

	/** Set Sequence.
	  * Method of ordering records;
 lowest number comes first
	  */
	public void setSeqNo (int SeqNo);

	/** Get Sequence.
	  * Method of ordering records;
 lowest number comes first
	  */
	public int getSeqNo();

    /** Column name Updated */
    public static final String COLUMNNAME_Updated = "Updated";

	/** Get Updated.
	  * Date this record was updated
	  */
	public Timestamp getUpdated();

    /** Column name UpdatedBy */
    public static final String COLUMNNAME_UpdatedBy = "UpdatedBy";

	/** Get Updated By.
	  * User who updated this records
	  */
	public int getUpdatedBy();
}
