/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.equinox;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeMap;
import org.adempiere.base.ServiceQuery;
import org.adempiere.base.equinox.ExtensionPriorityManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ExtensionList<T>
implements Iterable<T> {
    private IConfigurationElement[] elements;
    private HashMap<String, String> filters = new HashMap();
    private String extensionId;

    public ExtensionList(Class<T> clazz, String extensionPointId) {
        if (extensionPointId == null) {
            extensionPointId = clazz.getName();
        }
        try {
            this.elements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointId);
            if (this.elements != null && this.elements.length > 1) {
                this.elements = this.sort(this.elements);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public ExtensionList(Class<T> type, String extensionPointId, String extensionId, ServiceQuery query) {
        this(type, extensionPointId);
        this.extensionId = extensionId;
        if (query != null) {
            for (String key : query.keySet()) {
                this.addFilter(key, (String)query.get(key));
            }
        }
    }

    private IConfigurationElement[] sort(IConfigurationElement[] elementArray) {
        IConfigurationElement[] result = elementArray;
        TreeMap<Integer, ArrayList<IConfigurationElement>> elementMap = new TreeMap<Integer, ArrayList<IConfigurationElement>>();
        ArrayList<IConfigurationElement> elementList = new ArrayList<IConfigurationElement>();
        Object object = elementArray;
        int n = elementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = object[n2];
            int priority = ExtensionPriorityManager.getInstance().getPriority(element);
            if (priority > 0) {
                ArrayList<IConfigurationElement> list = (ArrayList<IConfigurationElement>)elementMap.get(priority);
                if (list == null) {
                    list = new ArrayList<IConfigurationElement>();
                    elementMap.put(priority, list);
                }
                list.add(element);
            } else {
                elementList.add(element);
            }
            ++n2;
        }
        if (!elementMap.isEmpty()) {
            result = new IConfigurationElement[elementArray.length];
            NavigableSet keySet = elementMap.descendingKeySet();
            int i2 = 0;
            for (Integer key : keySet) {
                List list = (List)elementMap.get(key);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    IConfigurationElement element;
                    result[i2] = element = (IConfigurationElement)iterator.next();
                    ++i2;
                }
            }
            object = elementList.iterator();
            while (object.hasNext()) {
                IConfigurationElement element;
                result[i2] = element = (IConfigurationElement)object.next();
                ++i2;
            }
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return new ExtensionIterator();
    }

    public void addFilter(String attribute, String value) {
        this.filters.put(attribute, value);
    }

    public T first() {
        Iterator<T> i2 = this.iterator();
        if (!i2.hasNext()) {
            return null;
        }
        return i2.next();
    }

    public List<T> asList() {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : this) {
            result.add(t);
        }
        return result;
    }

    public class ExtensionIterator<E extends T>
    implements Iterator<T> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            this.iterateUntilAccepted();
            return this.index < ExtensionList.this.elements.length;
        }

        private void iterateUntilAccepted() {
            while (this.index < ExtensionList.this.elements.length) {
                if (this.accept(ExtensionList.this.elements[this.index])) break;
                ++this.index;
            }
        }

        private boolean accept(IConfigurationElement element) {
            String id;
            if (ExtensionList.this.extensionId != null && !ExtensionList.this.extensionId.equals(id = element.getDeclaringExtension().getUniqueIdentifier())) {
                return false;
            }
            for (String name : ExtensionList.this.filters.keySet()) {
                String actual;
                String expected = ExtensionList.this.filters.get(name);
                if (expected.equals(actual = element.getAttribute(name))) continue;
                return false;
            }
            return true;
        }

        @Override
        public E next() {
            IConfigurationElement[] childs;
            this.iterateUntilAccepted();
            IConfigurationElement e = ExtensionList.this.elements[this.index++];
            if (e.getAttribute("class") == null && (childs = e.getChildren()) != null && childs.length > 0) {
                IConfigurationElement[] iConfigurationElementArray = childs;
                int n = childs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement child = iConfigurationElementArray[n2];
                    if (child.getAttribute("class") != null) {
                        e = child;
                        break;
                    }
                    ++n2;
                }
            }
            try {
                return (E)e.createExecutableExtension("class");
            }
            catch (CoreException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

