/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MField;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTab;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;

@Process
public class TabCopy
extends SvrProcess {
    private int p_AD_TabTo_ID = 0;
    private int p_AD_TabFrom_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Tab_ID")) {
                    this.p_AD_TabFrom_ID = para[i].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_AD_TabTo_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MTab from;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("To AD_Tab_ID=" + this.p_AD_TabTo_ID + ", From=" + this.p_AD_TabFrom_ID);
        }
        if ((from = new MTab(this.getCtx(), this.p_AD_TabFrom_ID, this.get_TrxName())).get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ (from->) @AD_Tab_ID@");
        }
        MTab to = new MTab(this.getCtx(), this.p_AD_TabTo_ID, this.get_TrxName());
        if (to.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ (to<-) @AD_Tab_ID@");
        }
        if (from.getAD_Table_ID() != to.getAD_Table_ID()) {
            throw new AdempiereUserError("@Error@ @AD_Table_ID@");
        }
        DB.executeUpdateEx((String)"UPDATE ad_tab_trl SET    name = (SELECT name                FROM   ad_tab_trl t2                WHERE  t2.ad_tab_id = ? AND t2.ad_language = ad_tab_trl.ad_language),        description = (SELECT description                       FROM   ad_tab_trl t2                       WHERE  t2.ad_tab_id = ? AND t2.ad_language = ad_tab_trl.ad_language),        help = (SELECT help                FROM   ad_tab_trl t2                WHERE  t2.ad_tab_id = ? AND t2.ad_language = ad_tab_trl.ad_language),        commitwarning = (SELECT commitwarning                         FROM   ad_tab_trl t2                         WHERE  t2.ad_tab_id = ? AND t2.ad_language = ad_tab_trl.ad_language),        istranslated = (SELECT istranslated                        FROM   ad_tab_trl t2                        WHERE  t2.ad_tab_id = ? AND t2.ad_language = ad_tab_trl.ad_language) WHERE  ad_tab_id = ?", (Object[])new Object[]{from.get_ID(), from.get_ID(), from.get_ID(), from.get_ID(), from.get_ID(), to.get_ID()}, (String)this.get_TrxName());
        int count = 0;
        MField[] mFieldArray = from.getFields(false, this.get_TrxName());
        int n = mFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            MField oldField = mFieldArray[n2];
            if (!new Query(this.getCtx(), "AD_Field", "AD_Tab_ID=? AND AD_Column_ID=?", this.get_TrxName()).setParameters(new Object[]{to.getAD_Tab_ID(), oldField.getAD_Column_ID()}).match()) {
                MField newField = new MField(to, oldField);
                if (!oldField.isActive()) {
                    newField.setIsActive(false);
                }
                if (newField.save()) {
                    DB.executeUpdateEx((String)"UPDATE ad_field_trl SET    name = (SELECT name                FROM   ad_field_trl t2                WHERE  t2.ad_field_id = ? AND t2.ad_language = ad_field_trl.ad_language),        description = (SELECT description                       FROM   ad_field_trl t2                       WHERE  t2.ad_field_id = ? AND t2.ad_language = ad_field_trl.ad_language),        help = (SELECT help                FROM   ad_field_trl t2                WHERE  t2.ad_field_id = ? AND t2.ad_language = ad_field_trl.ad_language),        istranslated = (SELECT istranslated                        FROM   ad_field_trl t2                        WHERE  t2.ad_field_id = ? AND t2.ad_language = ad_field_trl.ad_language) WHERE  ad_field_id = ?", (Object[])new Object[]{oldField.get_ID(), oldField.get_ID(), oldField.get_ID(), oldField.get_ID(), newField.get_ID()}, (String)this.get_TrxName());
                    ++count;
                } else {
                    throw new AdempiereUserError("@Error@ @AD_Field_ID@");
                }
            }
            ++n2;
        }
        StringBuilder msgreturn = new StringBuilder("@Copied@ #").append(count);
        return msgreturn.toString();
    }
}

