/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MColumn;
import org.compiere.model.MElementValue;
import org.compiere.model.MProcessPara;
import org.compiere.model.X_I_ElementValue;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

@Process
public class ImportAccount
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_C_Element_ID = 0;
    private boolean m_updateDefaultAccounts = false;
    private boolean m_createNewCombination = true;
    private boolean m_deleteOldImported = false;
    private Timestamp m_DateValue = null;
    private static final int UPDATE_ERROR = 0;
    private static final int UPDATE_YES = 1;
    private static final int UPDATE_SAME = 2;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Client_ID")) {
                    this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_Element_ID")) {
                    this.m_C_Element_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("UpdateDefaultAccounts")) {
                    this.m_updateDefaultAccounts = "Y".equals(para[i].getParameter());
                } else if (name.equals("CreateNewCombination")) {
                    this.m_createNewCombination = "Y".equals(para[i].getParameter());
                } else if (name.equals("DeleteOldImported")) {
                    this.m_deleteOldImported = "Y".equals(para[i].getParameter());
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    protected String doIt() throws Exception {
        int noParentUpdate;
        StringBuilder clientCheck;
        int no;
        StringBuilder sql;
        block43: {
            sql = null;
            no = 0;
            clientCheck = new StringBuilder(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
            if (this.m_deleteOldImported) {
                sql = new StringBuilder("DELETE FROM I_ElementValue ").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Delete Old Impored =" + no);
                }
            }
            sql = new StringBuilder("UPDATE I_ElementValue ").append("SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("),").append(" AD_Org_ID = COALESCE (AD_Org_ID, 0),").append(" IsActive = COALESCE (IsActive, 'Y'),").append(" Created = COALESCE (Created, getDate()),").append(" CreatedBy = COALESCE (CreatedBy, 0),").append(" Updated = COALESCE (Updated, getDate()),").append(" UpdatedBy = COALESCE (UpdatedBy, 0),").append(" I_ErrorMsg = ' ',").append(" Processed = 'N', ").append(" Processing = 'Y', ").append(" I_IsImported = 'N' ").append("WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Reset=" + no);
            }
            if (this.m_C_Element_ID != 0) {
                sql = new StringBuilder("UPDATE I_ElementValue ").append("SET ElementName=(SELECT Name FROM C_Element WHERE C_Element_ID=").append(this.m_C_Element_ID).append(") ").append("WHERE ElementName IS NULL AND C_Element_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Set Element Default=" + no);
                }
            }
            sql = new StringBuilder("UPDATE I_ElementValue i ").append("SET C_Element_ID = (SELECT C_Element_ID FROM C_Element e").append(" WHERE i.ElementName=e.Name AND i.AD_Client_ID=e.AD_Client_ID)").append("WHERE C_Element_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set Element=" + no);
            }
            sql = new StringBuilder("UPDATE I_ElementValue ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Element, ' ").append("WHERE C_Element_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Invalid Element=" + no);
            }
            sql = new StringBuilder("UPDATE I_ElementValue ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Name, ' ").append("WHERE (Value IS NULL OR Name IS NULL)").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Invalid Name=" + no);
            }
            sql = new StringBuilder("UPDATE I_ElementValue i ").append("SET AD_Column_ID = (SELECT AD_Column_ID FROM AD_Column c").append(" WHERE UPPER(i.Default_Account)=UPPER(c.ColumnName)").append(" AND c.AD_Table_ID IN (315,266) AND AD_Reference_ID=25) ").append("WHERE Default_Account IS NOT NULL AND AD_Column_ID IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set Column=" + no);
            }
            sql = new StringBuilder("UPDATE I_ElementValue ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Column, ' ").append("WHERE AD_Column_ID IS NULL AND Default_Account IS NOT NULL").append(" AND UPPER(Default_Account)<>'DEFAULT_ACCT'").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Invalid Column=" + no);
            }
            String[] yColumns = new String[]{"PostActual", "PostBudget", "PostStatistical", "PostEncumbrance"};
            int i = 0;
            while (i < yColumns.length) {
                sql = new StringBuilder("UPDATE I_ElementValue SET ").append(yColumns[i]).append("='Y' WHERE ").append(yColumns[i]).append(" IS NULL OR ").append(yColumns[i]).append(" NOT IN ('Y','N')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                StringBuilder msglog = new StringBuilder("Set ").append(yColumns[i]).append(" Default=").append(no);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(msglog.toString());
                }
                ++i;
            }
            sql = new StringBuilder("UPDATE I_ElementValue ").append("SET IsSummary='N' ").append("WHERE IsSummary IS NULL OR IsSummary NOT IN ('Y','N')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set IsSummary Default=" + no);
            }
            sql = new StringBuilder("UPDATE I_ElementValue ").append("SET IsDocControlled = CASE WHEN AD_Column_ID IS NOT NULL THEN 'Y' ELSE 'N' END ").append("WHERE IsDocControlled IS NULL OR IsDocControlled NOT IN ('Y','N')").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set IsDocumentControlled Default=" + no);
            }
            sql = new StringBuilder("UPDATE I_ElementValue ").append("SET AccountType='E' ").append("WHERE AccountType IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set AccountType Default=" + no);
            }
            sql = new StringBuilder("UPDATE I_ElementValue ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid AccountType, ' ").append("WHERE AccountType NOT IN ('A','E','L','M','O','R')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Invalid AccountType=" + no);
            }
            sql = new StringBuilder("UPDATE I_ElementValue ").append("SET AccountSign='N' ").append("WHERE AccountSign IS NULL").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Set AccountSign Default=" + no);
            }
            sql = new StringBuilder("UPDATE I_ElementValue ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid AccountSign, ' ").append("WHERE AccountSign NOT IN ('N','C','D')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Invalid AccountSign=" + no);
            }
            sql = new StringBuilder("UPDATE I_ElementValue ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Key, ' ").append("WHERE (Value IS NULL OR Value='')").append(" AND I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Invalid Key=" + no);
            }
            sql = new StringBuilder("UPDATE I_ElementValue i ").append("SET C_ElementValue_ID=(SELECT C_ElementValue_ID FROM C_ElementValue ev").append(" INNER JOIN C_Element e ON (ev.C_Element_ID=e.C_Element_ID)").append(" WHERE i.C_Element_ID=e.C_Element_ID AND i.AD_Client_ID=e.AD_Client_ID").append(" AND i.Value=ev.Value) ").append("WHERE C_ElementValue_ID IS NULL").append(" AND I_IsImported='N'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Found ElementValue=" + no);
            }
            this.commitEx();
            int noInsert = 0;
            int noUpdate = 0;
            sql = new StringBuilder("SELECT * ").append("FROM I_ElementValue ").append("WHERE I_IsImported='N'").append((CharSequence)clientCheck).append(" ORDER BY I_ElementValue_ID");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MElementValue ev;
                        X_I_ElementValue impEV = new X_I_ElementValue(this.getCtx(), rs, this.get_TrxName());
                        int C_ElementValue_ID = impEV.getC_ElementValue_ID();
                        int I_ElementValue_ID = impEV.getI_ElementValue_ID();
                        if (C_ElementValue_ID == 0) {
                            ev = new MElementValue(impEV);
                            if (ev.save()) {
                                ++noInsert;
                                impEV.setC_ElementValue_ID(ev.getC_ElementValue_ID());
                                impEV.setI_IsImported(true);
                                impEV.saveEx();
                                continue;
                            }
                            sql = new StringBuilder("UPDATE I_ElementValue i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING((String)"Insert ElementValue ")).append("WHERE I_ElementValue_ID=").append(I_ElementValue_ID);
                            DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                            continue;
                        }
                        ev = new MElementValue(this.getCtx(), C_ElementValue_ID, this.get_TrxName());
                        ev.get_ID();
                        ev.set(impEV);
                        if (ev.save()) {
                            ++noUpdate;
                            impEV.setI_IsImported(true);
                            impEV.saveEx();
                            continue;
                        }
                        sql = new StringBuilder("UPDATE I_ElementValue i ").append("SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING((String)"Update ElementValue")).append("WHERE I_ElementValue_ID=").append(I_ElementValue_ID);
                        DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                    }
                }
                catch (SQLException e) {
                    throw new Exception("create", e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            sql = new StringBuilder("UPDATE I_ElementValue ").append("SET I_IsImported='N', Updated=getDate() ").append("WHERE I_IsImported<>'Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(0, null, new BigDecimal(no), "@Errors@");
            this.addLog(0, null, new BigDecimal(noInsert), "@C_ElementValue_ID@: @Inserted@");
            this.addLog(0, null, new BigDecimal(noUpdate), "@C_ElementValue_ID@: @Updated@");
            this.commitEx();
            sql = new StringBuilder("UPDATE I_ElementValue i ").append("SET ParentElementValue_ID=(SELECT C_ElementValue_ID").append(" FROM C_ElementValue ev WHERE i.C_Element_ID=ev.C_Element_ID").append(" AND i.ParentValue=ev.Value AND i.AD_Client_ID=ev.AD_Client_ID) ").append("WHERE ParentElementValue_ID IS NULL").append(" AND I_IsImported='Y'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Found Parent ElementValue=" + no);
            }
            sql = new StringBuilder("UPDATE I_ElementValue ").append("SET I_ErrorMsg=I_ErrorMsg||'Info=ParentNotFound, ' ").append("WHERE ParentElementValue_ID IS NULL AND ParentValue IS NOT NULL").append(" AND I_IsImported='Y' AND Processed='N'").append((CharSequence)clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Not Found Parent ElementValue=" + no);
            }
            sql = new StringBuilder("SELECT COALESCE(i.ParentElementValue_ID, 0), i.I_ElementValue_ID,").append(" e.AD_Tree_ID, i.C_ElementValue_ID, i.Value||'-'||i.Name AS Info ").append("FROM I_ElementValue i").append(" INNER JOIN C_Element e ON (i.C_Element_ID=e.C_Element_ID) ").append("WHERE i.C_ElementValue_ID IS NOT NULL AND e.AD_Tree_ID IS NOT NULL").append(" AND i.I_IsImported='Y' AND Processed='N' AND i.AD_Client_ID=").append(this.m_AD_Client_ID);
            noParentUpdate = 0;
            CPreparedStatement updateStmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    String updateSQL = "UPDATE AD_TreeNode SET Parent_ID=?, SeqNo=? WHERE AD_Tree_ID=? AND Node_ID=?";
                    updateStmt = DB.prepareStatement((String)updateSQL, (int)1003, (int)1008, (String)this.get_TrxName());
                    while (rs.next()) {
                        updateStmt.setInt(1, rs.getInt(1));
                        updateStmt.setInt(2, rs.getInt(2));
                        updateStmt.setInt(3, rs.getInt(3));
                        updateStmt.setInt(4, rs.getInt(4));
                        try {
                            no = updateStmt.executeUpdate();
                            noParentUpdate += no;
                        }
                        catch (SQLException ex) {
                            this.log.log(Level.SEVERE, "(ParentUpdate)", (Throwable)ex);
                            no = 0;
                        }
                        if (no != 0 || !this.log.isLoggable(Level.INFO)) continue;
                        this.log.info("Parent not found for " + rs.getString(5));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, "(ParentUpdateLoop) " + sql.toString(), (Throwable)e);
                    DB.close(updateStmt);
                    updateStmt = null;
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block43;
                }
            }
            catch (Throwable throwable) {
                DB.close(updateStmt);
                updateStmt = null;
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((Statement)updateStmt);
            updateStmt = null;
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.addLog(0, null, new BigDecimal(noParentUpdate), "@ParentElementValue_ID@: @Updated@");
        this.commitEx();
        sql = new StringBuilder("UPDATE I_ElementValue ").append("SET Processing='-'").append("WHERE I_IsImported='Y' AND Processed='N' AND Processing='Y'").append(" AND C_ElementValue_ID IS NOT NULL").append((CharSequence)clientCheck);
        if (this.m_updateDefaultAccounts) {
            sql.append(" AND AD_Column_ID IS NULL");
        }
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Reset Processing Flag=" + no);
        }
        if (this.m_updateDefaultAccounts) {
            this.updateDefaults(clientCheck.toString());
        }
        sql = new StringBuilder("SELECT * FROM C_ValidCombination vc ").append("WHERE EXISTS (SELECT * FROM I_ElementValue i ").append("WHERE vc.Account_ID=i.C_ElementValue_ID)");
        sql = new StringBuilder("UPDATE I_ElementValue ").append("SET Processing='N', Processed='Y'").append("WHERE I_IsImported='Y'").append((CharSequence)clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Processed=" + no);
        }
        return "";
    }

    private void updateDefaults(String clientCheck) {
        StringBuilder sql;
        block7: {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("CreateNewCombination=" + this.m_createNewCombination);
            }
            sql = new StringBuilder("SELECT C_AcctSchema_ID FROM C_AcctSchema_Element ").append("WHERE C_Element_ID=?").append(clientCheck);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    pstmt.setInt(1, this.m_C_Element_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.updateDefaultAccounts(rs.getInt(1));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        sql = new StringBuilder("UPDATE C_AcctSchema_Element e ").append("SET C_ElementValue_ID=(SELECT C_ElementValue_ID FROM I_ElementValue i").append(" WHERE e.C_Element_ID=i.C_Element_ID AND i.C_ElementValue_ID IS NOT NULL").append(" AND UPPER(i.Default_Account)='DEFAULT_ACCT') ").append("WHERE EXISTS (SELECT * FROM I_ElementValue i").append(" WHERE e.C_Element_ID=i.C_Element_ID AND i.C_ElementValue_ID IS NOT NULL").append(" AND UPPER(i.Default_Account)='DEFAULT_ACCT' ").append("\tAND i.I_IsImported='Y' AND i.Processing='-')").append(clientCheck);
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@C_AcctSchema_Element_ID@: @Updated@");
    }

    private void updateDefaultAccounts(int C_AcctSchema_ID) {
        int[] counts;
        MAcctSchema as;
        block8: {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("C_AcctSchema_ID=" + C_AcctSchema_ID);
            }
            if ((as = new MAcctSchema(this.getCtx(), C_AcctSchema_ID, this.get_TrxName())).getAcctSchemaElement("AC").getC_Element_ID() != this.m_C_Element_ID) {
                StringBuilder msglog = new StringBuilder("C_Element_ID=").append(this.m_C_Element_ID).append(" not in AcctSchema=").append(as);
                this.log.log(Level.SEVERE, msglog.toString());
                return;
            }
            counts = new int[3];
            StringBuilder sql = new StringBuilder("SELECT i.C_ElementValue_ID, t.TableName, c.ColumnName, i.I_ElementValue_ID ").append("FROM I_ElementValue i").append(" INNER JOIN AD_Column c ON (i.AD_Column_ID=c.AD_Column_ID)").append(" INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) ").append("WHERE i.I_IsImported='Y' AND i.Processing='Y'").append(" AND i.C_ElementValue_ID IS NOT NULL AND C_Element_ID=?");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    pstmt.setInt(1, this.m_C_Element_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int no;
                        int u;
                        int C_ElementValue_ID = rs.getInt(1);
                        String TableName = rs.getString(2);
                        String ColumnName = rs.getString(3);
                        int I_ElementValue_ID = rs.getInt(4);
                        int n = u = this.updateDefaultAccount(TableName, ColumnName, C_AcctSchema_ID, C_ElementValue_ID);
                        counts[n] = counts[n] + 1;
                        if (u == 0 || (no = DB.executeUpdate((String)(sql = new StringBuilder("UPDATE I_ElementValue SET Processing='N' ").append("WHERE I_ElementValue_ID=").append(I_ElementValue_ID)).toString(), (String)this.get_TrxName())) == 1) continue;
                        this.log.log(Level.SEVERE, "Updated=" + no);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, "", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.addLog(0, null, new BigDecimal(counts[0]), as.toString() + ": @Errors@");
        this.addLog(0, null, new BigDecimal(counts[1]), as.toString() + ": @Updated@");
        this.addLog(0, null, new BigDecimal(counts[2]), as.toString() + ": OK");
    }

    private int updateDefaultAccount(String TableName, String ColumnName, int C_AcctSchema_ID, int C_ElementValue_ID) {
        int retValue;
        block23: {
            StringBuilder msglog = new StringBuilder(TableName).append(".").append(ColumnName).append(" - ").append(C_ElementValue_ID);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(msglog.toString());
            }
            retValue = 0;
            StringBuilder sql = new StringBuilder("SELECT x.").append(ColumnName).append(",Account_ID FROM ").append(TableName).append(" x INNER JOIN C_ValidCombination vc ON (x.").append(ColumnName).append("=vc.C_ValidCombination_ID) ").append("WHERE x.C_AcctSchema_ID=").append(C_AcctSchema_ID);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        int C_ValidCombination_ID = rs.getInt(1);
                        int Account_ID = rs.getInt(2);
                        if (Account_ID == C_ElementValue_ID) {
                            retValue = 2;
                            this.log.fine("Account_ID same as new value");
                        } else if (this.m_createNewCombination) {
                            MAccount acct = new MAccount(Env.getCtx(), C_ValidCombination_ID, null);
                            acct.setAccount_ID(C_ElementValue_ID);
                            if (acct.save()) {
                                retValue = 1;
                                int newC_ValidCombination_ID = acct.getC_ValidCombination_ID();
                                if (C_ValidCombination_ID != newC_ValidCombination_ID) {
                                    sql = new StringBuilder("UPDATE ").append(TableName).append(" SET ").append(ColumnName).append("=").append(newC_ValidCombination_ID).append(" WHERE C_AcctSchema_ID=").append(C_AcctSchema_ID);
                                    int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                                    msglog = new StringBuilder("New #").append(no).append(" - ").append(TableName).append(".").append(ColumnName).append(" - ").append(C_ElementValue_ID).append(" -- ").append(C_ValidCombination_ID).append(" -> ").append(newC_ValidCombination_ID);
                                    if (this.log.isLoggable(Level.FINE)) {
                                        this.log.fine(msglog.toString());
                                    }
                                    if (no == 1) {
                                        retValue = 1;
                                    }
                                }
                            } else {
                                this.log.log(Level.SEVERE, "Account not saved - " + String.valueOf(acct));
                            }
                        } else {
                            sql = new StringBuilder("UPDATE C_ValidCombination SET Account_ID=").append(C_ElementValue_ID).append(" WHERE C_ValidCombination_ID=").append(C_ValidCombination_ID);
                            int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                            msglog = new StringBuilder("Replace #").append(no).append(" - ").append("C_ValidCombination_ID=").append(C_ValidCombination_ID).append(", New Account_ID=").append(C_ElementValue_ID);
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(msglog.toString());
                            }
                            if (no == 1) {
                                retValue = 1;
                                sql = new StringBuilder("UPDATE C_ValidCombination SET Account_ID=").append(C_ElementValue_ID).append(" WHERE Account_ID=").append(Account_ID);
                                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                                msglog = new StringBuilder("ImportAccount.updateDefaultAccount - Replace VC #").append(no).append(" - ").append("Account_ID=").append(Account_ID).append(", New Account_ID=").append(C_ElementValue_ID);
                                if (this.log.isLoggable(Level.FINE)) {
                                    this.log.fine(msglog.toString());
                                }
                                sql = new StringBuilder("UPDATE Fact_Acct SET Account_ID=").append(C_ElementValue_ID).append(" WHERE Account_ID=").append(Account_ID);
                                no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
                                msglog = new StringBuilder("ImportAccount.updateDefaultAccount - Replace Fact #").append(no).append(" - ").append("Account_ID=").append(Account_ID).append(", New Account_ID=").append(C_ElementValue_ID);
                                if (this.log.isLoggable(Level.FINE)) {
                                    this.log.fine(msglog.toString());
                                }
                            }
                        }
                    } else {
                        int columnID = MColumn.getColumn_ID((String)TableName, (String)ColumnName);
                        if (new MColumn(this.getCtx(), columnID, this.get_TrxName()).isActive()) {
                            this.log.log(Level.SEVERE, "Account not found " + String.valueOf(sql));
                        } else {
                            this.log.log(Level.WARNING, "The account " + ColumnName + " is deprecated, you should consider removing it from your import file");
                        }
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block23;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }
}

