/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.window.WImageDialog;
import org.compiere.model.GridField;
import org.compiere.model.MImage;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Html;

public class WImageEditor
extends WEditor {
    private static final String[] LISTENER_EVENTS = new String[]{"onClick"};
    private MImage m_mImage = null;
    private boolean m_mandatory;
    private boolean readwrite;
    private static final CLogger log = CLogger.getCLogger(WImageEditor.class);

    public WImageEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WImageEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new org.zkoss.zul.Image(){
            private static final long serialVersionUID = 8492629361709791256L;

            public void onPageAttached(Page newpage, Page oldpage) {
                Component p2;
                super.onPageAttached(newpage, oldpage);
                if (newpage != null && this.getParent() != null && (p2 = this.getParent()) instanceof Cell) {
                    Cell cell = (Cell)p2;
                    LayoutUtils.addSclass("image-field-cell", (HtmlBasedComponent)cell);
                }
            }
        }, gridField, tableEditor, editorConfiguration);
        this.init();
    }

    public org.zkoss.zul.Image getComponent() {
        return (org.zkoss.zul.Image)this.component;
    }

    private void init() {
        Image img = null;
        this.getComponent().setContent(img);
        this.getComponent().setSclass("image-field");
    }

    @Override
    public String getDisplay() {
        return this.m_mImage.getName();
    }

    @Override
    public Object getValue() {
        if (this.m_mImage == null || this.m_mImage.get_ID() == 0) {
            return null;
        }
        return this.m_mImage.get_ID();
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    @Override
    public boolean isReadWrite() {
        return this.readwrite;
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.readwrite = readWrite;
        if (this.readwrite) {
            LayoutUtils.removeSclass("image-field-readonly", (HtmlBasedComponent)this.getComponent());
        } else {
            LayoutUtils.addSclass("image-field-readonly", (HtmlBasedComponent)this.getComponent());
        }
    }

    @Override
    public void setValue(Object value) {
        int newValue = 0;
        if (value instanceof Integer) {
            newValue = (Integer)value;
        }
        if (newValue == 0) {
            this.m_mImage = null;
            Image img = null;
            this.getComponent().setContent(img);
            ZkCssHelper.removeStyle((HtmlBasedComponent)this.getComponent(), "width");
            ZkCssHelper.removeStyle((HtmlBasedComponent)this.getComponent(), "height");
            LayoutUtils.removeSclass("thumbnail", (HtmlBasedComponent)this.getComponent());
            LayoutUtils.removeSclass("image-fit", (HtmlBasedComponent)this.getComponent());
            this.getComponent().setClientAttribute("onmouseenter", null);
            this.getComponent().setClientAttribute("onmouseleave", null);
            this.getComponent().invalidate();
            return;
        }
        if (this.m_mImage == null || newValue != this.m_mImage.get_ID()) {
            this.m_mImage = MImage.getCopy((Properties)Env.getCtx(), (int)newValue, null);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.m_mImage.toString());
        }
        AImage img = null;
        byte[] data = this.m_mImage.getData();
        if (data != null && data.length > 0) {
            try {
                img = new AImage(null, data);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.getComponent().setContent(img);
        if (img != null) {
            String width = MSysConfig.getIntValue((String)"ZK_THUMBNAIL_IMAGE_WIDTH", (int)100, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) + "px";
            String height = MSysConfig.getIntValue((String)"ZK_THUMBNAIL_IMAGE_HEIGHT", (int)100, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) + "px";
            String style = "width:" + width + ";height:" + height;
            ZkCssHelper.appendStyle((HtmlBasedComponent)this.getComponent(), style);
            LayoutUtils.addSclass("thumbnail", (HtmlBasedComponent)this.getComponent());
            LayoutUtils.addSclass("image-fit", (HtmlBasedComponent)this.getComponent());
            this.getComponent().setClientAttribute("onmouseenter", "idempiere.showFullSizeImage(event)");
            this.getComponent().setClientAttribute("onmouseleave", "idempiere.hideFullSizeImage(event)");
            this.getComponent().invalidate();
        } else {
            ZkCssHelper.removeStyle((HtmlBasedComponent)this.getComponent(), "width");
            ZkCssHelper.removeStyle((HtmlBasedComponent)this.getComponent(), "height");
            LayoutUtils.removeSclass("thumbnail", (HtmlBasedComponent)this.getComponent());
            LayoutUtils.removeSclass("image-fit", (HtmlBasedComponent)this.getComponent());
            this.getComponent().setClientAttribute("onmouseenter", null);
            this.getComponent().setClientAttribute("onmouseleave", null);
            this.getComponent().invalidate();
        }
    }

    @Override
    public String getDisplayTextForGridView(Object value) {
        if (value == null || value instanceof Integer && (Integer)value == 0) {
            return "<span class='no-image'/>";
        }
        return "...";
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    public void onEvent(Event event) throws Exception {
        String script = "jq('#" + this.getComponent().getUuid() + "').trigger('mouseleave');";
        Clients.evalJavaScript((String)script);
        if ("onClick".equals(event.getName()) && this.readwrite) {
            final WImageDialog vid = new WImageDialog(this.m_mImage);
            vid.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    if (!vid.isCancel()) {
                        int AD_Image_ID = vid.getAD_Image_ID();
                        Object oldValue = WImageEditor.this.getValue();
                        Integer newValue = null;
                        if (AD_Image_ID != 0) {
                            newValue = AD_Image_ID;
                        }
                        WImageEditor.this.m_mImage = null;
                        CacheMgt.get().reset("AD_Image", AD_Image_ID);
                        WImageEditor.this.setValue(newValue);
                        ValueChangeEvent vce = new ValueChangeEvent(WImageEditor.this, WImageEditor.this.gridField.getColumnName(), oldValue, newValue);
                        WImageEditor.this.fireValueChange(vce);
                        if (oldValue == null && newValue != null && WImageEditor.this.getGridField() != null && WImageEditor.this.getGridField().getGridTab() != null) {
                            WImageEditor.this.getGridField().getGridTab().dataSave(false);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void fillHorizontal() {
    }

    @Override
    public Component getDisplayComponent() {
        if (this.m_mImage == null) {
            return new Html();
        }
        return null;
    }
}

