/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MInOut;
import org.compiere.model.MPackage;
import org.compiere.model.MProcessPara;
import org.compiere.model.MShipper;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

@Process
public class PackageCreate
extends SvrProcess {
    private int p_M_Shipper_ID = 0;
    private int p_M_InOut_ID = 0;
    private int p_no_of_packages = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Shipper_ID")) {
                    this.p_M_Shipper_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_InOut_ID")) {
                    this.p_M_InOut_ID = para[i].getParameterAsInt();
                } else if (name.equals("NoOfPackages")) {
                    this.p_no_of_packages = para[i].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - M_InOut_ID=" + this.p_M_InOut_ID + ", M_Shipper_ID=" + this.p_M_Shipper_ID);
        }
        if (this.p_M_InOut_ID == 0) {
            throw new IllegalArgumentException("No Shipment");
        }
        if (this.p_M_Shipper_ID == 0) {
            throw new IllegalArgumentException("No Shipper");
        }
        MInOut shipment = new MInOut(this.getCtx(), this.p_M_InOut_ID, null);
        if (shipment.get_ID() != this.p_M_InOut_ID) {
            throw new IllegalArgumentException("Cannot find Shipment ID=" + this.p_M_InOut_ID);
        }
        MShipper shipper = new MShipper(this.getCtx(), this.p_M_Shipper_ID, this.get_TrxName());
        if (shipper.get_ID() != this.p_M_Shipper_ID) {
            throw new IllegalArgumentException("Cannot find Shipper ID=" + this.p_M_InOut_ID);
        }
        if (this.p_no_of_packages == 0) {
            this.p_no_of_packages = shipment.getNoPackages();
        }
        if (this.p_no_of_packages <= 0) {
            throw new IllegalArgumentException("No of Packages should not be 0");
        }
        StringBuilder info = new StringBuilder();
        if (this.p_no_of_packages == 1) {
            MPackage pack = MPackage.create((MInOut)shipment, (MShipper)shipper, null);
            info.append(pack.getDocumentNo());
        } else {
            int i = 0;
            while (i < this.p_no_of_packages) {
                MPackage pack = MPackage.createPackage((MInOut)shipment, (MShipper)shipper, null);
                if (i != 0) {
                    info.append(", ");
                }
                info.append(pack.getDocumentNo());
                ++i;
            }
        }
        return info.toString();
    }
}

