/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.adempiere.base.IColumnCallout;
import org.adempiere.base.IColumnCalloutFactory;
import org.adempiere.base.IMappedColumnCalloutFactory;
import org.adempiere.base.annotation.Callout;
import org.adempiere.base.annotation.Callouts;
import org.compiere.util.CLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Component;

@Component(name="org.adempiere.base.MappedColumnCalloutFactory", immediate=true, service={IColumnCalloutFactory.class, IMappedColumnCalloutFactory.class}, property={"service.ranking:Integer=1"})
public class MappedColumnCalloutFactory
implements IColumnCalloutFactory,
IMappedColumnCalloutFactory {
    private static final CLogger s_log = CLogger.getCLogger(MappedColumnCalloutFactory.class);
    private final HashMap<String, List<Supplier<IColumnCallout>>> calloutMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IColumnCallout[] getColumnCallouts(String tableName, String columnName) {
        ArrayList calloutList = new ArrayList();
        StringBuilder key = new StringBuilder();
        key.append(tableName.toLowerCase()).append("|").append(columnName.toLowerCase());
        StringBuilder key1 = new StringBuilder();
        key1.append("*|").append(columnName.toLowerCase());
        StringBuilder key2 = new StringBuilder();
        key2.append(tableName.toLowerCase()).append("|*");
        HashMap<String, List<Supplier<IColumnCallout>>> hashMap = this.calloutMap;
        synchronized (hashMap) {
            List<Supplier<IColumnCallout>> list = this.calloutMap.get(key.toString());
            if (list != null && list.size() > 0) {
                list.forEach(e -> {
                    boolean bl = calloutList.add((IColumnCallout)e.get());
                });
            }
            if ((list = this.calloutMap.get(key1.toString())) != null && list.size() > 0) {
                list.forEach(e -> {
                    boolean bl = calloutList.add((IColumnCallout)e.get());
                });
            }
            if ((list = this.calloutMap.get(key2.toString())) != null && list.size() > 0) {
                list.forEach(e -> {
                    boolean bl = calloutList.add((IColumnCallout)e.get());
                });
            }
        }
        return calloutList.isEmpty() ? null : calloutList.toArray(new IColumnCallout[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMapping(String tableName, String columnName, Supplier<IColumnCallout> supplier) {
        StringBuilder key = new StringBuilder();
        key.append(tableName.toLowerCase()).append("|").append(columnName.toLowerCase());
        HashMap<String, List<Supplier<IColumnCallout>>> hashMap = this.calloutMap;
        synchronized (hashMap) {
            List<Supplier<IColumnCallout>> list = this.calloutMap.get(key.toString());
            if (list == null) {
                list = new ArrayList<Supplier<IColumnCallout>>();
                this.calloutMap.put(key.toString(), list);
            }
            list.add(supplier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMapping(String tableName, String columnName, Supplier<IColumnCallout> supplier) {
        StringBuilder key = new StringBuilder();
        key.append(tableName.toLowerCase()).append("|").append(columnName.toLowerCase());
        HashMap<String, List<Supplier<IColumnCallout>>> hashMap = this.calloutMap;
        synchronized (hashMap) {
            List<Supplier<IColumnCallout>> list = this.calloutMap.get(key.toString());
            if (list != null) {
                list.remove(supplier);
            }
        }
    }

    @Override
    public void scan(BundleContext context, String ... packages) {
        ClassLoader classLoader = ((BundleWiring)context.getBundle().adapt(BundleWiring.class)).getClassLoader();
        ClassGraph graph = new ClassGraph().enableAnnotationInfo().overrideClassLoaders(new ClassLoader[]{classLoader}).disableNestedJarScanning().disableModuleScanning().acceptPackagesNonRecursive(packages);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ScanResult scanResult = graph.scan();){
            String className;
            ArrayList<String> processed = new ArrayList<String>();
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(Callouts.class)) {
                if (classInfo.isAbstract()) continue;
                className = classInfo.getName();
                AnnotationInfoList annotationInfos = classInfo.getAnnotationInfoRepeatable(Callout.class);
                for (AnnotationInfo annotationInfo : annotationInfos) {
                    this.processAnnotation(className, annotationInfo, classLoader);
                }
                processed.add(className);
            }
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(Callout.class)) {
                if (classInfo.isAbstract() || processed.contains(className = classInfo.getName())) continue;
                AnnotationInfo annotationInfo = classInfo.getAnnotationInfo(Callout.class);
                this.processAnnotation(className, annotationInfo, classLoader);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void processAnnotation(String className, AnnotationInfo annotationInfo, ClassLoader classLoader) {
        block14: {
            Object[] tableNames = (Object[])annotationInfo.getParameterValues().getValue("tableName");
            Object[] columnNames = (Object[])annotationInfo.getParameterValues().getValue("columnName");
            boolean matchAllTables = false;
            Object[] objectArray = tableNames;
            int n = tableNames.length;
            int n2 = 0;
            while (n2 < n) {
                Object tableName = objectArray[n2];
                if ("*".equals(tableName)) {
                    matchAllTables = true;
                    break;
                }
                ++n2;
            }
            boolean matchAllColumns = false;
            Object[] objectArray2 = columnNames;
            int n3 = columnNames.length;
            n = 0;
            while (n < n3) {
                Object columnName = objectArray2[n];
                if ("*".equals(columnName)) {
                    matchAllColumns = true;
                    break;
                }
                ++n;
            }
            if (matchAllColumns && matchAllTables) {
                return;
            }
            try {
                Class<?> clazz = classLoader.loadClass(className);
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                CalloutSupplier supplier = new CalloutSupplier(constructor);
                if (matchAllTables) {
                    Object[] objectArray3 = columnNames;
                    int n4 = columnNames.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Object columnName = objectArray3[n5];
                        this.addMapping("*", (String)columnName, supplier);
                        ++n5;
                    }
                } else {
                    Object[] objectArray4 = tableNames;
                    int n6 = tableNames.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        Object tableName = objectArray4[n7];
                        if (matchAllColumns) {
                            this.addMapping((String)tableName, "*", supplier);
                        } else {
                            Object[] objectArray5 = columnNames;
                            int n8 = columnNames.length;
                            int n9 = 0;
                            while (n9 < n8) {
                                Object columnName = objectArray5[n9];
                                this.addMapping((String)tableName, (String)columnName, supplier);
                                ++n9;
                            }
                        }
                        ++n7;
                    }
                }
            }
            catch (Exception e) {
                if (!s_log.isLoggable(Level.INFO)) break block14;
                s_log.log(Level.INFO, e.getMessage(), e);
            }
        }
    }

    private static class CalloutSupplier
    implements Supplier<IColumnCallout> {
        private Constructor<?> constructor;

        private CalloutSupplier(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public IColumnCallout get() {
            IColumnCallout callout = null;
            if (this.constructor != null) {
                try {
                    callout = (IColumnCallout)this.constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    this.constructor = null;
                    s_log.log(Level.WARNING, e.getMessage(), e);
                }
            }
            return callout;
        }
    }
}

