/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.adwindow;

import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.base.Core;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MBPartner;
import org.compiere.model.MField;
import org.compiere.model.MLookup;
import org.compiere.model.MOrg;
import org.compiere.model.MQuery;
import org.compiere.model.MWarehouse;
import org.compiere.util.CLogger;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GridTabTest
extends AbstractTestCase {
    private static final int FIELD_ORDERLINE_SHIPPER = 1135;

    @Test
    public void testQuery() {
        int AD_Window_ID = 123;
        GridWindowVO gWindowVO = GridWindowVO.create((Properties)Env.getCtx(), (int)1, (int)AD_Window_ID);
        GridWindow gridWindow = new GridWindow(gWindowVO, true);
        int tabCount = gridWindow.getTabCount();
        Assertions.assertTrue((tabCount > 0 ? 1 : 0) != 0, (String)("Tab Count is Zero. AD_Window_ID=" + AD_Window_ID));
        MQuery query = new MQuery("C_BPartner");
        query.addRestriction("C_BPartner_ID", "=", DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        int i = 0;
        while (i < gridWindow.getTabCount()) {
            gridWindow.initTab(i);
            GridTab gTab = gridWindow.getTab(i);
            if (i == 0) {
                gTab.setUpdateWindowContext(true);
                gTab.setQuery(query);
                gTab.query(false, 0, 0);
            } else {
                gTab.setUpdateWindowContext(false);
            }
            ++i;
        }
        GridTab gTab = gridWindow.getTab(0);
        Assertions.assertTrue((gTab.getRowCount() == 1 ? 1 : 0) != 0, (String)("GridTab Row Count is not 1. GridTab=" + gTab.getName()));
        String name = (String)gTab.getValue("Name");
        MBPartner bpartner = new MBPartner(Env.getCtx(), DictionaryIDs.C_BPartner.JOE_BLOCK.id, this.getTrxName());
        Assertions.assertTrue((boolean)bpartner.getName().equals(name), (String)("GridTab Name != MBPartner.getName(). GridTab.Name=" + name + " MBPartner.getName=" + bpartner.getName()));
    }

    @Test
    public void testCallout() {
        int AD_Window_ID = 143;
        GridWindowVO gWindowVO = GridWindowVO.create((Properties)Env.getCtx(), (int)1, (int)AD_Window_ID);
        GridWindow gridWindow = new GridWindow(gWindowVO, true);
        int tabCount = gridWindow.getTabCount();
        Assertions.assertTrue((tabCount > 0 ? 1 : 0) != 0, (String)("Tab Count is Zero. AD_Window_ID=" + AD_Window_ID));
        int i = 0;
        while (i < gridWindow.getTabCount()) {
            gridWindow.initTab(i);
            GridTab gTab = gridWindow.getTab(i);
            if (i == 0) {
                gTab.setUpdateWindowContext(true);
                gTab.setQuery(null);
                gTab.query(false, 7, 0);
            } else {
                gTab.setUpdateWindowContext(false);
            }
            ++i;
        }
        GridTab gTab = gridWindow.getTab(0);
        gTab.dataNew(false);
        Assertions.assertTrue((boolean)gTab.isNew(), (String)"Grid Tab dataNew call not working as expected");
        Assertions.assertNull((Object)gTab.getValue("Bill_BPartner_ID"), (String)"Bill_BPartner_ID not null");
        gTab.setValue("C_BPartner_ID", (Object)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        Object value = gTab.getValue("C_BPartner_ID");
        Assertions.assertNotNull((Object)value, (String)"C_BPartner_ID is null");
        Assertions.assertEquals((int)DictionaryIDs.C_BPartner.JOE_BLOCK.id, (int)((Number)value).intValue(), (String)("C_BPartner_ID not equals to " + DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        GridField mField = gTab.getField("C_BPartner_ID");
        gTab.processFieldChange(mField);
        value = gTab.getValue("Bill_BPartner_ID");
        Assertions.assertNotNull((Object)value, (String)"Bill_BPartner_ID is null");
        Assertions.assertEquals((int)DictionaryIDs.C_BPartner.JOE_BLOCK.id, (int)((Number)value).intValue(), (String)("Bill_BPartner_ID not equals to " + DictionaryIDs.C_BPartner.JOE_BLOCK.id));
    }

    @Test
    public void testUpdate() {
        int AD_Window_ID = 123;
        GridWindowVO gWindowVO = GridWindowVO.create((Properties)Env.getCtx(), (int)1, (int)AD_Window_ID);
        GridWindow gridWindow = new GridWindow(gWindowVO, true);
        int tabCount = gridWindow.getTabCount();
        Assertions.assertTrue((tabCount > 0 ? 1 : 0) != 0, (String)("Tab Count is Zero. AD_Window_ID=" + AD_Window_ID));
        MQuery query = new MQuery("C_BPartner");
        query.addRestriction("C_BPartner_ID", "=", DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        int i = 0;
        while (i < gridWindow.getTabCount()) {
            gridWindow.initTab(i);
            GridTab gTab = gridWindow.getTab(i);
            if (i == 0) {
                gTab.setUpdateWindowContext(true);
                gTab.setQuery(query);
                gTab.query(false, 0, 0);
            } else {
                gTab.setUpdateWindowContext(false);
            }
            ++i;
        }
        GridTab gTab = gridWindow.getTab(0);
        Assertions.assertTrue((gTab.getRowCount() == 1 ? 1 : 0) != 0, (String)("GridTab Row Count is not 1. GridTab=" + gTab.getName()));
        String name = (String)gTab.getValue("Name");
        MBPartner bpartner = new MBPartner(Env.getCtx(), DictionaryIDs.C_BPartner.JOE_BLOCK.id, this.getTrxName());
        Assertions.assertTrue((boolean)bpartner.getName().equals(name), (String)("GridTab Name != MBPartner.getName(). GridTab.Name=" + name + " MBPartner.getName=" + bpartner.getName()));
        gTab.getTableModel().setImportingMode(true, this.getTrxName());
        String updateValue = "testUpdate";
        gTab.setValue("Description", (Object)updateValue);
        gTab.dataSave(true);
        bpartner.load(this.getTrxName(), new String[0]);
        String description = (String)gTab.getValue("Description");
        Assertions.assertTrue((boolean)updateValue.equals(description), (String)("GridTab Description != Update Value. GridTab.Description=" + description));
        Assertions.assertTrue((boolean)bpartner.getDescription().equals(description), (String)("GridTab Description != MBPartner.getDescription(). GridTab.Description=" + description + " MBPartner.getDescription=" + bpartner.getDescription()));
    }

    @Test
    public void testInsert() {
        String prefKey;
        Properties ctx = Env.getCtx();
        String pref = Env.getContext((Properties)ctx, (String)(prefKey = "P143|C_DocTypeTarget_ID"));
        if (pref.length() == 0) {
            int orgId = Env.getAD_Org_ID((Properties)ctx);
            MOrg org = MOrg.get((int)orgId);
            KeyNamePair knpo = new KeyNamePair(orgId, org.getName());
            KeyNamePair knpw = null;
            int whId = Env.getContextAsInt((Properties)ctx, (String)"#M_Warehouse_ID");
            if (whId > 0) {
                MWarehouse wh = MWarehouse.get((int)whId);
                knpw = new KeyNamePair(whId, wh.getName());
            }
            Timestamp loginDate = Env.getContextAsDate((Properties)ctx, (String)"#Date");
            Login login = new Login(ctx);
            login.loadPreferences(knpo, knpw, loginDate, null);
        }
        MField field = MField.get((int)1135);
        boolean displayOri = field.isDisplayed();
        boolean displayGridOri = field.isDisplayed();
        try {
            DB.executeUpdateEx((String)"UPDATE AD_Field SET IsDisplayed='N', IsDisplayedGrid='N' WHERE AD_Field_ID=?", (Object[])new Object[]{1135}, null);
            CacheMgt.get().reset();
            int AD_Window_ID = 143;
            GridWindowVO gWindowVO = GridWindowVO.create((Properties)ctx, (int)1, (int)AD_Window_ID);
            final GridWindow gridWindow = new GridWindow(gWindowVO, true);
            int tabCount = gridWindow.getTabCount();
            Assertions.assertTrue((tabCount > 0 ? 1 : 0) != 0, (String)("Tab Count is Zero. AD_Window_ID=" + AD_Window_ID));
            int i = 0;
            while (i < gridWindow.getTabCount()) {
                gridWindow.initTab(i);
                GridTab gTab = gridWindow.getTab(i);
                if (i == 0) {
                    gTab.setQuery(null);
                    gTab.query(false, 7, 0);
                }
                gTab.addDataStatusListener(new DataStatusListener(){

                    public void dataStatusChanged(DataStatusEvent e) {
                        GridTable gt;
                        int col = e.getChangedColumn();
                        if (col < 0) {
                            return;
                        }
                        GridTab gridTab = null;
                        if (e.getSource() != null && e.getSource() instanceof GridTable && (gridTab = gridWindow.getTab((gt = (GridTable)e.getSource()).getTabNo())).getAD_Table_ID() != e.AD_Table_ID) {
                            throw new RuntimeException("Table doesn't match with updated tab");
                        }
                        GridField mField = gridTab.getField(col);
                        if (mField != null && (mField.getCallout().length() > 0 || Core.findCallout((String)gridTab.getTableName(), (String)mField.getColumnName()).size() > 0 || gridTab.hasDependants(mField.getColumnName()))) {
                            gridTab.processFieldChange(mField);
                            for (GridField dependentField : gridTab.getDependantFields(mField.getColumnName())) {
                                MLookup mLookup;
                                if (dependentField == null || !(dependentField.getLookup() instanceof MLookup) || (mLookup = (MLookup)dependentField.getLookup()).getValidation().indexOf("@" + mField.getColumnName() + "@") == -1) continue;
                                mLookup.refresh();
                            }
                        }
                    }
                });
                ++i;
            }
            GridTab gTab0 = gridWindow.getTab(0);
            Assertions.assertTrue((boolean)gTab0.dataNew(false));
            Assertions.assertTrue((boolean)gTab0.isNew(), (String)"Grid Tab dataNew call not working as expected");
            gTab0.setValue("C_BPartner_ID", (Object)DictionaryIDs.C_BPartner.C_AND_W.id);
            Assertions.assertTrue((boolean)gTab0.dataSave(true), (String)CLogger.retrieveWarningString((String)"Could not save order"));
            GridTab gTab1 = gridWindow.getTab(1);
            if (!gTab1.getTableModel().isOpen()) {
                gTab1.getTableModel().open(0);
            }
            Assertions.assertTrue((boolean)gTab1.dataNew(false));
            gTab1.setValue("M_Product_ID", (Object)DictionaryIDs.M_Product.AZALEA_BUSH.id);
            Assertions.assertTrue((boolean)gTab1.dataSave(true));
            Assertions.assertTrue((boolean)gTab1.dataNew(false));
            gTab1.setValue("M_Product_ID", (Object)DictionaryIDs.M_Product.SEEDER.id);
            Assertions.assertTrue((boolean)gTab1.dataSave(true));
        }
        catch (Throwable throwable) {
            this.rollback();
            DB.executeUpdateEx((String)"UPDATE AD_Field SET IsDisplayed=?, IsDisplayedGrid=? WHERE AD_Field_ID=?", (Object[])new Object[]{displayOri, displayGridOri, 1135}, null);
            CacheMgt.get().reset();
            throw throwable;
        }
        this.rollback();
        DB.executeUpdateEx((String)"UPDATE AD_Field SET IsDisplayed=?, IsDisplayedGrid=? WHERE AD_Field_ID=?", (Object[])new Object[]{displayOri, displayGridOri, 1135}, null);
        CacheMgt.get().reset();
    }
}

