/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InventoryTest
extends AbstractTestCase {
    @Test
    public void testCreateAProductAndInventory() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MProduct product = new MProduct(ctx, 0, trxName);
        product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.BUSH.id);
        product.setName("Test 4596");
        product.setValue("T4596");
        product.setProductType("I");
        product.setIsStocked(true);
        product.setIsSold(true);
        product.setIsPurchased(true);
        product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
        product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
        product.saveEx();
        MInventory inventory = new MInventory(ctx, 0, trxName);
        inventory.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.HQ.id);
        inventory.setC_DocType_ID(DictionaryIDs.C_DocType.MATERIAL_PHYSICAL_INVENTORY.id);
        inventory.saveEx();
        MInventoryLine iline = new MInventoryLine(inventory, DictionaryIDs.M_Locator.HQ.id, product.getM_Product_ID(), 0, Env.ZERO, Env.ONEHUNDRED);
        iline.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        inventory.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)inventory.getDocStatus());
    }

    @Test
    public void testCostAdjustmentLineBeforeSave() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        MProduct product = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.MULCH.id, this.getTrxName());
        MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        if (cost == null || cost.getCurrentCostPrice().signum() == 0) {
            this.createPOAndMRForProduct(DictionaryIDs.M_Product.MULCH.id);
            cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        }
        Assertions.assertNotNull((Object)cost);
        MInventory inventory = new MInventory(Env.getCtx(), 0, this.getTrxName());
        inventory.setC_DocType_ID(DictionaryIDs.C_DocType.COST_ADJUSTMENT.id);
        inventory.setCostingMethod(as.getCostingMethod());
        inventory.saveEx();
        MInventoryLine line = new MInventoryLine(Env.getCtx(), 0, this.getTrxName());
        line.setM_Inventory_ID(inventory.get_ID());
        line.setM_Product_ID(DictionaryIDs.M_Product.MULCH.id);
        line.setNewCostPrice(cost.getCurrentCostPrice().add(new BigDecimal("0.5")));
        line.saveEx();
        Assertions.assertNotEquals((int)0, (int)line.getLine(), (String)"Unexpected Line No");
        Assertions.assertEquals((Object)cost.getCurrentCostPrice(), (Object)line.getCurrentCostPrice());
    }

    private void createPOAndMRForProduct(int productId) {
        this.createPOAndMRForProduct(productId, null);
    }

    private void createPOAndMRForProduct(int productId, MAttributeSetInstance asi) {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(new MProduct(Env.getCtx(), productId, this.getTrxName()));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt1.setDocStatus("DR");
        receipt1.setDocAction("CO");
        receipt1.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt1);
        receiptLine1.setOrderLine(line1, 0, new BigDecimal("1"));
        receiptLine1.setQty(new BigDecimal("1"));
        if (asi != null) {
            receiptLine1.setM_AttributeSetInstance_ID(asi.get_ID());
        }
        receiptLine1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
        if (!receipt1.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertNull((Object)error, (String)error);
        }
    }
}

