/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.form;

import org.compiere.apps.form.Archive;
import org.compiere.model.MArchive;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArchiveViewerFormTest
extends AbstractTestCase {
    @Test
    public void testQuery() {
        Archive archive = new Archive();
        archive.setTrxName(this.getTrxName());
        KeyNamePair[] processes = archive.getProcessData();
        Assertions.assertTrue((processes.length > 0 ? 1 : 0) != 0, (String)"Failed to retrieve process records");
        KeyNamePair[] tables = archive.getTableData();
        Assertions.assertTrue((tables.length > 0 ? 1 : 0) != 0, (String)"Failed to retrieve table records");
        KeyNamePair[] users = archive.getUserData();
        Assertions.assertTrue((users.length > 0 ? 1 : 0) != 0, (String)"Failed to retrieve user records");
        MArchive marchive = new MArchive(Env.getCtx(), 0, this.getTrxName());
        marchive.setAD_Table_ID(208);
        marchive.setIsReport(true);
        marchive.setName(this.getClass().getName());
        marchive.setRecord_ID(DictionaryIDs.M_Product.AZALEA_BUSH.id);
        marchive.setBinaryData("test".getBytes());
        marchive.saveEx();
        archive.cmd_query(true, null, new KeyNamePair(208, "M_Product"), null, null, null, null, null, null, null);
        MArchive[] archives = archive.getArchives();
        Assertions.assertTrue((archives != null && archives.length > 0 ? 1 : 0) != 0, (String)"Failed to retrieve archive records of M_Product table");
        boolean found = false;
        MArchive[] mArchiveArray = archives;
        int n = archives.length;
        int n2 = 0;
        while (n2 < n) {
            MArchive a = mArchiveArray[n2];
            if (a.get_ID() == marchive.get_ID()) {
                found = true;
                break;
            }
            ++n2;
        }
        Assertions.assertTrue((boolean)found, (String)"Failed to retrieve MArchive record created");
    }
}

