/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.DocManager;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCost;
import org.compiere.model.MCurrency;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.model.X_Fact_Acct;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.ConversionRateHelper;
import org.idempiere.test.DictionaryIDs;
import org.idempiere.test.FactAcct;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class MatchInvTestIsolated
extends AbstractTestCase {
    @Test
    public void testMatchInvStdCost() {
        MProductCategory category = new MProductCategory(Env.getCtx(), 0, null);
        category.setName("Standard Costing");
        category.saveEx();
        String whereClause = "M_Product_Category_ID=?";
        List categoryAccts = new Query(Env.getCtx(), "M_Product_Category_Acct", whereClause, null).setParameters(new Object[]{category.get_ID()}).list();
        for (MProductCategoryAcct categoryAcct : categoryAccts) {
            categoryAcct.setCostingMethod("S");
            categoryAcct.saveEx();
        }
        int mulchId = DictionaryIDs.M_Product.MULCH.id;
        MProduct mulch = new MProduct(Env.getCtx(), mulchId, null);
        int mulchCategoryId = mulch.getM_Product_Category_ID();
        try {
            MMatchInv[] miList;
            mulch.setM_Product_Category_ID(category.get_ID());
            mulch.saveEx();
            int purchaseId = DictionaryIDs.M_PriceList.PURCHASE.id;
            MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id);
            MAcctSchema as = MClient.get((int)this.getAD_Client_ID()).getAcctSchema();
            BigDecimal mulchCost = MCost.getCurrentCost((MProduct)mulch, (int)0, (String)this.getTrxName()).setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            int hqLocator = DictionaryIDs.M_Locator.HQ.id;
            int costAdjustmentDocTypeId = DictionaryIDs.C_DocType.COST_ADJUSTMENT.id;
            MInventory inventory = new MInventory(Env.getCtx(), 0, this.getTrxName());
            inventory.setCostingMethod("S");
            inventory.setC_DocType_ID(costAdjustmentDocTypeId);
            inventory.setM_Warehouse_ID(this.getM_Warehouse_ID());
            inventory.setMovementDate(this.getLoginDate());
            inventory.setDocAction("CO");
            inventory.saveEx();
            BigDecimal endProductCost = new BigDecimal("2.1234").setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            MInventoryLine il = new MInventoryLine(Env.getCtx(), 0, this.getTrxName());
            il.setM_Inventory_ID(inventory.get_ID());
            il.setM_Locator_ID(hqLocator);
            il.setM_Product_ID(mulch.getM_Product_ID());
            il.setCurrentCostPrice(mulchCost);
            il.setNewCostPrice(endProductCost);
            il.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
            inventory.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)inventory.getDocStatus(), (String)("Cost Adjustment Status=" + inventory.getDocStatus()));
            if (!inventory.isPosted()) {
                String msg = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)321, (int)inventory.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)msg, (String)msg);
            }
            mulchCost = MCost.getCurrentCost((MProduct)mulch, (int)0, (String)this.getTrxName()).setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            Assertions.assertEquals((Object)endProductCost, (Object)mulchCost, (String)("Cost not adjusted: " + mulchCost.toPlainString()));
            MAcctSchema[] schemas = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)this.getAD_Client_ID());
            int i = 0;
            while (i < schemas.length) {
                BigDecimal expected = MConversionRate.convert((Properties)Env.getCtx(), (BigDecimal)mulchCost, (int)as.getC_Currency_ID(), (int)schemas[i].getC_Currency_ID(), (Timestamp)inventory.getMovementDate(), (int)0, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID(), (boolean)true);
                BigDecimal mulchCostConv = MCost.getCurrentCost((MProduct)mulch, (int)0, (MAcctSchema)schemas[i], (int)schemas[i].getAD_Org_ID(), (String)"S", (BigDecimal)BigDecimal.ONE, (int)0, (boolean)true, (String)this.getTrxName()).setScale(schemas[i].getCostingPrecision(), RoundingMode.HALF_UP);
                Assertions.assertEquals((Object)expected, (Object)mulchCostConv, (String)("Converted Cost for schema incorrect: " + schemas[i].toString() + " - " + mulchCostConv.toPlainString()));
                ++i;
            }
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(bpartner);
            order.setIsSOTrx(false);
            order.setC_DocTypeTarget_ID();
            order.setM_PriceList_ID(purchaseId);
            order.setDocStatus("DR");
            order.setDocAction("CO");
            order.saveEx();
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(10);
            orderLine.setProduct(mulch);
            orderLine.setQty(BigDecimal.ONE);
            orderLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            MInOut receipt = new MInOut(order, 122, order.getDateOrdered());
            receipt.saveEx();
            MInOutLine receiptLine = new MInOutLine(receipt);
            receiptLine.setC_OrderLine_ID(orderLine.get_ID());
            receiptLine.setLine(10);
            receiptLine.setProduct(mulch);
            receiptLine.setQty(BigDecimal.ONE);
            MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
            int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            receiptLine.setM_Locator_ID(M_Locator_ID);
            receiptLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
            if (!receipt.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)receipt.isPosted());
            MInvoice invoice = new MInvoice(receipt, receipt.getMovementDate());
            invoice.setC_DocTypeTarget_ID("API");
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setM_InOutLine_ID(receiptLine.get_ID());
            invoiceLine.setLine(10);
            invoiceLine.setProduct(mulch);
            invoiceLine.setQty(BigDecimal.ONE);
            invoiceLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
            if (!invoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)invoice.isPosted());
            MMatchInv[] mMatchInvArray = miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
            int n = miList.length;
            int n2 = 0;
            while (n2 < n) {
                MMatchInv mi = mMatchInvArray[n2];
                if (!mi.isPosted()) {
                    String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)mi.getAD_Client_ID(), (int)472, (int)mi.get_ID(), (boolean)false, (String)this.getTrxName());
                    Assertions.assertTrue((error == null ? 1 : 0) != 0);
                }
                mi.load(this.getTrxName(), new String[0]);
                Assertions.assertTrue((boolean)mi.isPosted());
                Doc doc = DocManager.getDocument((MAcctSchema)as, (int)472, (int)mi.get_ID(), (String)this.getTrxName());
                doc.setC_BPartner_ID(mi.getC_InvoiceLine().getC_Invoice().getC_BPartner_ID());
                MAccount acctNIR = doc.getAccount(51, as);
                ProductCost pc = new ProductCost(Env.getCtx(), mi.getM_Product_ID(), mi.getM_AttributeSetInstance_ID(), this.getTrxName());
                MAccount acctInvClr = pc.getAccount(10, as);
                MAccount acctIPV = pc.getAccount(6, as);
                int C_AcctSchema_ID = as.getC_AcctSchema_ID();
                Query query = MFactAcct.createRecordIdQuery((int)472, (int)mi.get_ID(), (int)C_AcctSchema_ID, (String)this.getTrxName());
                List factAccts = query.list();
                BigDecimal invMatchAmt = invoiceLine.getMatchedQty().multiply(invoiceLine.getPriceActual()).setScale(as.getStdPrecision(), RoundingMode.HALF_UP);
                mulchCost = mulchCost.setScale(as.getStdPrecision(), RoundingMode.HALF_UP);
                List<FactAcct> expected = Arrays.asList(new FactAcct(acctNIR, mulchCost, 2, true), new FactAcct(acctInvClr, invMatchAmt, 2, false), new FactAcct(acctIPV, invMatchAmt.subtract(mulchCost), 2, true));
                this.assertFactAcctEntries(factAccts, expected);
                ++n2;
            }
        }
        finally {
            this.getTrx().rollback();
            mulch.setM_Product_Category_ID(mulchCategoryId);
            mulch.saveEx();
            category.deleteEx(true);
        }
    }

    @Test
    public void testAverageCostingIPV() {
        MProduct product = null;
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        try {
            MMatchInv[] miList;
            product = new MProduct(Env.getCtx(), 0, null);
            product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            product.setName("testAverageCostingIPV");
            product.setProductType("I");
            product.setIsStocked(true);
            product.setIsSold(true);
            product.setIsPurchased(true);
            product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(product.get_ID());
            BigDecimal orderPrice = new BigDecimal("2.00");
            pp.setPriceStd(orderPrice);
            pp.setPriceList(orderPrice);
            pp.saveEx();
            int purchaseId = DictionaryIDs.M_PriceList.PURCHASE.id;
            MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id);
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(bpartner);
            order.setIsSOTrx(false);
            order.setC_DocTypeTarget_ID();
            order.setM_PriceList_ID(purchaseId);
            order.setDocStatus("DR");
            order.setDocAction("CO");
            order.saveEx();
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(10);
            orderLine.setProduct(product);
            orderLine.setQty(BigDecimal.TEN);
            orderLine.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            MInOut receipt = new MInOut(order, 122, order.getDateOrdered());
            receipt.saveEx();
            MInOutLine receiptLine = new MInOutLine(receipt);
            receiptLine.setC_OrderLine_ID(orderLine.get_ID());
            receiptLine.setLine(10);
            receiptLine.setProduct(product);
            receiptLine.setQty(BigDecimal.TEN);
            MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
            int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            receiptLine.setM_Locator_ID(M_Locator_ID);
            receiptLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
            if (!receipt.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)receipt.isPosted());
            product.set_TrxName(this.getTrxName());
            MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)cost, (String)"No MCost record found");
            Assertions.assertEquals((Object)orderPrice, (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            MInvoice invoice = new MInvoice(receipt, receipt.getMovementDate());
            invoice.setC_DocTypeTarget_ID("API");
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setM_InOutLine_ID(receiptLine.get_ID());
            invoiceLine.setLine(10);
            invoiceLine.setProduct(product);
            invoiceLine.setQty(BigDecimal.TEN);
            BigDecimal invoicePrice = new BigDecimal("2.50");
            invoiceLine.setPrice(invoicePrice);
            invoiceLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
            if (!invoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)invoice.isPosted());
            MMatchInv[] mMatchInvArray = miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
            int n = miList.length;
            int n2 = 0;
            while (n2 < n) {
                MMatchInv mi = mMatchInvArray[n2];
                if (!mi.isPosted()) {
                    String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)mi.getAD_Client_ID(), (int)472, (int)mi.get_ID(), (boolean)false, (String)this.getTrxName());
                    Assertions.assertTrue((error == null ? 1 : 0) != 0);
                }
                mi.load(this.getTrxName(), new String[0]);
                Assertions.assertTrue((boolean)mi.isPosted());
                cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
                Assertions.assertNotNull((Object)cost, (String)"No MCost record found");
                Assertions.assertEquals((Object)invoicePrice, (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
                ProductCost pc = new ProductCost(Env.getCtx(), mi.getM_Product_ID(), mi.getM_AttributeSetInstance_ID(), this.getTrxName());
                MAccount acctInvClr = pc.getAccount(10, as);
                MAccount acctAsset = pc.getAccount(3, as);
                Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)invoice.get_ID(), (String)this.getTrxName());
                MAccount nirAccount = doc.getAccount(51, as);
                int C_AcctSchema_ID = as.getC_AcctSchema_ID();
                Query query = MFactAcct.createRecordIdQuery((int)472, (int)mi.get_ID(), (int)C_AcctSchema_ID, (String)this.getTrxName());
                List factAccts = query.list();
                BigDecimal ipvAmt = invoicePrice.subtract(orderPrice).multiply(BigDecimal.TEN);
                List<FactAcct> expected = Arrays.asList(new FactAcct(acctAsset, ipvAmt, 2, true), new FactAcct(nirAccount, orderPrice.multiply(BigDecimal.TEN), 2, true), new FactAcct(acctInvClr, invoicePrice.multiply(BigDecimal.TEN), 2, false));
                this.assertFactAcctEntries(factAccts, expected);
                ++n2;
            }
        }
        finally {
            this.rollback();
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testAverageCostingIPVAfterShipment() {
        MProduct product = null;
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        ArrayList allowNegatives = new ArrayList();
        Arrays.stream(ass).forEach(e -> {
            MAcctSchema copy = MAcctSchema.getCopy((Properties)Env.getCtx(), (int)e.getC_AcctSchema_ID(), null);
            if (copy.isAllowNegativePosting()) {
                copy.setIsAllowNegativePosting(false);
                copy.saveEx();
                allowNegatives.add(copy);
            }
        });
        if (allowNegatives.size() > 0) {
            CacheMgt.get().reset("C_AcctSchema");
        }
        ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.SPOT.id;
        Timestamp today = TimeUtil.getDay(null);
        Timestamp tomorrow = TimeUtil.addDays((Timestamp)today, (int)1);
        MConversionRate cr1 = ConversionRateHelper.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, today, new BigDecimal("0.91"), true);
        MConversionRate cr2 = ConversionRateHelper.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, tomorrow, new BigDecimal("0.85"), true);
        try {
            MMatchInv[] pc;
            MMatchInv[] miList;
            product = new MProduct(Env.getCtx(), 0, null);
            product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            product.setName("testAverageCostingIPVAfterShipment");
            product.setProductType("I");
            product.setIsStocked(true);
            product.setIsSold(true);
            product.setIsPurchased(true);
            product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(product.get_ID());
            BigDecimal orderPrice = new BigDecimal("2.00");
            pp.setPriceStd(orderPrice);
            pp.setPriceList(orderPrice);
            pp.saveEx();
            int purchaseId = DictionaryIDs.M_PriceList.PURCHASE.id;
            MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id);
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(bpartner);
            order.setIsSOTrx(false);
            order.setC_DocTypeTarget_ID();
            order.setM_PriceList_ID(purchaseId);
            order.setDocStatus("DR");
            order.setDocAction("CO");
            order.saveEx();
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(10);
            orderLine.setProduct(product);
            orderLine.setQty(BigDecimal.TEN);
            orderLine.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            MInOut receipt = new MInOut(order, 122, order.getDateOrdered());
            receipt.saveEx();
            MInOutLine receiptLine = new MInOutLine(receipt);
            receiptLine.setC_OrderLine_ID(orderLine.get_ID());
            receiptLine.setLine(10);
            receiptLine.setProduct(product);
            receiptLine.setQty(BigDecimal.TEN);
            MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
            int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            receiptLine.setM_Locator_ID(M_Locator_ID);
            receiptLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
            if (!receipt.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)receipt.isPosted());
            product.set_TrxName(this.getTrxName());
            MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)cost, (String)"No MCost record found");
            Assertions.assertEquals((Object)orderPrice, (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            MOrder salesOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            salesOrder.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
            salesOrder.setC_DocTypeTarget_ID("SO");
            salesOrder.setDeliveryRule("O");
            salesOrder.setDocStatus("DR");
            salesOrder.setDocAction("CO");
            salesOrder.setDatePromised(today);
            salesOrder.saveEx();
            BigDecimal salesQty = new BigDecimal("5");
            MOrderLine salesLine1 = new MOrderLine(salesOrder);
            salesLine1.setLine(10);
            salesLine1.setProduct(product);
            salesLine1.setQty(salesQty);
            salesLine1.setDatePromised(today);
            salesLine1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)salesOrder, (String)"CO");
            salesOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)salesOrder.getDocStatus(), (String)"Unexpected Document Status");
            MInOut shipment = new MInOut(salesOrder, DictionaryIDs.C_DocType.MM_SHIPMENT.id, salesOrder.getDateOrdered());
            shipment.setDocStatus("DR");
            shipment.setDocAction("CO");
            shipment.saveEx();
            MInOutLine shipmentLine = new MInOutLine(shipment);
            shipmentLine.setOrderLine(salesLine1, 0, salesQty);
            shipmentLine.setQty(salesQty);
            shipmentLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            shipment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus(), (String)"Unexpected Document Status");
            MInvoice invoice = new MInvoice(receipt, receipt.getMovementDate());
            invoice.setC_DocTypeTarget_ID("API");
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setM_InOutLine_ID(receiptLine.get_ID());
            invoiceLine.setLine(10);
            invoiceLine.setProduct(product);
            invoiceLine.setQty(BigDecimal.TEN);
            BigDecimal invoicePrice = new BigDecimal("2.50");
            invoiceLine.setPrice(invoicePrice);
            invoiceLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
            if (!invoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)invoice.isPosted());
            MMatchInv[] mMatchInvArray = miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
            int n = miList.length;
            int n2 = 0;
            while (n2 < n) {
                MMatchInv mi = mMatchInvArray[n2];
                if (!mi.isPosted()) {
                    String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)mi.getAD_Client_ID(), (int)472, (int)mi.get_ID(), (boolean)false, (String)this.getTrxName());
                    Assertions.assertTrue((error == null ? 1 : 0) != 0);
                }
                mi.load(this.getTrxName(), new String[0]);
                Assertions.assertTrue((boolean)mi.isPosted());
                cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
                Assertions.assertNotNull((Object)cost, (String)"No MCost record found");
                Assertions.assertEquals((Object)invoicePrice, (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
                pc = new ProductCost(Env.getCtx(), mi.getM_Product_ID(), mi.getM_AttributeSetInstance_ID(), this.getTrxName());
                MAccount acctInvClr = pc.getAccount(10, as);
                MAccount acctAsset = pc.getAccount(3, as);
                MAccount varianceAccount = pc.getAccount(23, as);
                Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)invoice.get_ID(), (String)this.getTrxName());
                MAccount nirAccount = doc.getAccount(51, as);
                int C_AcctSchema_ID = as.getC_AcctSchema_ID();
                Query query = MFactAcct.createRecordIdQuery((int)472, (int)mi.get_ID(), (int)C_AcctSchema_ID, (String)this.getTrxName());
                List factAccts = query.list();
                BigDecimal stockBalance = BigDecimal.TEN.subtract(salesQty);
                BigDecimal assetAmt = invoicePrice.subtract(orderPrice).multiply(stockBalance);
                List<FactAcct> expected = Arrays.asList(new FactAcct(acctAsset, assetAmt, 2, true), new FactAcct(varianceAccount, invoicePrice.subtract(orderPrice).multiply(BigDecimal.TEN.subtract(stockBalance)), 2, true), new FactAcct(nirAccount, orderPrice.multiply(BigDecimal.TEN), 2, true), new FactAcct(acctInvClr, invoicePrice.multiply(BigDecimal.TEN), 2, false));
                this.assertFactAcctEntries(factAccts, expected);
                ++n2;
            }
            Env.setContext((Properties)Env.getCtx(), (String)"#Date", (Timestamp)tomorrow);
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"RA");
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"RE", (Object)invoice.getDocStatus());
            Assertions.assertTrue((invoice.getReversal_ID() > 0 ? 1 : 0) != 0, (String)"No reversal invoice id");
            MInvoice reversalInvoice = new MInvoice(Env.getCtx(), invoice.getReversal_ID(), this.getTrxName());
            Assertions.assertEquals((int)invoice.getReversal_ID(), (int)reversalInvoice.get_ID(), (String)"Failed to load reversal invoice");
            if (!reversalInvoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)reversalInvoice.getAD_Client_ID(), (int)318, (int)reversalInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            reversalInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)reversalInvoice.isPosted());
            pc = miList;
            int n3 = miList.length;
            n = 0;
            while (n < n3) {
                MMatchInv mi = pc[n];
                mi.load(this.getTrxName(), new String[0]);
                Query query = MFactAcct.createRecordIdQuery((int)472, (int)mi.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
                Object factAccts = query.list();
                query = MFactAcct.createRecordIdQuery((int)472, (int)mi.getReversal_ID(), (int)as.get_ID(), (String)this.getTrxName());
                List rFactAccts = query.list();
                ArrayList<FactAcct> expected = new ArrayList<FactAcct>();
                Iterator C_AcctSchema_ID = factAccts.iterator();
                while (C_AcctSchema_ID.hasNext()) {
                    MFactAcct factAcct = (MFactAcct)C_AcctSchema_ID.next();
                    MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                    if (factAcct.getAmtAcctDr().signum() != 0) {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 2, false));
                        continue;
                    }
                    if (factAcct.getAmtAcctCr().signum() == 0) continue;
                    expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 2, true));
                }
                this.assertFactAcctEntries(rFactAccts, expected);
                Optional<MAcctSchema> optional = Arrays.stream(ass).filter(e -> e.getC_AcctSchema_ID() != as.get_ID()).findFirst();
                if (optional.isPresent()) {
                    MAcctSchema as2 = optional.get();
                    query = MFactAcct.createRecordIdQuery((int)472, (int)mi.get_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                    factAccts = query.list();
                    query = MFactAcct.createRecordIdQuery((int)472, (int)mi.getReversal_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                    rFactAccts = query.list();
                    expected = new ArrayList();
                    Iterator iterator = factAccts.iterator();
                    while (iterator.hasNext()) {
                        MFactAcct factAcct = (MFactAcct)iterator.next();
                        MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                        if (factAcct.getAmtAcctDr().signum() != 0) {
                            expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 2, false));
                            continue;
                        }
                        if (factAcct.getAmtAcctCr().signum() == 0) continue;
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 2, true));
                    }
                    this.assertFactAcctEntries(rFactAccts, expected);
                }
                ++n;
            }
            Query query = MFactAcct.createRecordIdQuery((int)318, (int)invoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            query = MFactAcct.createRecordIdQuery((int)318, (int)invoice.getReversal_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List rFactAccts = query.list();
            ArrayList<FactAcct> expected = new ArrayList<FactAcct>();
            for (MFactAcct factAcct : factAccts) {
                MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                if (factAcct.getAmtAcctDr().signum() != 0) {
                    expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 2, false));
                    continue;
                }
                if (factAcct.getAmtAcctCr().signum() == 0) continue;
                expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 2, true));
            }
            this.assertFactAcctEntries(rFactAccts, expected);
            Optional<MAcctSchema> optional = Arrays.stream(ass).filter(e -> e.getC_AcctSchema_ID() != as.get_ID()).findFirst();
            if (optional.isPresent()) {
                MAcctSchema as2 = optional.get();
                query = MFactAcct.createRecordIdQuery((int)318, (int)invoice.get_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                factAccts = query.list();
                query = MFactAcct.createRecordIdQuery((int)318, (int)invoice.getReversal_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                rFactAccts = query.list();
                expected = new ArrayList();
                for (MFactAcct factAcct : factAccts) {
                    MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                    if (factAcct.getAmtAcctDr().signum() != 0) {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 2, false));
                        continue;
                    }
                    if (factAcct.getAmtAcctCr().signum() == 0) continue;
                    expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 2, true));
                }
                this.assertFactAcctEntries(rFactAccts, expected);
            }
        }
        catch (Throwable throwable) {
            this.rollback();
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
            ConversionRateHelper.deleteConversionRate(cr1);
            ConversionRateHelper.deleteConversionRate(cr2);
            if (allowNegatives.size() > 0) {
                allowNegatives.forEach(e -> {
                    e.setIsAllowNegativePosting(true);
                    e.saveEx();
                });
            }
            throw throwable;
        }
        this.rollback();
        if (product != null) {
            product.set_TrxName(null);
            product.deleteEx(true);
        }
        ConversionRateHelper.deleteConversionRate(cr1);
        ConversionRateHelper.deleteConversionRate(cr2);
        if (allowNegatives.size() > 0) {
            allowNegatives.forEach(e -> {
                e.setIsAllowNegativePosting(true);
                e.saveEx();
            });
        }
    }

    @Test
    public void testAverageCostingIPVPartialMR() {
        MProduct product = null;
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        try {
            MMatchInv[] miList;
            product = new MProduct(Env.getCtx(), 0, null);
            product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            product.setName("testAverageCostingIPVPartialMR");
            product.setProductType("I");
            product.setIsStocked(true);
            product.setIsSold(true);
            product.setIsPurchased(true);
            product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(product.get_ID());
            BigDecimal orderPrice = new BigDecimal("2.00");
            pp.setPriceStd(orderPrice);
            pp.setPriceList(orderPrice);
            pp.saveEx();
            int purchaseId = DictionaryIDs.M_PriceList.PURCHASE.id;
            MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id);
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(bpartner);
            order.setIsSOTrx(false);
            order.setC_DocTypeTarget_ID();
            order.setM_PriceList_ID(purchaseId);
            order.setDocStatus("DR");
            order.setDocAction("CO");
            order.saveEx();
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(10);
            orderLine.setProduct(product);
            orderLine.setQty(BigDecimal.TEN);
            orderLine.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            MInOut receipt = new MInOut(order, 122, order.getDateOrdered());
            receipt.saveEx();
            BigDecimal mrQty = new BigDecimal("5");
            MInOutLine receiptLine = new MInOutLine(receipt);
            receiptLine.setC_OrderLine_ID(orderLine.get_ID());
            receiptLine.setLine(10);
            receiptLine.setProduct(product);
            receiptLine.setQty(mrQty);
            MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
            int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            receiptLine.setM_Locator_ID(M_Locator_ID);
            receiptLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
            if (!receipt.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)receipt.isPosted());
            product.set_TrxName(this.getTrxName());
            MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)cost, (String)"No MCost record found");
            Assertions.assertEquals((Object)orderPrice, (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            MInvoice invoice = new MInvoice(receipt, receipt.getMovementDate());
            invoice.setC_DocTypeTarget_ID("API");
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setM_InOutLine_ID(receiptLine.get_ID());
            invoiceLine.setLine(10);
            invoiceLine.setProduct(product);
            invoiceLine.setQty(BigDecimal.TEN);
            BigDecimal invoicePrice = new BigDecimal("4.00");
            invoiceLine.setPrice(invoicePrice);
            invoiceLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
            if (!invoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)invoice.isPosted());
            MMatchInv[] mMatchInvArray = miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
            int n = miList.length;
            int n2 = 0;
            while (n2 < n) {
                MMatchInv mi = mMatchInvArray[n2];
                if (!mi.isPosted()) {
                    String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)mi.getAD_Client_ID(), (int)472, (int)mi.get_ID(), (boolean)false, (String)this.getTrxName());
                    Assertions.assertTrue((error == null ? 1 : 0) != 0);
                }
                mi.load(this.getTrxName(), new String[0]);
                Assertions.assertTrue((boolean)mi.isPosted());
                cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
                Assertions.assertNotNull((Object)cost, (String)"No MCost record found");
                Assertions.assertEquals((Object)invoicePrice, (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
                ProductCost pc = new ProductCost(Env.getCtx(), mi.getM_Product_ID(), mi.getM_AttributeSetInstance_ID(), this.getTrxName());
                MAccount acctInvClr = pc.getAccount(10, as);
                MAccount acctAsset = pc.getAccount(3, as);
                Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)invoice.get_ID(), (String)this.getTrxName());
                MAccount nirAccount = doc.getAccount(51, as);
                int C_AcctSchema_ID = as.getC_AcctSchema_ID();
                Query query = MFactAcct.createRecordIdQuery((int)472, (int)mi.get_ID(), (int)C_AcctSchema_ID, (String)this.getTrxName());
                List factAccts = query.list();
                BigDecimal assetAmt = invoicePrice.subtract(orderPrice).multiply(mrQty);
                List<FactAcct> expected = Arrays.asList(new FactAcct(acctAsset, assetAmt, 2, true), new FactAcct(nirAccount, orderPrice.multiply(mrQty), 2, true), new FactAcct(acctInvClr, invoicePrice.multiply(mrQty), 2, false));
                this.assertFactAcctEntries(factAccts, expected);
                ++n2;
            }
        }
        finally {
            this.rollback();
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }
}

