/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.grid.CreateFromBatch;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public abstract class CreateFromStatement
extends CreateFromBatch {
    public CreateFromStatement(GridTab mTab) {
        super(mTab);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(mTab.toString());
        }
    }

    @Override
    protected boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(Msg.getElement((Properties)Env.getCtx(), (String)"C_BankStatement_ID") + " .. " + Msg.translate((Properties)Env.getCtx(), (String)"CreateFrom"));
        return true;
    }

    @Override
    protected Vector<Vector<Object>> getBankAccountData(Integer BankAccount, Integer BPartner, String DocumentNo, Timestamp DateFrom, Timestamp DateTo, BigDecimal AmtFrom, BigDecimal AmtTo, Integer DocType, String TenderType, String AuthCode) {
        Vector<Vector<Object>> data;
        block6: {
            data = new Vector<Vector<Object>>();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT p.DateTrx,p.C_Payment_ID,p.DocumentNo, p.C_Currency_ID,c.ISO_Code, p.PayAmt,");
            sql.append("currencyConvertPayment(p.C_Payment_ID,ba.C_Currency_ID), bp.Name ");
            sql.append("FROM C_BankAccount ba");
            sql.append(" INNER JOIN C_Payment_v p ON (p.C_BankAccount_ID=ba.C_BankAccount_ID)");
            sql.append(" INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID)");
            sql.append(" LEFT OUTER JOIN C_BPartner bp ON (p.C_BPartner_ID=bp.C_BPartner_ID) ");
            sql.append(this.getSQLWhere(BPartner, DocumentNo, DateFrom, DateTo, AmtFrom, AmtTo, DocType, TenderType, AuthCode));
            sql.append(" ORDER BY p.DateTrx");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.getTrxName());
                    this.setParameters((PreparedStatement)pstmt, BankAccount, BPartner, DocumentNo, DateFrom, DateTo, AmtFrom, AmtTo, DocType, TenderType, AuthCode);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(6);
                        line.add(Boolean.FALSE);
                        line.add(rs.getTimestamp(1));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(2), rs.getString(3));
                        line.add(pp);
                        pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                        line.add(pp);
                        line.add(rs.getBigDecimal(6));
                        line.add(rs.getBigDecimal(7));
                        line.add(rs.getString(8));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, Timestamp.class, false);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, BigDecimal.class, true);
        miniTable.setColumnClass(5, BigDecimal.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        int C_BankStatement_ID = (Integer)this.getGridTab().getValue("C_BankStatement_ID");
        MBankStatement bs = new MBankStatement(Env.getCtx(), C_BankStatement_ID, trxName);
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(bs.toString());
        }
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                Timestamp trxDate = (Timestamp)miniTable.getValueAt(i, 1);
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                int C_Payment_ID = pp.getKey();
                pp = (KeyNamePair)miniTable.getValueAt(i, 3);
                int C_Currency_ID = pp.getKey();
                BigDecimal TrxAmt = (BigDecimal)miniTable.getValueAt(i, 5);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line Date=" + String.valueOf(trxDate) + ", Payment=" + C_Payment_ID + ", Currency=" + C_Currency_ID + ", Amt=" + String.valueOf(TrxAmt));
                }
                MBankStatementLine bsl = new MBankStatementLine(bs);
                bsl.setStatementLineDate(trxDate);
                bsl.setPayment(new MPayment(Env.getCtx(), C_Payment_ID, trxName));
                bsl.setTrxAmt(TrxAmt);
                bsl.setStmtAmt(TrxAmt);
                bsl.setC_Currency_ID(bs.getBankAccount().getC_Currency_ID());
                if (!bsl.save()) {
                    this.log.log(Level.SEVERE, "Line not created #" + i);
                }
            }
            ++i;
        }
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(7);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"C_Payment_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Amount"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"ConvertedAmount"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        return columnNames;
    }
}

