/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.GridField;
import org.compiere.model.MChangeLog;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.South;

public class WFieldRecordInfo
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 439310027130417727L;
    private int AD_Table_ID;
    private int AD_Column_ID;
    private int Record_ID;
    private String Record_UU;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    private Listbox table = new Listbox();
    private ConfirmPanel confirmPanel = new ConfirmPanel(false);
    private static final CLogger log = CLogger.getCLogger(WFieldRecordInfo.class);
    private Vector<Vector<String>> m_data = new Vector();
    private SimpleDateFormat m_dateTimeFormat = DisplayType.getDateFormat((int)16, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private SimpleDateFormat m_dateFormat = DisplayType.getDateFormat((int)16, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private DecimalFormat m_numberFormat = DisplayType.getNumberFormat((int)22, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private DecimalFormat m_amtFormat = DisplayType.getNumberFormat((int)12, (Language)Env.getLanguage((Properties)Env.getCtx()));
    private DecimalFormat m_intFormat = DisplayType.getNumberFormat((int)11, (Language)Env.getLanguage((Properties)Env.getCtx()));

    public WFieldRecordInfo(String title, int AD_Table_ID, int AD_Column_ID, int Record_ID, String Record_UU) {
        this.setTitle(title);
        this.setAttribute("mode", "highlighted");
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 640);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 480);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.setBorder("normal");
        this.setSizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.AD_Table_ID = AD_Table_ID;
        this.AD_Column_ID = AD_Column_ID;
        this.Record_ID = Record_ID;
        this.Record_UU = Record_UU;
        try {
            this.init(this.dynInit(title));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        AEnv.showCenterScreen(this);
    }

    private void init(boolean showTable) throws Exception {
        Borderlayout layout = new Borderlayout();
        layout.setParent((Component)this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)layout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)layout, "100%");
        Center center = new Center();
        center.setParent((Component)layout);
        if (showTable) {
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.table, "true");
            ZKUpdateUtil.setVflex((HtmlBasedComponent)this.table, "true");
            center.appendChild((Component)this.table);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.table, "100%");
        }
        South south = new South();
        south.setParent((Component)layout);
        south.appendChild((Component)this.confirmPanel);
        this.confirmPanel.addActionListener("onClick", this);
        this.addEventListener("onCancel", e -> this.onCancel());
        this.setSclass("field-record-info-dialog");
    }

    private boolean dynInit(String title) {
        block10: {
            if (this.AD_Table_ID != 0) {
                MTable table1 = MTable.get((Properties)Env.getCtx(), (int)this.AD_Table_ID);
                this.setTitle(title + " - " + table1.getName());
            }
            if (!"C".equals(MRole.getDefault().getPreferenceType())) {
                return false;
            }
            if (this.Record_ID == 0 && Util.isEmpty((String)this.Record_UU)) {
                return false;
            }
            String sql = "SELECT AD_Column_ID, Updated, UpdatedBy, OldValue, NewValue FROM AD_ChangeLog WHERE AD_Table_ID=? AND (Record_ID=? OR Record_UU=?) AND AD_Column_ID=? ORDER BY Updated DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.AD_Table_ID);
                    pstmt.setInt(2, this.Record_ID);
                    pstmt.setString(3, this.Record_UU);
                    pstmt.setInt(4, this.AD_Column_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.addLine(rs.getInt(1), rs.getTimestamp(2), rs.getInt(3), rs.getString(4), rs.getString(5));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"NewValue"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"OldValue"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"UpdatedBy"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Updated"));
        Listhead listhead = new Listhead();
        listhead.setSizable(true);
        int i = 0;
        while (i < columnNames.size()) {
            Listheader listheader = new Listheader(((String)columnNames.get(i)).replaceAll("[&]", ""));
            listhead.appendChild((Component)listheader);
            ++i;
        }
        this.table.appendChild((Component)listhead);
        SimpleListModel model = new SimpleListModel(this.m_data);
        this.table.setItemRenderer(model);
        this.table.setModel((ListModel)model);
        return true;
    }

    private void addLine(int AD_Column_ID, Timestamp Updated, int UpdatedBy, String OldValue, String NewValue) {
        Vector<String> line = new Vector<String>();
        MColumn column = MColumn.get((Properties)Env.getCtx(), (int)AD_Column_ID);
        if (OldValue != null && OldValue.equals(MChangeLog.NULL)) {
            OldValue = null;
        }
        String showOldValue = OldValue;
        if (NewValue != null && NewValue.equals(MChangeLog.NULL)) {
            NewValue = null;
        }
        String showNewValue = NewValue;
        try {
            if (!DisplayType.isText((int)column.getAD_Reference_ID())) {
                if (column.getAD_Reference_ID() == 20) {
                    boolean yes;
                    if (OldValue != null) {
                        yes = OldValue.equals("true") || OldValue.equals("Y");
                        showOldValue = Msg.getMsg((Properties)Env.getCtx(), (String)(yes ? "Y" : "N"));
                    }
                    if (NewValue != null) {
                        yes = NewValue.equals("true") || NewValue.equals("Y");
                        showNewValue = Msg.getMsg((Properties)Env.getCtx(), (String)(yes ? "Y" : "N"));
                    }
                } else if (column.getAD_Reference_ID() == 12) {
                    if (OldValue != null) {
                        showOldValue = this.m_amtFormat.format(new BigDecimal(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_amtFormat.format(new BigDecimal(NewValue));
                    }
                } else if (column.getAD_Reference_ID() == 11) {
                    if (OldValue != null) {
                        showOldValue = this.m_intFormat.format(Integer.valueOf(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_intFormat.format(Integer.valueOf(NewValue));
                    }
                } else if (DisplayType.isNumeric((int)column.getAD_Reference_ID())) {
                    if (OldValue != null) {
                        showOldValue = this.m_numberFormat.format(new BigDecimal(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_numberFormat.format(new BigDecimal(NewValue));
                    }
                } else if (column.getAD_Reference_ID() == 15) {
                    if (OldValue != null) {
                        showOldValue = this.m_dateFormat.format(Timestamp.valueOf(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_dateFormat.format(Timestamp.valueOf(NewValue));
                    }
                } else if (column.getAD_Reference_ID() == 16) {
                    if (OldValue != null) {
                        showOldValue = this.m_dateTimeFormat.format(Timestamp.valueOf(OldValue));
                    }
                    if (NewValue != null) {
                        showNewValue = this.m_dateTimeFormat.format(Timestamp.valueOf(NewValue));
                    }
                } else if (DisplayType.isLookup((int)column.getAD_Reference_ID())) {
                    String key;
                    NamePair pp;
                    MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)AD_Column_ID, (int)column.getAD_Reference_ID(), (Language)Env.getLanguage((Properties)Env.getCtx()), (String)column.getColumnName(), (int)column.getAD_Reference_Value_ID(), (boolean)column.isParent(), null);
                    if (OldValue != null && (pp = lookup.get((Object)(key = OldValue))) != null) {
                        showOldValue = pp.getName();
                    }
                    if (NewValue != null && (pp = lookup.get((Object)(key = NewValue))) != null) {
                        showNewValue = pp.getName();
                    }
                } else if (DisplayType.isLOB((int)column.getAD_Reference_ID())) {
                    // empty if block
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, OldValue + "->" + NewValue, (Throwable)e);
        }
        line.add(showNewValue);
        line.add(showOldValue);
        MUser user = MUser.get((Properties)Env.getCtx(), (int)UpdatedBy);
        line.add(user.getName());
        line.add(this.m_dateFormat.format(Updated));
        this.m_data.add(line);
    }

    public void onEvent(Event event) throws Exception {
        this.onCancel();
    }

    private void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.detach();
    }

    public static void start(GridField gridField) {
        new WFieldRecordInfo(gridField.getColumnName(), gridField.getGridTab().getAD_Table_ID(), gridField.getAD_Column_ID(), gridField.getGridTab().getRecord_ID(), gridField.getGridTab().getRecord_UU());
    }

    public static void addMenu(WEditorPopupMenu popupMenu) {
        Menuitem changeLogItem = new Menuitem();
        changeLogItem.setLabel(Msg.getElement((Properties)Env.getCtx(), (String)"AD_ChangeLog_ID"));
        if (ThemeManager.isUseFontIconForImage()) {
            changeLogItem.setIconSclass("z-icon-ChangeLog");
        } else {
            changeLogItem.setImage(ThemeManager.getThemeResource("images/ChangeLog16.png"));
        }
        changeLogItem.setAttribute("EVENT", (Object)"CHANGE_LOG");
        changeLogItem.addEventListener("onClick", (EventListener)popupMenu);
        popupMenu.appendChild((Component)changeLogItem);
    }
}

