/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.compiere.util.Ini;
import org.compiere.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;

public class ComponentBlackListService
implements ServiceListener {
    private ServiceComponentRuntime scrService = null;
    private List<String> blackListComponentNames = null;

    protected ComponentBlackListService(BundleContext context) {
        ServiceReference ref = context.getServiceReference(ServiceComponentRuntime.class);
        this.scrService = (ServiceComponentRuntime)context.getService(ref);
        this.blackListComponentNames = new ArrayList<String>();
        this.retrieveBlacklistCandidates();
        if (!this.blackListComponentNames.isEmpty()) {
            this.disableComponents();
        }
        context.addServiceListener((ServiceListener)this);
    }

    public void stop(BundleContext context) {
        this.scrService = null;
        this.blackListComponentNames = null;
        context.removeServiceListener((ServiceListener)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void retrieveBlacklistCandidates() {
        String path = Ini.getAdempiereHome();
        File file = new File(path, "components.blacklist");
        if (!file.exists()) return;
        BufferedReader br2 = null;
        try {
            FileReader reader = new FileReader(file);
            br2 = new BufferedReader(reader);
            String s = null;
            do {
                if (Util.isEmpty(s = br2.readLine())) continue;
                this.blackListComponentNames.add(s.trim());
            } while (s != null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            if (br2 == null) return;
            try {
                br2.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                if (br2 == null) return;
            }
            catch (Throwable throwable) {
                if (br2 == null) throw throwable;
                try {
                    br2.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                br2.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (br2 == null) return;
        try {
            br2.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private void disableComponents() {
        Collection comps = this.scrService.getComponentDescriptionDTOs(new Bundle[0]);
        for (ComponentDescriptionDTO comp : comps) {
            if (!this.blackListComponentNames.contains(comp.name)) continue;
            this.scrService.disableComponent(comp);
        }
    }

    private void disableComponent(String componentName) {
        Collection comps = this.scrService.getComponentDescriptionDTOs(new Bundle[0]);
        for (ComponentDescriptionDTO comp : comps) {
            if (!comp.name.equals(componentName)) continue;
            this.scrService.disableComponent(comp);
            break;
        }
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference ref;
        String name;
        if (event.getType() == 1 && this.scrService != null && !this.blackListComponentNames.isEmpty() && !Util.isEmpty(name = (String)(ref = event.getServiceReference()).getProperty("component.name")) && this.blackListComponentNames.contains(name)) {
            this.disableComponent(name);
        }
    }
}

