/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCommissionLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Commission;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MCommission
extends X_C_Commission {
    private static final long serialVersionUID = 2702487404398723180L;

    public MCommission(Properties ctx, String C_Commission_UU, String trxName) {
        super(ctx, C_Commission_UU, trxName);
        if (Util.isEmpty(C_Commission_UU)) {
            this.setInitialDefaults();
        }
    }

    public MCommission(Properties ctx, int C_Commission_ID, String trxName) {
        super(ctx, C_Commission_ID, trxName);
        if (C_Commission_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setDocBasisType("I");
        this.setFrequencyType("M");
        this.setListDetails(false);
    }

    public MCommission(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCommission(Properties ctx, int C_Commission_ID, String trxName, String ... virtualColumns) {
        super(ctx, C_Commission_ID, trxName, virtualColumns);
    }

    public MCommissionLine[] getLines() {
        List<MCommissionLine> list = new Query(this.getCtx(), "C_CommissionLine", "IsActive='Y' AND C_Commission_ID=?", this.get_TrxName()).setParameters(this.getC_Commission_ID()).setOrderBy("Line,C_CommissionLine_ID").list();
        MCommissionLine[] retValue = new MCommissionLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Override
    public void setDateLastRun(Timestamp DateLastRun) {
        if (DateLastRun != null) {
            super.setDateLastRun(DateLastRun);
        }
    }

    public int copyLinesFrom(MCommission otherCom) {
        if (otherCom == null) {
            return 0;
        }
        MCommissionLine[] fromLines = otherCom.getLines();
        int count = 0;
        int i2 = 0;
        while (i2 < fromLines.length) {
            MCommissionLine line = new MCommissionLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(fromLines[i2], line, this.getAD_Client_ID(), this.getAD_Org_ID());
            line.setC_Commission_ID(this.getC_Commission_ID());
            if (line.save()) {
                ++count;
            }
            ++i2;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "copyLinesFrom - Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_Charge_ID() == 0 && this.getM_Product_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.translate(this.getCtx(), "ChargeOrProductMandatory"));
            return false;
        }
        return true;
    }
}

