/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MPPProductBOM;

@Process
public class OrderCreateProduction
extends SvrProcess {
    private int p_C_Order_ID = 0;

    protected void prepare() {
        this.p_C_Order_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_Order_ID=" + this.p_C_Order_ID);
        }
        if (this.p_C_Order_ID == 0) {
            throw new IllegalArgumentException("No Order");
        }
        MOrder order = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
        if (order.get_ID() == 0) {
            throw new IllegalArgumentException("Order not found");
        }
        if (!"CO".equals(order.getDocStatus())) {
            throw new IllegalArgumentException("Order not completed");
        }
        String where = this.getOrderLineWhereClause();
        List lines = new Query(this.getCtx(), "C_OrderLine", where, this.get_TrxName()).addJoinClause("JOIN M_Product p ON (C_OrderLine.M_Product_ID=p.M_Product_ID)").setOnlyActiveRecords(true).setParameters(new Object[]{this.p_C_Order_ID}).list();
        MDocType doc = new MDocType(this.getCtx(), order.getC_DocType_ID(), this.get_TrxName());
        int cnt = 0;
        for (MOrderLine line : lines) {
            if (line.getQtyOrdered().subtract(line.getQtyDelivered()).compareTo(Env.ZERO) <= 0 && !doc.getDocSubTypeSO().equals("ON")) continue;
            MProduction production = new MProduction(line);
            MProduct product = new MProduct(this.getCtx(), line.getM_Product_ID(), this.get_TrxName());
            MPPProductBOM productBOM = MPPProductBOM.getDefault((MProduct)product, (String)this.get_TrxName());
            production.setM_Product_ID(line.getM_Product_ID());
            production.setProductionQty(line.getQtyOrdered().subtract(line.getQtyDelivered()));
            production.setDatePromised(line.getDatePromised());
            production.setC_OrderLine_ID(line.getC_OrderLine_ID());
            production.setPP_Product_BOM_ID(productBOM.getPP_Product_BOM_ID());
            int locator = product.getM_Locator_ID();
            if (locator == 0) {
                locator = MWarehouse.get((Properties)this.getCtx(), (int)line.getM_Warehouse_ID()).getDefaultLocator().get_ID();
            }
            production.setM_Locator_ID(locator);
            if (line.getC_BPartner_ID() > 0) {
                production.setC_BPartner_ID(order.getC_BPartner_ID());
            }
            if (line.getC_Project_ID() > 0) {
                production.setC_Project_ID(line.getC_Project_ID());
            } else {
                production.setC_Project_ID(order.getC_Project_ID());
            }
            if (line.getC_Campaign_ID() > 0) {
                production.setC_Campaign_ID(line.getC_Campaign_ID());
            } else {
                production.setC_Campaign_ID(order.getC_Campaign_ID());
            }
            if (line.getC_Activity_ID() > 0) {
                production.setC_Activity_ID(line.getC_Activity_ID());
            } else {
                production.setC_Activity_ID(order.getC_Activity_ID());
            }
            if (line.getUser1_ID() > 0) {
                production.setUser1_ID(line.getUser1_ID());
            } else {
                production.setUser1_ID(order.getUser1_ID());
            }
            if (line.getUser2_ID() > 0) {
                production.setUser2_ID(line.getUser2_ID());
            } else {
                production.setUser2_ID(order.getUser2_ID());
            }
            if (line.getAD_OrgTrx_ID() > 0) {
                production.setAD_OrgTrx_ID(line.getAD_OrgTrx_ID());
            } else {
                production.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
            }
            production.saveEx();
            production.createLines(false);
            production.setIsCreated("Y");
            production.saveEx();
            String msg = Msg.parseTranslation((Properties)this.getCtx(), (String)("@M_Production_ID@ @Created@ " + production.getDocumentNo()));
            this.addBufferLog(production.getM_Production_ID(), null, null, msg, 325, production.getM_Production_ID());
            ++cnt;
        }
        return "@Created@ " + cnt;
    }

    protected String getOrderLineWhereClause() {
        return "C_OrderLine.C_Order_ID=? AND C_OrderLine.Processed='Y' AND p.IsBOM='Y' AND p.IsVerified='Y' AND p.IsAutoProduce='N' AND NOT EXISTS (SELECT 1 FROM M_Production pr WHERE pr.C_OrderLine_ID=C_OrderLine.C_OrderLine_ID)";
    }
}

