/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Properties;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class InventoryTestIsolated
extends AbstractTestCase {
    @Test
    public void testSkipProductWithSerial() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MWarehouse wh = new MWarehouse(Env.getCtx(), DictionaryIDs.M_Warehouse.HQ.id, null);
        boolean disallow = wh.isDisallowNegativeInv();
        MProduct product = null;
        try {
            if (!disallow) {
                wh.setIsDisallowNegativeInv(true);
                wh.saveEx();
                CacheMgt.get().reset("M_Warehouse", wh.get_ID());
            }
            product = new MProduct(ctx, 0, null);
            product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.CHEMICALS.id);
            product.setName("testSkipProductWithSerial");
            product.setValue("testSkipProductWithSerial");
            product.setProductType("I");
            product.setIsStocked(true);
            product.setIsSold(true);
            product.setIsPurchased(true);
            product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.PATIO_CHAIR.id);
            product.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(product.get_ID());
            pp.setPriceStd(new BigDecimal("2"));
            pp.setPriceList(new BigDecimal("2"));
            pp.saveEx();
            MAttributeSetInstance asi = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.PATIO_CHAIR.id);
            asi.setSerNo("testSkipProductWithSerial #1");
            asi.saveEx();
            this.createPOAndMRForProduct(product.get_ID(), asi);
            MStorageOnHand[] onhands = MStorageOnHand.getOfProduct((Properties)Env.getCtx(), (int)product.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)1, (int)onhands.length, (String)"Unexpected number of on hand records");
            Assertions.assertEquals((int)onhands[0].getM_AttributeSetInstance_ID(), (int)asi.get_ID(), (String)"Unexpected M_AttributeSetInstance_ID for on hand record");
            MInventory inventory = new MInventory(ctx, 0, trxName);
            inventory.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.HQ.id);
            inventory.setC_DocType_ID(DictionaryIDs.C_DocType.MATERIAL_PHYSICAL_INVENTORY.id);
            inventory.saveEx();
            MInventoryLine iline = new MInventoryLine(inventory, DictionaryIDs.M_Locator.HQ.id, product.getM_Product_ID(), 0, Env.ONE, Env.ZERO);
            iline.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
            Assertions.assertTrue((boolean)info.isError(), (String)info.getSummary());
        }
        finally {
            this.rollback();
            if (product != null) {
                product.deleteEx(true);
            }
            if (!disallow) {
                wh.setIsDisallowNegativeInv(false);
                wh.saveEx();
                CacheMgt.get().reset("M_Warehouse", wh.get_ID());
            }
        }
    }

    @Test
    public void testSkipProductWithSerial2() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MWarehouse wh = new MWarehouse(Env.getCtx(), DictionaryIDs.M_Warehouse.HQ.id, null);
        boolean disallow = wh.isDisallowNegativeInv();
        MProduct product = null;
        try {
            if (!disallow) {
                wh.setIsDisallowNegativeInv(true);
                wh.saveEx();
                CacheMgt.get().reset("M_Warehouse", wh.get_ID());
            }
            product = new MProduct(ctx, 0, null);
            product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.CHEMICALS.id);
            product.setName("testSkipProductWithSerial2");
            product.setValue("testSkipProductWithSerial2");
            product.setProductType("I");
            product.setIsStocked(true);
            product.setIsSold(true);
            product.setIsPurchased(true);
            product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.PATIO_CHAIR.id);
            product.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(product.get_ID());
            pp.setPriceStd(new BigDecimal("2"));
            pp.setPriceList(new BigDecimal("2"));
            pp.saveEx();
            MAttributeSetInstance asi = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.PATIO_CHAIR.id);
            asi.setSerNo("testSkipProductWithSerial2 #1");
            asi.saveEx();
            this.createPOAndMRForProduct(product.get_ID(), asi);
            MStorageOnHand[] onhands = MStorageOnHand.getOfProduct((Properties)Env.getCtx(), (int)product.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)1, (int)onhands.length, (String)"Unexpected number of on hand records");
            Assertions.assertEquals((int)onhands[0].getM_AttributeSetInstance_ID(), (int)asi.get_ID(), (String)"Unexpected M_AttributeSetInstance_ID for on hand record");
            MAttributeSetInstance asi1 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi1.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.PATIO_CHAIR.id);
            asi1.saveEx();
            this.createPOAndMRForProduct(product.get_ID(), asi1);
            onhands = MStorageOnHand.getOfProduct((Properties)Env.getCtx(), (int)product.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)2, (int)onhands.length, (String)"Unexpected number of on hand records");
            Arrays.sort(onhands, new MStorageOnHand(Env.getCtx(), 0, null));
            Assertions.assertEquals((int)onhands[0].getM_AttributeSetInstance_ID(), (int)asi.get_ID(), (String)"Unexpected M_AttributeSetInstance_ID for first on hand record");
            Assertions.assertEquals((int)onhands[1].getM_AttributeSetInstance_ID(), (int)asi1.get_ID(), (String)"Unexpected M_AttributeSetInstance_ID for second on hand record");
            MInventory inventory = new MInventory(ctx, 0, trxName);
            inventory.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.HQ.id);
            inventory.setC_DocType_ID(DictionaryIDs.C_DocType.MATERIAL_PHYSICAL_INVENTORY.id);
            inventory.saveEx();
            MInventoryLine iline = new MInventoryLine(inventory, DictionaryIDs.M_Locator.HQ.id, product.getM_Product_ID(), 0, new BigDecimal("2"), new BigDecimal("1"));
            iline.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            inventory.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)inventory.getDocStatus());
            onhands = MStorageOnHand.getOfProduct((Properties)Env.getCtx(), (int)product.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)2, (int)onhands.length, (String)"Unexpected number of on hand records");
            Arrays.sort(onhands, new MStorageOnHand(Env.getCtx(), 0, null));
            Assertions.assertEquals((int)onhands[0].getM_AttributeSetInstance_ID(), (int)asi.get_ID(), (String)"Unexpected M_AttributeSetInstance_ID for first on hand record");
            Assertions.assertEquals((int)onhands[1].getM_AttributeSetInstance_ID(), (int)asi1.get_ID(), (String)"Unexpected M_AttributeSetInstance_ID for second on hand record");
            Assertions.assertEquals((int)1, (int)onhands[0].getQtyOnHand().intValue());
            Assertions.assertEquals((int)0, (int)onhands[1].getQtyOnHand().intValue());
        }
        finally {
            this.rollback();
            if (product != null) {
                product.deleteEx(true);
            }
            if (!disallow) {
                wh.setIsDisallowNegativeInv(false);
                wh.saveEx();
                CacheMgt.get().reset("M_Warehouse", wh.get_ID());
            }
        }
    }

    private void createPOAndMRForProduct(int productId, MAttributeSetInstance asi) {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(new MProduct(Env.getCtx(), productId, this.getTrxName()));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt1.setDocStatus("DR");
        receipt1.setDocAction("CO");
        receipt1.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt1);
        receiptLine1.setOrderLine(line1, 0, new BigDecimal("1"));
        receiptLine1.setQty(new BigDecimal("1"));
        if (asi != null) {
            receiptLine1.setM_AttributeSetInstance_ID(asi.get_ID());
        }
        receiptLine1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
        if (!receipt1.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertNull((Object)error, (String)error);
        }
    }
}

