/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTaxDeclaration;
import org.compiere.model.MTaxDeclarationAcct;
import org.compiere.model.MTaxDeclarationLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

@Process
public class TaxDeclarationCreate
extends SvrProcess {
    private int p_C_TaxDeclaration_ID = 0;
    private boolean p_DeleteOld = true;
    private MTaxDeclaration m_td = null;
    private int m_noLines = 0;
    private int m_noAccts = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DeleteOld")) {
                    this.p_DeleteOld = "Y".equals(para[i].getParameter());
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_C_TaxDeclaration_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        int noInvoices;
        block11: {
            String sql;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("C_TaxDeclaration_ID=" + this.p_C_TaxDeclaration_ID);
            }
            this.m_td = new MTaxDeclaration(this.getCtx(), this.p_C_TaxDeclaration_ID, this.get_TrxName());
            if (this.m_td.get_ID() == 0) {
                throw new AdempiereSystemError("@NotFound@ @C_TaxDeclaration_ID@ = " + this.p_C_TaxDeclaration_ID);
            }
            if (this.p_DeleteOld) {
                sql = "DELETE FROM C_TaxDeclarationLine WHERE C_TaxDeclaration_ID=?";
                int no = DB.executeUpdate((String)sql, (int)this.p_C_TaxDeclaration_ID, (boolean)false, (String)this.get_TrxName());
                if (no != 0 && this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Delete Line #" + no);
                }
                if ((no = DB.executeUpdate((String)(sql = "DELETE FROM C_TaxDeclarationAcct WHERE C_TaxDeclaration_ID=?"), (int)this.p_C_TaxDeclaration_ID, (boolean)false, (String)this.get_TrxName())) != 0 && this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Delete Acct #" + no);
                }
            }
            sql = "SELECT * FROM C_Invoice i WHERE TRUNC(i.DateInvoiced) >= ? AND TRUNC(i.DateInvoiced) <= ?  AND Processed='Y' AND NOT EXISTS (SELECT * FROM C_TaxDeclarationLine tdl WHERE i.C_Invoice_ID=tdl.C_Invoice_ID)";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            noInvoices = 0;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setTimestamp(1, this.m_td.getDateFrom());
                    pstmt.setTimestamp(2, this.m_td.getDateTo());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.create(new MInvoice(this.getCtx(), rs, null));
                        ++noInvoices;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        StringBuilder msgreturn = new StringBuilder("@C_Invoice_ID@ #").append(noInvoices).append(" (").append(this.m_noLines).append(", ").append(this.m_noAccts).append(")");
        return msgreturn.toString();
    }

    private void create(MInvoice invoice) {
        block8: {
            MInvoiceTax[] taxes = invoice.getTaxes(false);
            int i = 0;
            while (i < taxes.length) {
                MInvoiceTax tLine = taxes[i];
                MTaxDeclarationLine tdl = new MTaxDeclarationLine(this.m_td, invoice, tLine);
                tdl.setLine((this.m_noLines + 1) * 10);
                if (tdl.save()) {
                    ++this.m_noLines;
                }
                ++i;
            }
            String sql = "SELECT * FROM Fact_Acct WHERE AD_Table_ID=? AND Record_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, 318);
                    pstmt.setInt(2, invoice.getC_Invoice_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MFactAcct fact = new MFactAcct(this.getCtx(), rs, null);
                        MTaxDeclarationAcct tda = new MTaxDeclarationAcct(this.m_td, fact);
                        tda.setLine((this.m_noAccts + 1) * 10);
                        if (!tda.save()) continue;
                        ++this.m_noAccts;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }
}

