import { exec } from 'node:child_process'
import sqlite3 from 'sqlite3'
import path from 'node:path'

export default function sqliteHelper(event: any, callbackFunc: any) {
  const clientId = getCookie(event, 'logship_client_id')
  const userId = getCookie(event, 'logship_user_id')

  let db = new sqlite3.Database(path.resolve(`logship_${clientId}_${userId}.db`))
  if(!db) {
    exec('sqlite3 '+path.resolve(`logship_${clientId}_${userId}.db`))

    db = new sqlite3.Database(path.resolve(`logship_${clientId}_${userId}.db`))
    db.run("CREATE TABLE refresh_tokens (id INTEGER PRIMARY KEY AUTOINCREMENT, refresh_token TEXT, token TEXT, expiration DATETIME NULL)")
  }

  db.serialize(() => {
    callbackFunc(db)

    db.close()
  })
}

/*
const stmt = db.prepare("INSERT INTO users (username, email) VALUES (?, ?)");
stmt.run("john_doe", "[email protected]");
stmt.finalize();
*/

/*
db.all("SELECT * FROM users", (err, rows) => {
if (err) {
console.error("Error querying data:", err);
return;
}
console.log("Query results:", rows);
});
*/

/*
db.run("UPDATE users SET email = ? WHERE username = ?", ["[email protected]", "john_doe"], (err) => {
if (err) {
console.error("Error updating data:", err);
return;
}
console.log("Data updated successfully!");
});
*/

/*
db.run("DELETE FROM users WHERE username = ?", ["john_doe"], (err) => {
if (err) {
console.error("Error deleting data:", err);
return;
}
console.log("Data deleted successfully!");
});
*/