import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import getTokenHelper from "../../../utils/getTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  const res: any = await fetchHelper(event, 'models/c_paymentterm', 'POST', token, {
    AD_Org_ID: {
      id: body.organizationId,
      tableName: 'AD_Org'
    },
    isActive: body.isActive,
    name: body.name,
    value: body.value,
    description: body.description,
    documentNote: body.documentNote,
    afterDelivery: body.afterDelivery,
    netDays: body.netDays,
    netDay: body.netDay,
    graceDays: body.graceDays,
    isDefault: body.isDefault,
    isValid: body.isValid,
    isDueFixed: body.isDueFixed,
    fixMonthCutoff: body.fixMonthCutoff,
    fixMonthDay: body.fixMonthDay,
    fixMonthOffset: body.fixMonthOffset,
    isNextBusinessDay: body.isNextBusinessDay,
    discount: body.discount,
    discount2: body.discount2,
    discountDays: body.discountDays,
    discountDays2: body.discountDays2,
    PaymentTermUsage: {
      id: body.paymentTermUsageId
    },
    tableName: 'C_PaymentTerm'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})