import { string } from 'alga-js'
import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const organizationId = getCookie(event, 'logship_organization_id')
  const query = getQuery(event)

  let limit: number = query?.limit ?? 100
  let offset: number = query?.offset ?? 0
  let filter: string = query?.filter ?? ''

  let filterString = string.urlEncode('isSOTrx eq true AND (isActive eq true OR isActive eq false)')
  if(filter) {
    filterString += string.urlEncode(' AND ') + string.urlEncode(filter)
  }

  const res: any = await event.context.fetch(`views/C_Order_NotFulfilled?$filter=${filterString}&$expand=c_ordersource_id,c_bpartner_location_id,bill_location_id,c_orderline,m_inout&$orderby=${string.urlEncode('c_order_id desc')}&$top=${limit}&$skip=${offset}`, 'GET', token, null)
  if(res) {
    data = res
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error) {
      //@ts-ignore
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})