import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import getTokenHelper from "../../../utils/getTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  const res: any = await fetchHelper(event, 'models/cust_fulfillmentproductpricingrules/'+body.id, 'PUT', token, {
    isActive: body.isActive,
    name: body.name,
    description: body.description,
    fulfillment_order_baseprice: body.fulfillmentOrderBasePrice,
    fulfillment_order_pickprice: body.fulfillmentOrderPickPrice,
    fulfillment_order_qty_pickfree: body.fulfillmentOrderQtyPickFree,
    FulfillOrderBaseWeightMax_1: body.fulfillOrderBaseWeightMax1,
    FulfillOrderBaseWeightMax_2: body.fulfillOrderBaseWeightMax2,
    FulfillOrderBaseWeightPrice_2: body.fulfillOrderBaseWeightPrice2,
    FulfillOrderPickWeightPrice_2: body.fulfillOrderPickWeightPrice2,
    isFulfillGroupFlatPricing: body.isFulfillGroupFlatPricing,
    FulfillGroupFlatPrice_1: body.fulfillGroupFlatPrice1,
    FulfillGroupFlatPrice_2: body.fulfillGroupFlatPrice2,
    FulfillMaterialCosts: body.fulfillMaterialCosts,
    FulfillOnceFee: body.fulfillOnceFee,
    tableName: 'cust_fulfillmentproductpricingrules'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})
