import { string } from 'alga-js'
import refreshTokenHelper from "../../utils/refreshTokenHelper"
import getTokenHelper from "../../utils/getTokenHelper"
import forceLogoutHelper from "../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../utils/errorHandlingHelper"
import fetchHelper from "../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const query = getQuery(event)

  // Build query string from parameters
  const queryParams = []

  // Pagination support
  if (query['$top']) {
    queryParams.push(`$top=${query['$top']}`)
  }
  if (query['$skip']) {
    queryParams.push(`$skip=${query['$skip']}`)
  }

  // Filter by order ID if provided (legacy support)
  if (query.orderId) {
    queryParams.push(`$filter=c_order_id eq ${query.orderId}`)
  }

  // Generic filter support (takes precedence over orderId)
  if (query.filter) {
    // Remove old orderId filter if exists and use the new filter
    const filterIndex = queryParams.findIndex(p => p.startsWith('$filter='))
    if (filterIndex !== -1) {
      queryParams.splice(filterIndex, 1)
    }
    queryParams.push(`$filter=${query.filter}`)
  }

  // Select specific fields if provided
  if (query.select) {
    queryParams.push(`$select=${query.select}`)
  }

  // Order by shipping_date descending by default
  if (!query.orderBy) {
    queryParams.push('$orderby=shipping_date desc')
  } else {
    queryParams.push(`$orderby=${query.orderBy}`)
  }

  const queryString = queryParams.length > 0 ? `?${queryParams.join('&')}` : ''

  const res: any = await fetchHelper(event, `models/cust_fulfillmentfeeline${queryString}`, 'GET', token, null)
  if(res) {
    data = res
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})
