import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.gaapId) {
    newObjValue = {...newObjValue, 
      GAAP: {
        id: body.gaapId
      }
    }
  }
  if(body.costingMethodId) {
    newObjValue = {...newObjValue, 
      CostingMethod: {
        id: body.costingMethodId
      }
    }
  }
  if(body.currencyId) {
    newObjValue = {...newObjValue, 
      C_Currency_ID: {
        id: body.currencyId,
        tableName: 'C_Currency'
      }
    }
  }
  if(body.periodId) {
    newObjValue = {...newObjValue, 
      C_Period_ID: {
        id: body.periodId,
        tableName: 'C_Period'
      }
    }
  }
  if(body.costTypeId) {
    newObjValue = {...newObjValue, 
      M_CostType_ID: {
        id: body.costTypeId,
        tableName: 'M_CostType'
      }
    }
  }
  if(body.costingLevelId) {
    newObjValue = {...newObjValue, 
      CostingLevel: {
        id: body.costingLevelId
      }
    }
  }
  if(body.commitmentTypeId) {
    newObjValue = {...newObjValue, 
      CommitmentType: {
        id: body.commitmentTypeId
      }
    }
  }
  if(body.taxCorrectionTypeId) {
    newObjValue = {...newObjValue, 
      TaxCorrectionType: {
        id: body.taxCorrectionTypeId
      }
    }
  }
  if(body.orgOnlyId) {
    newObjValue = {...newObjValue, 
      AD_OrgOnly_ID: {
        id: body.orgOnlyId,
        tableName: 'AD_Org'
      }
    }
  }

  const res: any = await fetchHelper(event, 'models/c_acctschema/'+body.id, 'PUT', token, {
    isActive: body.isActive,
    name: body.name,
    description: body.description,
    isAccrual: body.isAccrual,
    autoPeriodControl: body.autoPeriodControl,
    Period_OpenHistory: body.periodOpenHistory,
    Period_OpenFuture: body.periodOpenFuture,
    separator: body.separator,
    hasAlias: body.hasAlias,
    hasCombination: body.hasCombination,
    isTradeDiscountPosted: body.isTradeDiscountPosted,
    isDiscountCorrectsTax: body.isDiscountCorrectsTax,
    isAdjustCOGS: body.isAdjustCOGS,
    isPostServices: body.isPostServices,
    isExplicitCostAdjustment: body.isExplicitCostAdjustment,
    isAllowNegativePosting: body.isAllowNegativePosting,
    isPostIfClearingEqual: body.isPostIfClearingEqual,
    ...newObjValue,
    tableName: 'c_acctschema'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})